/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ModHelper {
    public static ModContainer getCallerMod() {
        Class<?> caller = ModHelper.getCallerClass(2);
        if (caller == null) {
            return null;
        }
        String jar = caller.getProtectionDomain().getCodeSource().getLocation().getPath().substring(5);
        if (jar.lastIndexOf(33) == -1) {
            return null;
        }
        jar = jar.substring(0, jar.lastIndexOf(33));
        try {
            jar = URLDecoder.decode(jar, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        File jarFile = new File(jar);
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (!jarFile.equals(mod.getSource())) continue;
            return mod;
        }
        return null;
    }

    public static Class<?> getCallerClass(int offset) {
        StackTraceElement element = new Exception().getStackTrace()[offset + 1];
        try {
            return Class.forName(element.getClassName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

