/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class RayTracing {
    public static Entity getTargetEntity(Entity input, double maxReach) {
        RayTraceResult result = RayTracing.rayTraceWithEntity(input, maxReach);
        return result.field_72313_a == RayTraceResult.Type.ENTITY ? result.field_72308_g : null;
    }

    public static RayTraceResult rayTraceWithEntity(Entity input, double maxReach) {
        double blockDistance = maxReach;
        RayTraceResult result = RayTracing.rayTrace(input, maxReach, 1.0f);
        Vec3d eyes = new Vec3d(input.field_70165_t, input.field_70163_u + (double)input.func_70047_e(), input.field_70161_v);
        if (result != null) {
            blockDistance = result.field_72307_f.func_72438_d(eyes);
        }
        Vec3d look = input.func_70676_i(1.0f);
        Vec3d max = eyes.func_72441_c(look.field_72450_a * maxReach, look.field_72448_b * maxReach, look.field_72449_c * maxReach);
        Vec3d hit = null;
        Entity target = null;
        float area = 1.0f;
        List list = input.field_70170_p.func_175674_a(input, input.func_174813_aQ().func_72321_a(look.field_72450_a * maxReach, look.field_72448_b * maxReach, look.field_72449_c * maxReach).func_72314_b((double)area, (double)area, (double)area), (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity != null && entity.func_70067_L();
            }
        });
        double entityDistance = blockDistance;
        for (int i = 0; i < list.size(); ++i) {
            double eyesDistance;
            Entity entity = (Entity)list.get(i);
            if (entity == input) continue;
            AxisAlignedBB aabb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
            RayTraceResult intercept = aabb.func_72327_a(eyes, max);
            if (aabb.func_72318_a(eyes)) {
                if (!(entityDistance >= 0.0)) continue;
                hit = intercept == null ? eyes : intercept.field_72307_f;
                target = entity;
                entityDistance = 0.0;
                continue;
            }
            if (intercept == null || !((eyesDistance = eyes.func_72438_d(intercept.field_72307_f)) < entityDistance) && entityDistance != 0.0) continue;
            if (entity.func_184208_bv() == input.func_184208_bv() && !input.canRiderInteract()) {
                if (entityDistance != 0.0) continue;
                hit = intercept.field_72307_f;
                target = entity;
                continue;
            }
            hit = intercept.field_72307_f;
            target = entity;
            entityDistance = eyesDistance;
        }
        if (target != null) {
            result = new RayTraceResult(target, hit);
        }
        return result;
    }

    public static RayTraceResult rayTrace(Entity input, double blockReachDistance, float partialTicks) {
        Vec3d eyePos = new Vec3d(input.field_70165_t, input.field_70163_u + (double)input.func_70047_e(), input.field_70161_v);
        Vec3d eyeDir = input.func_70676_i(partialTicks);
        Vec3d eyeReach = eyePos.func_72441_c(eyeDir.field_72450_a * blockReachDistance, eyeDir.field_72448_b * blockReachDistance, eyeDir.field_72449_c * blockReachDistance);
        return input.field_70170_p.func_147447_a(eyePos, eyeReach, false, false, true);
    }
}

