/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import java.nio.FloatBuffer;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import mchorse.mclib.client.render.VertexBuilder;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MatrixUtils;
import mchorse.mclib.utils.ReflectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderingUtils {
    private static final FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer((int)16);

    public static void glRevertRotationScale() {
        matrixBuffer.clear();
        MatrixUtils.matrixToFloatBuffer(matrixBuffer, RenderingUtils.getRevertRotationScale());
        GL11.glMultMatrix((FloatBuffer)matrixBuffer);
    }

    public static Matrix4f getRevertRotationScale() {
        Matrix4d[] transformation = MatrixUtils.getTransformation();
        Matrix4d invertRotScale = new Matrix4d();
        invertRotScale.setIdentity();
        invertRotScale.m00 = transformation[2].m00 != 0.0 ? 1.0 / transformation[2].m00 : 0.0;
        invertRotScale.m11 = transformation[2].m11 != 0.0 ? 1.0 / transformation[2].m11 : 0.0;
        invertRotScale.m22 = transformation[2].m22 != 0.0 ? 1.0 / transformation[2].m22 : 0.0;
        try {
            transformation[1].invert();
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        invertRotScale.mul(transformation[1], invertRotScale);
        return new Matrix4f(invertRotScale);
    }

    public static void glRevertRotationScale(Vector3d rotation, Vector3d scale, MatrixUtils.RotationOrder rotationOrder) {
        double invSx = scale.x != 0.0 ? 1.0 / scale.x : 0.0;
        double invSy = scale.y != 0.0 ? 1.0 / scale.y : 0.0;
        double invSz = scale.z != 0.0 ? 1.0 / scale.z : 0.0;
        GlStateManager.func_179139_a((double)invSx, (double)invSy, (double)invSz);
        float rotx = (float)(-Math.toDegrees(rotation.x));
        float roty = (float)(-Math.toDegrees(rotation.y));
        float rotz = (float)(-Math.toDegrees(rotation.z));
        switch (rotationOrder) {
            case ZYX: {
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case XYZ: {
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case XZY: {
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case YZX: {
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case YXZ: {
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case ZXY: {
                GlStateManager.func_179114_b((float)rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)roty, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }

    public static void renderCircle(Vector3d center, Vector3d normal, float radius, int divisions, Color color, float thickness) {
        RenderingUtils.renderCircleDotted(center, normal, radius, divisions, color, thickness, 0);
    }

    public static void renderCircleDotted(Vector3d center, Vector3d normal, float radius, int divisions, Color color, float thickness, int skipDivision) {
        Matrix3d rotation = new Matrix3d();
        rotation.setIdentity();
        Matrix3d transform = new Matrix3d();
        transform.rotY(Math.toRadians(RenderingUtils.getYaw(normal)));
        rotation.mul(transform);
        transform.rotX(Math.toRadians(RenderingUtils.getPitch(normal)));
        rotation.mul(transform);
        GL11.glColor4f((float)color.r, (float)color.g, (float)color.b, (float)color.a);
        GL11.glLineWidth((float)thickness);
        GL11.glBegin((int)1);
        for (int i = 1; i <= divisions; i += skipDivision + 1) {
            double angle0 = Math.PI * 2 / (double)divisions * (double)(i - 1);
            double angle1 = Math.PI * 2 / (double)divisions * (double)i;
            Vector3d a = new Vector3d((double)radius * Math.cos(angle0), (double)radius * Math.sin(angle0), 0.0);
            Vector3d b = new Vector3d((double)radius * Math.cos(angle1), (double)radius * Math.sin(angle1), 0.0);
            rotation.transform((Tuple3d)a);
            rotation.transform((Tuple3d)b);
            a.add((Tuple3d)center);
            b.add((Tuple3d)center);
            GL11.glVertex3d((double)a.x, (double)a.y, (double)a.z);
            GL11.glVertex3d((double)b.x, (double)b.y, (double)b.z);
        }
        GL11.glEnd();
    }

    public static float getYaw(Vector3f direction) {
        return (float)RenderingUtils.getYaw(new Vector3d(direction));
    }

    public static float getPitch(Vector3f direction) {
        return (float)RenderingUtils.getPitch(new Vector3d(direction));
    }

    public static double getYaw(Vector3d direction) {
        double yaw = Math.atan2(-direction.x, direction.z);
        if ((yaw = Math.toDegrees(yaw)) < -180.0) {
            yaw += 360.0;
        } else if (yaw > 180.0) {
            yaw -= 360.0;
        }
        return -yaw;
    }

    public static double getPitch(Vector3d direction) {
        double pitch = Math.atan2(direction.y, Math.sqrt(direction.x * direction.x + direction.z * direction.z));
        return -Math.toDegrees(pitch);
    }

    public static void renderImage(ResourceLocation image, float scale) {
        RenderingUtils.renderImage(image, scale, new Color(1.0f, 1.0f, 1.0f, 1.0f));
    }

    public static void renderImage(ResourceLocation image, float scale, Color color) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        boolean isCulling = GL11.glIsEnabled((int)2884);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        if (ReflectionUtils.isOptifineShadowPass()) {
            GlStateManager.func_179129_p();
        } else {
            GlStateManager.func_179089_o();
        }
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)color.r, (float)color.g, (float)color.b, (float)color.a);
        buffer.func_181668_a(7, VertexBuilder.getFormat(false, true, false, true));
        int perspective = Minecraft.func_71410_x().field_71474_y.field_74320_O;
        float width = scale * (float)(perspective == 2 ? -1 : 1) * 0.5f;
        float height = scale * 0.5f;
        buffer.func_181662_b((double)(-width), (double)height, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(-width), (double)(-height), 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)width, (double)(-height), 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)width, (double)height, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)width, (double)height, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buffer.func_181662_b((double)width, (double)(-height), 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buffer.func_181662_b((double)(-width), (double)(-height), 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        buffer.func_181662_b((double)(-width), (double)height, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (isCulling) {
            GlStateManager.func_179089_o();
        } else {
            GlStateManager.func_179129_p();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public static Matrix4f getFacingRotation(Facing facing, Vector3f position) {
        return RenderingUtils.getFacingRotation(facing, position, null);
    }

    public static Matrix4f getFacingRotation(Facing facing, Vector3f position, Vector3f direction) {
        if (facing.isDirection && direction == null) {
            throw new IllegalArgumentException("Argument direction cannot be null when the facing mode has isDirection=true");
        }
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        Matrix4f transform = new Matrix4f();
        Matrix4f rotation = new Matrix4f();
        transform.setIdentity();
        float cYaw = -Interpolations.lerp(camera.field_70126_B, camera.field_70177_z, partialTicks);
        float cPitch = Interpolations.lerp(camera.field_70127_C, camera.field_70125_A, partialTicks);
        double cX = Interpolations.lerp(camera.field_70169_q, camera.field_70165_t, (double)partialTicks);
        double cY = Interpolations.lerp(camera.field_70167_r, camera.field_70163_u, (double)partialTicks) + (double)camera.func_70047_e();
        double cZ = Interpolations.lerp(camera.field_70166_s, camera.field_70161_v, (double)partialTicks);
        if (facing.isLookAt && !facing.isDirection) {
            double dX = cX - (double)position.x;
            double dY = cY - (double)position.y;
            double dZ = cZ - (double)position.z;
            double horizontalDistance = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
            cYaw = 180.0f - (float)(Math.toDegrees(MathHelper.func_181159_b((double)dZ, (double)dX)) - 90.0);
            cPitch = (float)Math.toDegrees(MathHelper.func_181159_b((double)dY, (double)horizontalDistance));
        }
        if (facing.isDirection) {
            double lengthSq = direction.lengthSquared();
            if (lengthSq < 1.0E-4) {
                direction.set(1.0f, 0.0f, 0.0f);
            } else if (Math.abs(lengthSq - 1.0) > 1.0E-4) {
                direction.normalize();
            }
        }
        switch (facing) {
            case LOOKAT_XYZ: 
            case ROTATE_XYZ: {
                rotation.rotX((float)Math.toRadians(cPitch));
                transform.mul(rotation);
                rotation.rotY((float)Math.toRadians(180.0f - cYaw));
                transform.mul(rotation);
                break;
            }
            case ROTATE_Y: 
            case LOOKAT_Y: {
                rotation.rotY((float)Math.toRadians(180.0f - cYaw));
                transform.mul(rotation);
                break;
            }
            case LOOKAT_DIRECTION: {
                rotation.setIdentity();
                rotation.rotY((float)Math.toRadians(RenderingUtils.getYaw(direction)));
                transform.mul(rotation);
                rotation.rotX((float)Math.toRadians(RenderingUtils.getPitch(direction) + 90.0f));
                transform.mul(rotation);
                Vector3f cameraDir = new Vector3f((float)(cX - (double)position.x), (float)(cY - (double)position.y), (float)(cZ - (double)position.z));
                Vector3f rotatedNormal = new Vector3f(0.0f, 0.0f, 1.0f);
                transform.transform(rotatedNormal);
                Vector3f projectDir = new Vector3f(direction);
                projectDir.scale(cameraDir.dot(direction));
                cameraDir.sub((Tuple3f)projectDir);
                if ((double)cameraDir.lengthSquared() < 1.0E-30) break;
                cameraDir.normalize();
                Vector3f rotationDirection = new Vector3f();
                rotationDirection.cross(cameraDir, rotatedNormal);
                rotation.rotY(-Math.copySign(cameraDir.angle(rotatedNormal), rotationDirection.dot(direction)));
                transform.mul(rotation);
            }
        }
        return transform;
    }

    public static void glFacingRotation(Facing facing, Vector3f position, Vector3f direction) {
        matrixBuffer.clear();
        MatrixUtils.matrixToFloatBuffer(matrixBuffer, RenderingUtils.getFacingRotation(facing, position, direction));
        GL11.glMultMatrix((FloatBuffer)matrixBuffer);
    }

    public static void glFacingRotation(Facing facing, Vector3f position) {
        RenderingUtils.glFacingRotation(facing, position, null);
    }

    public static enum Facing {
        ROTATE_XYZ("rotate_xyz"),
        ROTATE_Y("rotate_y"),
        LOOKAT_XYZ("lookat_xyz", true, false),
        LOOKAT_Y("lookat_y", true, false),
        LOOKAT_DIRECTION("lookat_direction", true, true);

        public final String id;
        public final boolean isLookAt;
        public final boolean isDirection;

        public static Facing fromString(String string) {
            for (Facing facing : Facing.values()) {
                if (!facing.id.equals(string)) continue;
                return facing;
            }
            return null;
        }

        private Facing(String id, boolean isLookAt, boolean isDirection) {
            this.id = id;
            this.isLookAt = isLookAt;
            this.isDirection = isDirection;
        }

        private Facing(String id) {
            this(id, false, false);
        }
    }
}

