/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mchorse.mclib.config.values.GenericBaseValue;
import mchorse.mclib.config.values.GenericValue;
import mchorse.mclib.network.IByteBufSerializable;
import mchorse.mclib.network.INBTSerializable;
import mchorse.mclib.utils.ICopy;
import mchorse.mclib.utils.Interpolation;
import net.minecraft.nbt.NBTTagCompound;

public class ValueSerializer
implements IByteBufSerializable,
INBTSerializable,
ICopy<ValueSerializer> {
    private final Map<String, Value<?>> pool = new LinkedHashMap();
    private final Map<String, String> nbtMap = new HashMap<String, String>();
    private final Map<String, String> jsonMap = new HashMap<String, String>();

    public <T> Value<T> registerValue(GenericBaseValue<T> value) {
        return this.poolValue(value);
    }

    public Optional<GenericBaseValue<?>> getValue(String path) {
        return this.pool.containsKey(path) ? Optional.of(((Value)this.pool.get(path)).value) : Optional.empty();
    }

    public List<GenericBaseValue<?>> getValues() {
        ArrayList values = new ArrayList();
        for (Value<?> value : this.pool.values()) {
            values.add(((Value)value).value);
        }
        return values;
    }

    @Deprecated
    public void registerNBTValue(String nbt, GenericBaseValue<?> value) {
        this.registerValue(nbt, "", value, false, false);
    }

    @Deprecated
    public void registerNBTValue(String nbt, GenericBaseValue<?> value, boolean alwaysWrite) {
        this.registerValue(nbt, "", value, alwaysWrite, false);
    }

    @Deprecated
    public void registerJSONValue(String json, GenericBaseValue<?> value) {
        this.registerValue("", json, value, false, false);
    }

    @Deprecated
    public void registerJSONValue(String json, GenericBaseValue<?> value, boolean alwaysWrite) {
        this.registerValue("", json, value, false, alwaysWrite);
    }

    @Deprecated
    public void registerValue(String nbt, String json, GenericBaseValue<?> value) {
        this.registerValue(nbt, json, value, false, false);
    }

    @Deprecated
    public void registerValue(String nbt, String json, GenericBaseValue<?> value, boolean alwaysWriteNBT, boolean alwaysWriteJSON) {
        Value<?> packet;
        if (!nbt.isEmpty() && !this.nbtMap.containsKey(nbt)) {
            packet = this.poolValue(value);
            packet.serializeNBT(nbt, alwaysWriteNBT);
        }
        if (!json.isEmpty() && !this.jsonMap.containsKey(json)) {
            packet = this.poolValue(value);
            packet.serializeJSON(json, alwaysWriteJSON);
        }
    }

    protected <T> Value<T> poolValue(GenericBaseValue<T> value) {
        Value<Object> packet;
        String key = value.getPath();
        if (this.pool.containsKey(key) && ((Value)this.pool.get(key)).value != value) {
            throw new IllegalArgumentException("The provided value's path is already registered with a different value reference.");
        }
        if (this.pool.containsKey(key)) {
            packet = this.pool.get(key);
        } else {
            packet = new Value<T>(value, this);
            this.pool.put(key, packet);
        }
        return packet;
    }

    protected void putNBTValue(String name, Value<?> value) {
        String key = ((Value)value).value.getPath();
        if (this.nbtMap.containsKey(name) && !this.nbtMap.get(name).equals(key)) {
            throw new IllegalArgumentException("The provided nbt name is already registered with a different value reference.");
        }
        if (this.pool.containsKey(key) && ((Value)this.pool.get(key)).value != ((Value)value).value) {
            throw new IllegalArgumentException("The provided value's path is already registered with a different value reference.");
        }
        this.pool.put(key, value);
        this.nbtMap.put(name, key);
    }

    protected void putJSONValue(String name, Value<?> value) {
        String key = ((Value)value).value.getPath();
        if (this.jsonMap.containsKey(name) && !this.jsonMap.get(name).equals(key)) {
            throw new IllegalArgumentException("The provided json name is already registered with a different value reference.");
        }
        if (this.pool.containsKey(key) && ((Value)this.pool.get(key)).value != ((Value)value).value) {
            throw new IllegalArgumentException("The provided value's path is already registered with a different value reference.");
        }
        this.pool.put(key, value);
        this.jsonMap.put(name, key);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        for (Value<?> value : this.pool.values()) {
            ((Value)value).value.valueFromBytes(buffer);
        }
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        for (Value<?> value : this.pool.values()) {
            ((Value)value).value.valueToBytes(buffer);
        }
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        for (Map.Entry<String, String> entry : this.nbtMap.entrySet()) {
            Value<?> packet = this.pool.get(entry.getValue());
            GenericBaseValue value = ((Value)packet).value;
            String key = entry.getKey();
            if (!tag.func_74764_b(key)) continue;
            value.valueFromNBT(tag.func_74781_a(key));
        }
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound tag) {
        for (Map.Entry<String, String> entry : this.nbtMap.entrySet()) {
            Value<?> packet = this.pool.get(entry.getValue());
            GenericBaseValue value = ((Value)packet).value;
            if (!((Value)packet).nbtAlwaysWrite && value instanceof GenericValue && !((GenericValue)value).hasChanged()) continue;
            tag.func_74782_a(entry.getKey(), value.valueToNBT());
        }
        return tag;
    }

    public JsonElement toJSON() {
        JsonObject jsonRoot = new JsonObject();
        for (Map.Entry<String, String> entry : this.jsonMap.entrySet()) {
            Value<?> packet = this.pool.get(entry.getValue());
            GenericBaseValue value = ((Value)packet).value;
            if (!((Value)packet).jsonAlwaysWrite && value instanceof GenericValue && !((GenericValue)value).hasChanged()) continue;
            jsonRoot.add(entry.getKey(), value.valueToJSON());
        }
        return jsonRoot;
    }

    public void fromJSON(JsonElement element) {
        if (!element.isJsonObject()) {
            return;
        }
        JsonObject jsonObject = element.getAsJsonObject();
        for (Map.Entry<String, String> entry : this.jsonMap.entrySet()) {
            Value<?> packet = this.pool.get(entry.getValue());
            GenericBaseValue value = ((Value)packet).value;
            String key = entry.getKey();
            if (!jsonObject.has(key)) continue;
            value.valueFromJSON(jsonObject.get(key));
        }
    }

    public void copyValues(ValueSerializer origin) {
        for (Map.Entry<String, Value<?>> originEntry : origin.pool.entrySet()) {
            if (!((Value)originEntry.getValue()).copyable) continue;
            ((Value)this.pool.get(originEntry.getKey())).value.copy(((Value)originEntry.getValue()).value);
        }
    }

    public boolean equalsValues(ValueSerializer serializer) {
        for (Map.Entry<String, Value<?>> entryOrigin : serializer.pool.entrySet()) {
            String path = entryOrigin.getKey();
            GenericBaseValue originValue = ((Value)entryOrigin.getValue()).value;
            if (!this.pool.containsKey(path) || ((Value)this.pool.get(path)).value.equals(originValue)) continue;
            return false;
        }
        return true;
    }

    public void interpolateFrom(Interpolation interpolation, ValueSerializer from, float factor) {
        for (Map.Entry<String, Value<?>> entryOrigin : from.pool.entrySet()) {
            String path = entryOrigin.getKey();
            GenericBaseValue originValue = ((Value)entryOrigin.getValue()).value;
            if (!this.pool.containsKey(path)) continue;
            ((Value)this.pool.get(path)).value.setValue(originValue.interpolate(interpolation, ((Value)this.pool.get(path)).value, factor));
        }
    }

    @Override
    public ValueSerializer copy() {
        ValueSerializer copy = new ValueSerializer();
        copy.copy(this);
        return copy;
    }

    @Override
    public void copy(ValueSerializer origin) {
        this.jsonMap.clear();
        this.jsonMap.putAll(origin.jsonMap);
        this.nbtMap.clear();
        this.nbtMap.putAll(origin.nbtMap);
        for (Map.Entry<String, Value<?>> entryOrigin : origin.pool.entrySet()) {
            this.pool.put(entryOrigin.getKey(), entryOrigin.getValue().copy(this));
        }
    }

    public static class Value<T> {
        private String nbt;
        private boolean nbtAlwaysWrite;
        private String json;
        private boolean jsonAlwaysWrite;
        private boolean copyable = true;
        private GenericBaseValue<T> value;
        private ValueSerializer serializer;

        public Value(GenericBaseValue<T> value, ValueSerializer serializer) {
            this.value = value;
            this.serializer = serializer;
        }

        public Value<T> serializeNBT(String nbt) {
            return this.serializeNBT(nbt, false);
        }

        public Value<T> serializeNBT(String nbt, boolean alwaysWrite) {
            this.nbt = nbt;
            this.nbtAlwaysWrite = alwaysWrite;
            this.serializer.putNBTValue(nbt, this);
            return this;
        }

        public Value<T> serializeJSON(String json) {
            return this.serializeJSON(json, false);
        }

        public Value<T> serializeJSON(String json, boolean alwaysWrite) {
            this.json = json;
            this.jsonAlwaysWrite = alwaysWrite;
            this.serializer.putJSONValue(json, this);
            return this;
        }

        public Value<T> copyable() {
            this.copyable = true;
            return this;
        }

        public Value<T> nonCopyable() {
            this.copyable = false;
            return this;
        }

        public Value<T> copy(ValueSerializer destinationSerializer) {
            Value<T> copy = new Value<T>(this.value.copy(), destinationSerializer);
            copy.json = this.json;
            copy.jsonAlwaysWrite = this.jsonAlwaysWrite;
            copy.nbt = this.nbt;
            copy.nbtAlwaysWrite = this.nbtAlwaysWrite;
            copy.copyable = this.copyable;
            return copy;
        }
    }
}

