/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils.wav;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.utils.wav.Wave;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Waveform {
    public float[] average;
    public float[] maximum;
    private List<WaveformSprite> sprites = new ArrayList<WaveformSprite>();
    private int w;
    private int h;
    private int pixelsPerSecond;

    public void generate(Wave data, int pixelsPerSecond, int height) {
        if (data.getBytesPerSample() != 2) {
            throw new IllegalStateException("Waveform generation doesn't support non 16-bit audio data!");
        }
        this.populate(data, pixelsPerSecond, height);
        this.render();
    }

    public void render() {
        this.delete();
        int maxTextureSize = GL11.glGetInteger((int)3379) / 2;
        int count = (int)Math.ceil((double)this.w / (double)maxTextureSize);
        int offset = 0;
        for (int t = 0; t < count; ++t) {
            int texture = GlStateManager.func_179146_y();
            int width = Math.min(this.w - offset, maxTextureSize);
            BufferedImage image = new BufferedImage(width, this.h, 2);
            Graphics g = image.getGraphics();
            int i = offset;
            int j = 0;
            int c = Math.min(offset + width, this.average.length);
            while (i < c) {
                float average = this.average[i];
                float maximum = this.maximum[i];
                int maxHeight = (int)(maximum * (float)this.h);
                int avgHeight = (int)(average * (float)(this.h - 1)) + 1;
                if (avgHeight > 0) {
                    g.setColor(Color.WHITE);
                    g.drawRect(j, this.h / 2 - maxHeight / 2, 1, maxHeight);
                    g.setColor(Color.LIGHT_GRAY);
                    g.drawRect(j, this.h / 2 - avgHeight / 2, 1, avgHeight);
                }
                ++i;
                ++j;
            }
            g.dispose();
            TextureUtil.func_110987_a((int)texture, (BufferedImage)image);
            GlStateManager.func_187421_b((int)3553, (int)10242, (int)33071);
            this.sprites.add(new WaveformSprite(texture, width));
            offset += maxTextureSize;
        }
    }

    public void populate(Wave data, int pixelsPerSecond, int height) {
        this.pixelsPerSecond = pixelsPerSecond;
        this.w = (int)(data.getDuration() * (float)pixelsPerSecond);
        this.h = height;
        this.average = new float[this.w];
        this.maximum = new float[this.w];
        int region = data.getScanRegion(pixelsPerSecond);
        for (int i = 0; i < this.w; ++i) {
            int offset = i * region;
            int count = 0;
            float average = 0.0f;
            float maximum = 0.0f;
            for (int j = 0; j < region && offset + j + 1 < data.data.length; j += 2 * data.numChannels) {
                byte a = data.data[offset + j];
                byte b = data.data[offset + j + 1];
                float sample = a + (b << 8);
                maximum = Math.max(maximum, Math.abs(sample));
                average += Math.abs(sample);
                ++count;
            }
            average /= (float)count;
            this.average[i] = average /= 32767.0f;
            this.maximum[i] = maximum /= 32767.0f;
        }
    }

    public void delete() {
        for (WaveformSprite sprite : this.sprites) {
            GlStateManager.func_179150_h((int)sprite.texture);
        }
        this.sprites.clear();
    }

    public boolean isCreated() {
        return !this.sprites.isEmpty();
    }

    public int getPixelsPerSecond() {
        return this.pixelsPerSecond;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public List<WaveformSprite> getSprites() {
        return this.sprites;
    }

    public void draw(int x, int y, int u, int v, int w, int h) {
        this.draw(x, y, u, v, w, h, this.h);
    }

    public void draw(int x, int y, int u, int v, int w, int h, int height) {
        int offset = 0;
        for (WaveformSprite sprite : this.sprites) {
            int sw = sprite.width;
            offset += sw;
            if (w <= 0) break;
            if (u >= offset) continue;
            int so = offset - u;
            GlStateManager.func_179144_i((int)sprite.texture);
            GuiDraw.drawBillboard(x, y, u, v, Math.min(w, so), h, sw, height);
            x += so;
            u += so;
            w -= so;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class WaveformSprite {
        public final int texture;
        public final int width;

        public WaveformSprite(int texture, int width) {
            this.texture = texture;
            this.width = width;
        }
    }
}

