/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import mchorse.metamorph.api.IMorphFactory;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.abilities.IAbility;
import mchorse.metamorph.api.abilities.IAction;
import mchorse.metamorph.api.abilities.IAttackAbility;
import mchorse.metamorph.api.creative.MorphList;
import mchorse.metamorph.api.creative.sections.UserSection;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.vanilla_pack.MetamorphSection;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MorphManager {
    public static final MorphManager INSTANCE = new MorphManager();
    public Map<String, IAbility> abilities = new HashMap<String, IAbility>();
    public Map<String, IAction> actions = new HashMap<String, IAction>();
    public Map<String, IAttackAbility> attacks = new HashMap<String, IAttackAbility>();
    public List<IMorphFactory> factories = new ArrayList<IMorphFactory>();
    public Map<String, MorphSettings> activeSettings = new HashMap<String, MorphSettings>();
    public Set<String> activeBlacklist = new TreeSet<String>();
    public Map<String, String> activeMap = new HashMap<String, String>();
    public final MorphList list = new MorphList();

    public static boolean isBlacklisted(String name) {
        return MorphManager.INSTANCE.activeBlacklist.contains(name);
    }

    public void setActiveBlacklist(World world, Set<String> blacklist) {
        this.activeBlacklist.clear();
        this.activeBlacklist.addAll(blacklist);
        MetamorphSection section = this.list.getSection(MetamorphSection.class);
        if (section != null && world != null) {
            section.reset();
            section.update(world);
        }
    }

    public void setActiveSettings(Map<String, MorphSettings> settings) {
        HashMap<String, MorphSettings> newSettings = new HashMap<String, MorphSettings>();
        for (Map.Entry<String, MorphSettings> entry : settings.entrySet()) {
            String key = entry.getKey();
            MorphSettings setting = this.activeSettings.get(key);
            if (setting == null) {
                setting = entry.getValue();
            } else {
                setting.copy(entry.getValue());
            }
            newSettings.put(key, setting);
        }
        this.activeSettings = newSettings;
    }

    public void setActiveMap(Map<String, String> map) {
        this.activeMap.clear();
        this.activeMap.putAll(map);
    }

    private MorphManager() {
    }

    public void register() {
        this.list.register(new UserSection("user"));
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            this.factories.get(i).register(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerMorphEditors(Minecraft mc, List<GuiAbstractMorph> editors) {
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            this.factories.get(i).registerMorphEditors(mc, editors);
        }
    }

    public boolean hasMorph(String name) {
        if (MorphManager.isBlacklisted(name = this.remap(name))) {
            return false;
        }
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            if (!this.factories.get(i).hasMorph(name)) continue;
            return true;
        }
        return false;
    }

    public AbstractMorph morphFromNBT(NBTTagCompound tag) {
        String name;
        if (tag == null) {
            return null;
        }
        if (tag.func_74764_b("Name")) {
            tag.func_74778_a("Name", this.remap(tag.func_74779_i("Name")));
        }
        if (MorphManager.isBlacklisted(name = tag.func_74779_i("Name"))) {
            return null;
        }
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            AbstractMorph morph;
            if (!this.factories.get(i).hasMorph(name) || (morph = this.factories.get(i).getMorphFromNBT(tag)) == null) continue;
            this.applySettings(morph);
            return morph;
        }
        return null;
    }

    public void applySettings(AbstractMorph morph) {
        morph.setActiveSettings(this.activeSettings.get(morph.name));
    }

    public String morphNameFromEntity(Entity entity) {
        return EntityList.func_191301_a((Entity)entity).toString();
    }

    public String remap(String name) {
        String remapped = this.activeMap.get(name);
        return remapped == null ? name : remapped;
    }
}

