/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.utils.BetterLightsHelper;
import mchorse.mclib.utils.NBTUtils;
import mchorse.mclib.utils.OptifineHelper;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.events.RegisterBlacklistEvent;
import mchorse.metamorph.api.events.RegisterRemapEvent;
import mchorse.metamorph.api.events.RegisterSettingsEvent;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.ISyncableMorph;
import mchorse.metamorph.bodypart.BodyPart;
import mchorse.metamorph.bodypart.BodyPartManager;
import mchorse.metamorph.bodypart.IBodyPartProvider;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MorphUtils {
    public static boolean isRenderingOnScreen = false;

    public static void generateFile(File config, String content) {
        config.getParentFile().mkdirs();
        try {
            PrintWriter writer = new PrintWriter(config);
            writer.print(content);
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static Set<String> reloadBlacklist() {
        RegisterBlacklistEvent event = new RegisterBlacklistEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.blacklist;
    }

    public static Map<String, MorphSettings> reloadMorphSettings() {
        RegisterSettingsEvent event = new RegisterSettingsEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.settings;
    }

    public static Map<String, String> reloadRemapper() {
        RegisterRemapEvent event = new RegisterRemapEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.map;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean render(AbstractMorph morph, EntityLivingBase entity, double x, double y, double z, float yaw, float partialTick) {
        boolean optifineShadows;
        if (morph == null || morph.errorRendering) {
            return false;
        }
        boolean isOptifineShadowPass = OptifineHelper.isOptifineShadowPass() && !BetterLightsHelper.isBetterLightsShadowPass();
        boolean isBetterLightsShadowPass = BetterLightsHelper.isBetterLightsShadowPass();
        boolean isNormalPass = !isOptifineShadowPass && !isBetterLightsShadowPass;
        boolean normalPass = morph.getSettings().shadowOption == 0 || morph.getSettings().shadowOption == 1;
        boolean betterLightsShadows = morph.getSettings().betterLightsShadow;
        boolean bl = optifineShadows = morph.getSettings().shadowOption == 0 || morph.getSettings().shadowOption == 2;
        if (!GuiModelRenderer.isRendering() && (isNormalPass && !normalPass || isOptifineShadowPass && !optifineShadows || isBetterLightsShadowPass && !betterLightsShadows)) {
            return false;
        }
        return MorphUtils.renderDirect(morph, entity, x, y, z, yaw, partialTick);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public static boolean renderDirect(AbstractMorph morph, EntityLivingBase entity, double x, double y, double z, float yaw, float partialTick) {
        if (morph == null || morph.errorRendering) {
            return false;
        }
        try {
            morph.render(entity, x, y, z, yaw, partialTick);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            morph.errorRendering = true;
        }
        finally {
            try {
                Tessellator.func_178181_a().func_178180_c().func_178977_d();
                System.err.println("Unfinished builder comes from class: " + morph.getClass().getName());
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public static boolean renderOnScreen(AbstractMorph morph, EntityPlayer player, int x, int y, float scale, float alpha) {
        if (morph == null || morph.errorRendering) {
            return false;
        }
        try {
            isRenderingOnScreen = true;
            morph.renderOnScreen(player, x, y, scale, alpha);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            morph.errorRendering = true;
        }
        finally {
            isRenderingOnScreen = false;
            try {
                Tessellator.func_178181_a().func_178180_c().func_178977_d();
                System.err.println("Unfinished builder comes from class: " + morph.getClass().getName());
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return false;
    }

    public static AbstractMorph copy(AbstractMorph morph) {
        return morph == null ? null : morph.copy();
    }

    public static boolean pause(AbstractMorph morph, AbstractMorph previous, int offset) {
        if (morph instanceof ISyncableMorph) {
            ((ISyncableMorph)((Object)morph)).pause(previous, offset);
            return true;
        }
        if (morph instanceof IBodyPartProvider) {
            ((IBodyPartProvider)((Object)morph)).getBodyPart().pause(previous, offset);
            return true;
        }
        return false;
    }

    public static boolean resume(AbstractMorph morph) {
        if (morph instanceof ISyncableMorph) {
            ((ISyncableMorph)((Object)morph)).resume();
            return true;
        }
        if (morph instanceof IBodyPartProvider) {
            for (BodyPart part : ((IBodyPartProvider)((Object)morph)).getBodyPart().parts) {
                if (part.morph.isEmpty() || !(part.morph.get() instanceof ISyncableMorph)) continue;
                ((ISyncableMorph)((Object)part.morph.get())).resume();
            }
            return true;
        }
        return false;
    }

    public static NBTTagCompound toNBT(AbstractMorph morph) {
        if (morph == null) {
            return null;
        }
        return morph.toNBT();
    }

    public static void morphToBuf(ByteBuf buffer, AbstractMorph morph) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)(morph == null ? null : morph.toNBT()));
    }

    public static AbstractMorph morphFromBuf(ByteBuf buffer) {
        return MorphManager.INSTANCE.morphFromNBT(NBTUtils.readInfiniteTag((ByteBuf)buffer));
    }

    public static boolean anyMatch(AbstractMorph morph, Predicate<AbstractMorph> condition) {
        while (true) {
            if (condition.test(morph)) {
                return true;
            }
            if (morph instanceof IBodyPartProvider) {
                BodyPartManager mgr = ((IBodyPartProvider)((Object)morph)).getBodyPart();
                for (BodyPart part : mgr.parts) {
                    if (!part.enabled || !MorphUtils.anyMatch(part.morph.get(), condition)) continue;
                    return true;
                }
            }
            if (!(morph instanceof IMorphProvider)) break;
            morph = ((IMorphProvider)((Object)morph)).getMorph();
        }
        return false;
    }
}

