/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.MorphSettings;
import mchorse.metamorph.api.events.RegisterBlacklistEvent;
import mchorse.metamorph.api.events.RegisterRemapEvent;
import mchorse.metamorph.api.events.RegisterSettingsEvent;
import mchorse.metamorph.api.json.MorphSettingsAdapter;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RegisterHandler {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(MorphSettings.class, (Object)new MorphSettingsAdapter()).create();

    @SubscribeEvent
    public void onSettingsReload(RegisterSettingsEvent event) {
        this.loadMorphSettings(event.settings, this.getClass().getClassLoader().getResourceAsStream("assets/metamorph/morphs.json"));
        this.loadMorphSettings(event.settings, Metamorph.proxy.morphs);
    }

    private void loadMorphSettings(Map<String, MorphSettings> settings, File config) {
        try {
            this.loadMorphSettings(settings, new FileInputStream(config));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadMorphSettings(Map<String, MorphSettings> settings, InputStream input) {
        Scanner scanner = new Scanner(input, "UTF-8");
        Type type = new TypeToken<Map<String, MorphSettings>>(){}.getType();
        Map data = (Map)GSON.fromJson(scanner.useDelimiter("\\A").next(), type);
        scanner.close();
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            MorphSettings morphSettings = (MorphSettings)entry.getValue();
            if (settings.containsKey(key)) {
                settings.get(key).copy(morphSettings);
                continue;
            }
            settings.put(key, morphSettings);
        }
    }

    @SubscribeEvent
    public void onRegisterBlacklist(RegisterBlacklistEvent event) {
        event.blacklist.add("metamorph:morph");
        this.loadBlacklist(event.blacklist, Metamorph.proxy.blacklist);
    }

    private void loadBlacklist(Set<String> set, File blacklist) {
        try {
            Scanner scanner = new Scanner((InputStream)new FileInputStream(blacklist), "UTF-8");
            Type type = new TypeToken<List<String>>(){}.getType();
            List data = (List)GSON.fromJson(scanner.useDelimiter("\\A").next(), type);
            set.addAll(data);
            scanner.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onRegisterRemapper(RegisterRemapEvent event) {
        event.map.put("metamorph.Block", "block");
        this.loadMappings(event.map, Metamorph.proxy.remap);
    }

    private void loadMappings(Map<String, String> map, File remap) {
        try {
            Scanner scanner = new Scanner((InputStream)new FileInputStream(remap), "UTF-8");
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map data = (Map)GSON.fromJson(scanner.useDelimiter("\\A").next(), type);
            map.putAll(data);
            scanner.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

