/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.api.morphs.utils;

import net.minecraft.nbt.NBTTagCompound;

public class Hitbox {
    private static final Hitbox DEFAULT = new Hitbox();
    public boolean enabled;
    public float width;
    public float height;
    public float eye;
    public float sneakingHeight;

    public Hitbox() {
        this.reset();
    }

    public void reset() {
        this.enabled = false;
        this.width = 0.6f;
        this.height = 1.8f;
        this.eye = 0.9f;
        this.sneakingHeight = 1.65f;
    }

    public void copy(Hitbox hitbox) {
        this.enabled = hitbox.enabled;
        this.width = hitbox.width;
        this.height = hitbox.height;
        this.eye = hitbox.eye;
        this.sneakingHeight = hitbox.sneakingHeight;
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Hitbox) {
            Hitbox hitbox = (Hitbox)obj;
            return this.enabled == hitbox.enabled && this.width == hitbox.width && this.height == hitbox.height && this.eye == hitbox.eye && this.sneakingHeight == hitbox.sneakingHeight;
        }
        return super.equals(obj);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.enabled) {
            tag.func_74757_a("Enabled", true);
        }
        if (this.width != 0.6f) {
            tag.func_74776_a("Width", this.width);
        }
        if (this.height != 0.6f) {
            tag.func_74776_a("Height", this.height);
        }
        if (this.eye != 0.6f) {
            tag.func_74776_a("Eye", this.eye);
        }
        if (this.sneakingHeight != 0.6f) {
            tag.func_74776_a("Sneak", this.sneakingHeight);
        }
        return tag;
    }

    public void fromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Enabled")) {
            this.enabled = tag.func_74767_n("Enabled");
        }
        if (tag.func_74764_b("Width")) {
            this.width = tag.func_74760_g("Width");
        }
        if (tag.func_74764_b("Height")) {
            this.height = tag.func_74760_g("Height");
        }
        if (tag.func_74764_b("Eye")) {
            this.eye = tag.func_74760_g("Eye");
        }
        if (tag.func_74764_b("Sneak")) {
            this.sneakingHeight = tag.func_74760_g("Sneak");
        }
    }
}

