/*
 * Decompiled with CFR 0.152.
 */
package mchorse.metamorph.capabilities.morphing;

import java.util.ArrayList;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.capabilities.morphing.IMorphing;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class MorphingStorage
implements Capability.IStorage<IMorphing> {
    public NBTBase writeNBT(Capability<IMorphing> capability, IMorphing instance, EnumFacing side) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList acquired = new NBTTagList();
        tag.func_74776_a("lastHealthRatio", instance.getLastHealthRatio());
        tag.func_74757_a("HasSquidAir", instance.getHasSquidAir());
        tag.func_74768_a("SquidAir", instance.getSquidAir());
        tag.func_74776_a("lastHealth", instance.getLastHealth());
        if (instance.getCurrentMorph() != null) {
            NBTTagCompound morph = new NBTTagCompound();
            instance.getCurrentMorph().toNBT(morph);
            tag.func_74782_a("Morph", (NBTBase)morph);
        }
        tag.func_74782_a("Morphs", (NBTBase)acquired);
        for (AbstractMorph acquiredMorph : instance.getAcquiredMorphs()) {
            NBTTagCompound acquiredTag = new NBTTagCompound();
            acquiredMorph.toNBT(acquiredTag);
            acquired.func_74742_a((NBTBase)acquiredTag);
        }
        return tag;
    }

    public void readNBT(Capability<IMorphing> capability, IMorphing instance, EnumFacing side, NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            NBTTagList acquired = tag.func_150295_c("Morphs", 10);
            NBTTagCompound morphTag = tag.func_74775_l("Morph");
            instance.setLastHealthRatio(tag.func_74760_g("LastHealthRatio"));
            instance.setHasSquidAir(tag.func_74767_n("HasSquidAir"));
            instance.setSquidAir(tag.func_74762_e("SquidAir"));
            instance.setLastHealth(tag.func_74760_g("lastHealth"));
            if (!tag.func_82582_d()) {
                instance.setCurrentMorph(MorphManager.INSTANCE.morphFromNBT(morphTag), null, true);
            }
            ArrayList<AbstractMorph> acquiredMorphs = new ArrayList<AbstractMorph>();
            if (!acquired.func_82582_d()) {
                for (int i = 0; i < acquired.func_74745_c(); ++i) {
                    NBTTagCompound acquiredTag = acquired.func_150305_b(i);
                    AbstractMorph morph = MorphManager.INSTANCE.morphFromNBT(acquiredTag);
                    if (morph == null) continue;
                    acquiredMorphs.add(morph);
                }
                instance.setAcquiredMorphs(acquiredMorphs);
            }
        }
    }
}

