/*
 * Decompiled with CFR 0.152.
 */
package mchorse.vanilla_pack;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mchorse.metamorph.Metamorph;
import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.creative.categories.MorphCategory;
import mchorse.metamorph.api.creative.sections.MorphSection;
import mchorse.metamorph.api.morphs.EntityMorph;
import mchorse.vanilla_pack.MetamorphFactory;
import mchorse.vanilla_pack.morphs.BlockMorph;
import mchorse.vanilla_pack.morphs.ItemMorph;
import mchorse.vanilla_pack.morphs.LabelMorph;
import mchorse.vanilla_pack.morphs.PlayerMorph;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MetamorphSection
extends MorphSection {
    private MetamorphFactory factory;
    private Map<String, MorphCategory> categoryMap = new HashMap<String, MorphCategory>();

    public MetamorphSection(MetamorphFactory factory, String title) {
        super(title);
        this.factory = factory;
    }

    @Override
    public void update(World world) {
        boolean full = !this.categories.isEmpty();
        boolean loading = (Boolean)Metamorph.loadEntityMorphs.get();
        if (full || !loading) {
            if (full && !loading) {
                this.reset();
            }
            return;
        }
        for (ResourceLocation rl : EntityList.func_180124_b()) {
            String name = MorphManager.INSTANCE.remap(rl.toString());
            if (!this.factory.hasMorph(name)) continue;
            this.addMorph(world, name);
        }
        PlayerMorph notch = new PlayerMorph();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", "player");
        tag.func_74778_a("Username", "Notch");
        notch.fromNBT(tag);
        this.get("generic").add(new BlockMorph());
        this.get("generic").add(new ItemMorph());
        this.get("generic").add(new LabelMorph());
        this.get("generic").add(notch);
        Iterator<MorphCategory> it = this.categoryMap.values().iterator();
        while (it.hasNext()) {
            if (!it.next().getMorphs().isEmpty()) continue;
            it.remove();
        }
        this.categories.addAll(this.categoryMap.values());
        this.categoryMap.clear();
        for (MorphCategory category : this.categories) {
            category.sort();
        }
    }

    private void addMorph(World world, String name) {
        try {
            EntityMorph morph = this.factory.morphFromName(name);
            EntityLivingBase entity = (EntityLivingBase)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(name), (World)world);
            if (entity == null) {
                System.out.println("Couldn't add morph " + name + ", because it's null!");
                return;
            }
            NBTTagCompound data = entity.serializeNBT();
            morph.name = name;
            String category = "generic";
            if (!name.startsWith("minecraft:")) {
                category = name.substring(0, name.indexOf(":"));
            } else if (entity instanceof EntityDragon || entity instanceof EntityWither || entity instanceof EntityGiantZombie) {
                category = "boss";
            } else if (entity instanceof EntityAnimal || name.equals("minecraft:bat") || name.equals("minecraft:squid")) {
                category = "animal";
            } else if (entity instanceof EntityMob || name.equals("minecraft:ghast") || name.equals("minecraft:magma_cube") || name.equals("minecraft:slime") || name.equals("minecraft:shulker")) {
                category = "hostile";
            }
            EntityUtils.stripEntityNBT(data);
            morph.setEntityData(data);
            this.get(category).add(morph);
        }
        catch (Exception e) {
            System.out.println("An error occured during insertion of " + name + " morph!");
            e.printStackTrace();
        }
    }

    private MorphCategory get(String name) {
        MorphCategory cat = this.categoryMap.get(name);
        if (cat == null) {
            cat = new MorphCategory(this, name);
            this.categoryMap.put(name, cat);
        }
        return cat;
    }

    @Override
    public void reset() {
        this.categories.clear();
    }
}

