/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.pandemonium.common;

import blue.endless.jankson.Comment;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.AnnotatedSettings;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.SettingNamingConvention;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import ladysnake.requiem.Requiem;
import org.quiltmc.loader.api.QuiltLoader;

public final class PandemoniumConfig {
    public static final PossessConfig possession = new PossessConfig();
    private static final AnnotatedSettings settings = AnnotatedSettings.builder().useNamingConvention(SettingNamingConvention.SNAKE_CASE).build();
    private static final ConfigBranch configTree = ConfigTree.builder().fork("possession").applyFromPojo((Object)possession, settings).finishBranch().build();
    private static final Path configPath = QuiltLoader.getConfigDir().resolve("pandemonium.json5");
    private static final JanksonValueSerializer serializer = new JanksonValueSerializer(false);

    public static ConfigBranch configTree() {
        return configTree;
    }

    public static void load() {
        if (Files.exists(configPath, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(configPath, new OpenOption[0]);){
                FiberSerialization.deserialize((ConfigTree)configTree, (InputStream)in, (ValueSerializer)serializer);
            }
            catch (ValueDeserializationException | IOException e) {
                Requiem.LOGGER.error("[Pandemonium] Failed to load config", e);
            }
        }
        PandemoniumConfig.save();
    }

    public static void save() {
        try (OutputStream out = Files.newOutputStream(configPath, new OpenOption[0]);){
            FiberSerialization.serialize((ConfigTree)configTree, (OutputStream)out, (ValueSerializer)serializer);
        }
        catch (IOException e) {
            Requiem.LOGGER.error("[Pandemonium] Failed to save config", (Throwable)e);
        }
    }

    public static class PossessConfig {
        @Comment(value="Toggles whether all mobs can be possessed by default. Individual mobs can still be configured through datapacks.")
        public boolean allowPossessingAllMobs = false;
    }
}

