/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.events;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.voidarkana.marvelous_menagerie.common.effect.MMEffects;
import net.voidarkana.marvelous_menagerie.common.enchantment.MMEnchantmentsClass;
import net.voidarkana.marvelous_menagerie.common.item.custom.AnomalousGogglesItem;
import net.voidarkana.marvelous_menagerie.util.ClientProxy;
import net.voidarkana.marvelous_menagerie.util.config.CommonConfig;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MMClientEvents {
    private static final ResourceLocation WOBBLE = new ResourceLocation("shaders/post/wobble.json");
    private static final ResourceLocation DECONVERGE = new ResourceLocation("shaders/post/deconverge.json");

    @SubscribeEvent
    public void postRenderStage(RenderLevelStageEvent event) {
        Entity player = Minecraft.m_91087_().m_91288_();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            LivingEntity afflicted;
            GameRenderer renderer = Minecraft.m_91087_().f_91063_;
            if (player instanceof LivingEntity && (afflicted = (LivingEntity)player).m_21023_((MobEffect)MMEffects.HALLUCINATING.get())) {
                if (((Boolean)CommonConfig.HALLU_FLASH.get()).booleanValue()) {
                    if (renderer.m_109149_() == null || !WOBBLE.toString().equals(renderer.m_109149_().m_110022_())) {
                        MMClientEvents.attemptLoadShader(WOBBLE);
                    }
                } else if (renderer.m_109149_() == null || !DECONVERGE.toString().equals(renderer.m_109149_().m_110022_())) {
                    MMClientEvents.attemptLoadShader(DECONVERGE);
                }
            } else if (renderer.m_109149_() != null && (DECONVERGE.toString().equals(renderer.m_109149_().m_110022_()) || WOBBLE.toString().equals(renderer.m_109149_().m_110022_()))) {
                renderer.m_109106_(null);
            }
        }
    }

    private static void attemptLoadShader(ResourceLocation resourceLocation) {
        GameRenderer renderer = Minecraft.m_91087_().f_91063_;
        if (ClientProxy.shaderLoadAttemptCooldown <= 0) {
            renderer.m_109128_(resourceLocation);
            if (renderer.m_109149_() == null) {
                ClientProxy.shaderLoadAttemptCooldown = 12000;
                System.out.println("Could not load the shader");
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ClientProxy.shaderLoadAttemptCooldown > 0) {
            --ClientProxy.shaderLoadAttemptCooldown;
        }
    }

    @SubscribeEvent
    public static void getFogDensity(ViewportEvent.RenderFog event) {
        Camera camera = event.getCamera();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockPos blockPos = camera.m_90588_();
        FluidState fluidState = level.m_6425_(blockPos);
        if (camera.m_90583_().m_7098_() >= (double)((float)blockPos.m_123342_() + fluidState.m_76155_((BlockGetter)level, blockPos))) {
            return;
        }
        Fluid fluid = fluidState.m_76152_();
        Entity player = camera.m_90592_();
        if (player.m_5833_()) {
            return;
        }
        ItemStack helmet = AnomalousGogglesItem.getWornItem(player);
        if (!helmet.m_41619_() && helmet.m_41720_() instanceof AnomalousGogglesItem) {
            if ((fluid == Fluids.f_76195_ || fluid == Fluids.f_76194_) && helmet.getEnchantmentLevel((Enchantment)MMEnchantmentsClass.INFERNAL_VISION.get()) > 0) {
                event.scaleFarPlaneDistance(10.0f);
                event.setCanceled(true);
                return;
            }
            if (fluid == Fluids.f_76193_ || fluid == Fluids.f_76192_) {
                event.scaleFarPlaneDistance(10.0f);
                event.setCanceled(true);
                return;
            }
        }
    }
}

