/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.model.entity.animal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.marvelous_menagerie.client.animations.EolactoriaAnims;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.Eolactoria;

public class EolactoriaModel<T extends Eolactoria>
extends MarvelousModel<T> {
    private final ModelPart root;
    private final ModelPart swim_rot;
    private final ModelPart body;
    private final ModelPart leftPectoralFin;
    private final ModelPart rightPectoralFin;
    private final ModelPart rightBackHorn;
    private final ModelPart leftBackHorn;
    private final ModelPart caudalFin;
    private final ModelPart analFin;
    private final ModelPart dorsalFin;
    private final ModelPart rightFrontHorn;
    private final ModelPart leftFrontHorn;

    public EolactoriaModel(ModelPart root) {
        super(0.5f, 1.0f);
        this.root = root.m_171324_("root");
        this.swim_rot = this.root.m_171324_("swim_rot");
        this.body = this.swim_rot.m_171324_("body");
        this.leftPectoralFin = this.body.m_171324_("leftPectoralFin");
        this.rightPectoralFin = this.body.m_171324_("rightPectoralFin");
        this.rightBackHorn = this.body.m_171324_("rightBackHorn");
        this.leftBackHorn = this.body.m_171324_("leftBackHorn");
        this.caudalFin = this.body.m_171324_("caudalFin");
        this.analFin = this.body.m_171324_("analFin");
        this.dorsalFin = this.body.m_171324_("dorsalFin");
        this.rightFrontHorn = this.body.m_171324_("rightFrontHorn");
        this.leftFrontHorn = this.body.m_171324_("leftFrontHorn");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition swim_rot = root.m_171599_("swim_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition body = swim_rot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -5.0f, -3.0f, 4.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(6, 24).m_171488_(-1.0f, -2.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)1.0f));
        PartDefinition leftPectoralFin = body.m_171599_("leftPectoralFin", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0025f)), PartPose.m_171423_((float)2.0f, (float)-1.5f, (float)-1.0f, (float)0.0f, (float)1.0472f, (float)0.0f));
        PartDefinition rightPectoralFin = body.m_171599_("rightPectoralFin", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0025f)), PartPose.m_171423_((float)-2.0f, (float)-1.5f, (float)-1.0f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition rightBackHorn = body.m_171599_("rightBackHorn", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)3.0f));
        PartDefinition leftBackHorn = body.m_171599_("leftBackHorn", CubeListBuilder.m_171558_().m_171514_(12, 11).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 5.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)3.0f));
        PartDefinition caudalFin = body.m_171599_("caudalFin", CubeListBuilder.m_171558_().m_171514_(10, 18).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)3.0f));
        PartDefinition analFin = body.m_171599_("analFin", CubeListBuilder.m_171558_().m_171514_(12, 24).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition dorsalFin = body.m_171599_("dorsalFin", CubeListBuilder.m_171558_().m_171514_(12, 24).m_171488_(0.0f, -2.0f, 0.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)2.0f));
        PartDefinition rightFrontHorn = body.m_171599_("rightFrontHorn", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(0.0f, -1.0f, -6.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)-2.0f, (float)-4.0f, (float)-3.0f));
        PartDefinition leftFrontHorn = body.m_171599_("leftFrontHorn", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(0.0f, -1.0f, -6.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)2.0f, (float)-4.0f, (float)-3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(Eolactoria entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.m_20072_()) {
            this.m_267799_(EolactoriaAnims.SWIM, limbSwing, limbSwingAmount, 2.0f, 3.0f);
            this.swim_rot.f_104203_ = headPitch * ((float)Math.PI / 180);
        }
        this.animateIdle(entity.idleAnimationState, EolactoriaAnims.IDLE, ageInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)entity.getOutOfWaterTicks() / 5.0f - Math.abs(limbSwingAmount)));
        if (entity.flopSide()) {
            this.animateIdle(entity.idleAnimationState, EolactoriaAnims.FLOP1, ageInTicks, 1.0f, (float)entity.getOutOfWaterTicks() / 5.0f);
        } else {
            this.animateIdle(entity.idleAnimationState, EolactoriaAnims.FLOP2, ageInTicks, 1.0f, (float)entity.getOutOfWaterTicks() / 5.0f);
        }
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        if (this.f_102610_) {
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
        }
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

