/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.model.entity.animal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.marvelous_menagerie.client.animations.FalcatusAnims;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.Falcatus;

public class FalcatusModel<T extends Falcatus>
extends MarvelousModel<T> {
    private final ModelPart root;
    private final ModelPart swim_rot;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart horn;
    private final ModelPart leftEye;
    private final ModelPart rightEye;
    private final ModelPart jaw;
    private final ModelPart nose;
    private final ModelPart tail;
    private final ModelPart caudalFin;
    private final ModelPart dorsalFin;
    private final ModelPart leftFin;
    private final ModelPart rightFin;
    private final ModelPart leftPelvicFin;
    private final ModelPart rightPelvicFin;

    public FalcatusModel(ModelPart root) {
        super(0.5f, 1.1f);
        this.root = root.m_171324_("root");
        this.swim_rot = this.root.m_171324_("swim_rot");
        this.body = this.swim_rot.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.horn = this.head.m_171324_("horn");
        this.leftEye = this.head.m_171324_("leftEye");
        this.rightEye = this.head.m_171324_("rightEye");
        this.jaw = this.head.m_171324_("jaw");
        this.nose = this.head.m_171324_("nose");
        this.tail = this.body.m_171324_("tail");
        this.caudalFin = this.tail.m_171324_("caudalFin");
        this.dorsalFin = this.body.m_171324_("dorsalFin");
        this.leftFin = this.body.m_171324_("leftFin");
        this.rightFin = this.body.m_171324_("rightFin");
        this.leftPelvicFin = this.body.m_171324_("leftPelvicFin");
        this.rightPelvicFin = this.body.m_171324_("rightPelvicFin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition swim_rot = root.m_171599_("swim_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)-3.0f));
        PartDefinition body = swim_rot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -3.0f, -4.0f, 5.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)3.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-4.0f));
        PartDefinition horn = head.m_171599_("horn", CubeListBuilder.m_171558_().m_171514_(29, 1).m_171488_(0.0f, -3.0f, -7.0f, 0.0f, 3.0f, 8.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition leftEye = head.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(6, 22).m_171480_().m_171488_(-1.0f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.5f, (float)0.5f, (float)-1.5f));
        PartDefinition rightEye = head.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(6, 22).m_171488_(-1.0f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)0.5f, (float)-1.5f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(14, 14).m_171488_(-1.5f, -0.5f, -3.5f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)-0.5f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-2.0f, -1.0f, -4.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-1.0f, (float)-1.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)5.0f));
        PartDefinition caudalFin = tail.m_171599_("caudalFin", CubeListBuilder.m_171558_().m_171514_(18, 25).m_171488_(0.0f, -4.5f, 0.0f, 0.0f, 9.0f, 2.0f, new CubeDeformation(0.0025f)).m_171514_(2, 33).m_171488_(0.0f, -4.5f, 2.0f, 0.0f, 9.0f, 1.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition dorsalFin = body.m_171599_("dorsalFin", CubeListBuilder.m_171558_().m_171514_(4, 33).m_171488_(0.0f, -2.0f, -1.5f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)2.5f));
        PartDefinition leftFin = body.m_171599_("leftFin", CubeListBuilder.m_171558_().m_171514_(12, 40).m_171488_(0.0f, 0.0f, -2.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0025f)).m_171514_(4, 38).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 41).m_171488_(0.0f, 1.0f, 3.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0025f)), PartPose.m_171423_((float)2.5f, (float)2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition rightFin = body.m_171599_("rightFin", CubeListBuilder.m_171558_().m_171514_(14, 44).m_171488_(0.0f, 0.0f, -2.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0025f)).m_171514_(4, 38).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 41).m_171488_(0.0f, 1.0f, 3.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0025f)), PartPose.m_171423_((float)-2.5f, (float)2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition leftPelvicFin = body.m_171599_("leftPelvicFin", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)1.5f, (float)2.0f, (float)3.0f));
        PartDefinition rightPelvicFin = body.m_171599_("rightPelvicFin", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)-1.5f, (float)2.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Falcatus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.m_20072_()) {
            this.m_267799_(FalcatusAnims.swim, limbSwing, limbSwingAmount * 4.0f, 1.5f, 3.0f);
            this.swim_rot.f_104203_ = headPitch * ((float)Math.PI / 180);
        } else {
            this.swim_rot.m_233569_();
        }
        this.animateIdle(entity.idleAnimationState, FalcatusAnims.idle, ageInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)entity.getOutOfWaterTicks() / 5.0f - Math.abs(limbSwingAmount)));
        this.animateIdle(entity.idleAnimationState, FalcatusAnims.flop, ageInTicks, 1.0f, (float)entity.getOutOfWaterTicks() / 5.0f);
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        if (this.f_102610_) {
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
            poseStack.m_85837_(0.0, 1.1, 0.0);
        }
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

