/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.model.entity.animal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.marvelous_menagerie.client.animations.SlovenicusAnims;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.Slovenicus;

public class SlovenicusModel<T extends Slovenicus>
extends MarvelousModel<T> {
    private final ModelPart root;
    private final ModelPart swim_rot;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart bodyFin;
    private final ModelPart head;
    private final ModelPart snout;
    private final ModelPart leftEye;
    private final ModelPart rightEye;
    private final ModelPart fin;

    public SlovenicusModel(ModelPart root) {
        super(0.6f, 1.0f);
        this.root = root.m_171324_("root");
        this.swim_rot = this.root.m_171324_("swim_rot");
        this.body = this.swim_rot.m_171324_("body");
        this.tail = this.body.m_171324_("tail");
        this.bodyFin = this.body.m_171324_("bodyFin");
        this.head = this.body.m_171324_("head");
        this.snout = this.head.m_171324_("snout");
        this.leftEye = this.head.m_171324_("leftEye");
        this.rightEye = this.head.m_171324_("rightEye");
        this.fin = this.head.m_171324_("fin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition swim_rot = root.m_171599_("swim_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)1.0f));
        PartDefinition body = swim_rot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171488_(-1.5f, -3.0f, -2.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)1.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-0.5f, 0.0f, -3.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition bodyFin = body.m_171599_("bodyFin", CubeListBuilder.m_171558_().m_171514_(12, 15).m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -2.0f, -4.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition snout = head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(8, 7).m_171488_(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(2, 20).m_171488_(-0.5f, -1.5f, -3.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-4.0f));
        PartDefinition leftEye = head.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(6, 15).m_171488_(-1.0f, -1.0f, -2.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-2.0f));
        PartDefinition rightEye = head.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171480_().m_171488_(-1.0f, -1.0f, -2.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0025f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-2.0f, (float)-2.0f));
        PartDefinition fin = head.m_171599_("fin", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(0.0f, -0.5f, 0.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0025f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(Slovenicus entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.m_20072_()) {
            this.m_267799_(SlovenicusAnims.SWIM, limbSwing, limbSwingAmount, 2.0f, 3.0f);
            this.swim_rot.f_104203_ = headPitch * ((float)Math.PI / 180) / 4.0f;
        } else {
            this.swim_rot.m_233569_();
        }
        this.animateIdle(entity.idleAnimationState, SlovenicusAnims.IDLE, ageInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)entity.getOutOfWaterTicks() / 5.0f - Math.abs(limbSwingAmount)));
        this.animateIdle(entity.idleAnimationState, SlovenicusAnims.FLOP, ageInTicks, 1.0f, (float)entity.getOutOfWaterTicks() / 5.0f);
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        if (this.f_102610_) {
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
        }
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

