/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.model.entity.animal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.marvelous_menagerie.client.animations.ThylacineAnims;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.Thylacine;

public class ThylacineModel<T extends Thylacine>
extends MarvelousModel<T> {
    private final ModelPart root;
    private final ModelPart main;
    private final ModelPart body_overlay;
    private final ModelPart body;
    private final ModelPart headrot;
    private final ModelPart head_overlay;
    private final ModelPart head;
    private final ModelPart ear_left;
    private final ModelPart ear_right;
    private final ModelPart eyebrows;
    private final ModelPart snout;
    private final ModelPart jaw_overlay;
    private final ModelPart jaw;
    private final ModelPart tail;
    private final ModelPart arms_overlay;
    private final ModelPart arms;
    private final ModelPart arm_left;
    private final ModelPart arm_right;
    private final ModelPart legs_overlay;
    private final ModelPart legs;
    private final ModelPart leg_left;
    private final ModelPart leg_right;

    public ThylacineModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.main = this.root.m_171324_("main");
        this.body_overlay = this.main.m_171324_("body_overlay");
        this.body = this.body_overlay.m_171324_("body");
        this.headrot = this.body.m_171324_("headrot");
        this.head_overlay = this.headrot.m_171324_("head_overlay");
        this.head = this.head_overlay.m_171324_("head");
        this.ear_left = this.head.m_171324_("ear_left");
        this.ear_right = this.head.m_171324_("ear_right");
        this.eyebrows = this.head.m_171324_("eyebrows");
        this.snout = this.head.m_171324_("snout");
        this.jaw_overlay = this.head.m_171324_("jaw_overlay");
        this.jaw = this.jaw_overlay.m_171324_("jaw");
        this.tail = this.body.m_171324_("tail");
        this.arms_overlay = this.main.m_171324_("arms_overlay");
        this.arms = this.arms_overlay.m_171324_("arms");
        this.arm_left = this.arms.m_171324_("arm_left");
        this.arm_right = this.arms.m_171324_("arm_right");
        this.legs_overlay = this.main.m_171324_("legs_overlay");
        this.legs = this.legs_overlay.m_171324_("legs");
        this.leg_left = this.legs.m_171324_("leg_left");
        this.leg_right = this.legs.m_171324_("leg_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition main = root.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition body_overlay = main.m_171599_("body_overlay", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)5.0f));
        PartDefinition body = body_overlay.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -2.5f, -13.0f, 5.0f, 5.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(27, 0).m_171488_(-2.5f, -2.5f, -13.0f, 5.0f, 7.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headrot = body.m_171599_("headrot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-13.0f));
        PartDefinition head_overlay = headrot.m_171599_("head_overlay", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = head_overlay.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(17, 22).m_171488_(-3.0f, -4.0f, -5.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition ear_left = head.m_171599_("ear_left", CubeListBuilder.m_171558_().m_171514_(9, 4).m_171488_(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-4.0f, (float)-1.0f));
        PartDefinition ear_right = head.m_171599_("ear_right", CubeListBuilder.m_171558_().m_171514_(9, 0).m_171488_(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-4.0f, (float)-1.0f));
        PartDefinition eyebrows = head.m_171599_("eyebrows", CubeListBuilder.m_171558_().m_171514_(9, 8).m_171488_(1.0f, -3.0f, -5.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)).m_171514_(9, 8).m_171480_().m_171488_(-3.0f, -3.0f, -5.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition snout = head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-1.5f, -9.0f, -15.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.05f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)7.5f));
        PartDefinition jaw_overlay = head.m_171599_("jaw_overlay", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-4.5f));
        PartDefinition jaw = jaw_overlay.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(10, 37).m_171488_(-1.5f, -0.5f, -3.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.25f, (float)3.0f));
        PartDefinition tail_r1 = tail.m_171599_("tail_r1", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.25f, (float)-0.75f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition arms_overlay = main.m_171599_("arms_overlay", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-6.0f));
        PartDefinition arms = arms_overlay.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition arm_left = arms.m_171599_("arm_left", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-0.9f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        PartDefinition arm_right = arms.m_171599_("arm_right", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.1f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition legs_overlay = main.m_171599_("legs_overlay", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)2.0f, (float)5.0f));
        PartDefinition legs = legs_overlay.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg_left = legs.m_171599_("leg_left", CubeListBuilder.m_171558_().m_171514_(29, 33).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right = legs.m_171599_("leg_right", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void setupAnim(Thylacine entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (this.f_102610_) {
            this.m_288214_(ThylacineAnims.BABY);
        }
        if (!entity.m_20072_()) {
            if (entity.m_20142_()) {
                this.m_267799_(ThylacineAnims.RUN, limbSwing, limbSwingAmount, 1.5f, 1.0f);
            } else {
                this.m_267799_(ThylacineAnims.WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
            }
            this.m_233385_(entity.attackAnimationState1, ThylacineAnims.ATTACK_1, ageInTicks, 1.0f);
            this.m_233385_(entity.attackAnimationState2, ThylacineAnims.ATTACK_2, ageInTicks, 1.0f);
            this.m_233385_(entity.yawnAnimationState, ThylacineAnims.YAWN, ageInTicks, 1.0f);
            this.m_233385_(entity.howlAnimationState, ThylacineAnims.HOWL, ageInTicks, 1.0f);
        }
        this.animateIdle(entity.idleAnimationState, ThylacineAnims.IDLE, ageInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)entity.getInWaterTicks() / 5.0f - Math.abs(limbSwingAmount)));
        this.animateIdle(entity.idleAnimationState, ThylacineAnims.SWIM, ageInTicks, 1.0f, (float)entity.getInWaterTicks() / 5.0f);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        if (this.f_102610_) {
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
        }
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

