/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.model.entity.animal.dawn_horse;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.marvelous_menagerie.client.animations.DawnHorseAnims;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.DawnHorse;

public class DawnHorseModel<T extends DawnHorse>
extends MarvelousModel<T> {
    private final ModelPart root;
    private final ModelPart body_main;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftEar;
    private final ModelPart rightEar;
    private final ModelPart tail;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public DawnHorseModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.body_main = this.root.m_171324_("body_main");
        this.body = this.body_main.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.leftEar = this.head.m_171324_("leftEar");
        this.rightEar = this.head.m_171324_("rightEar");
        this.tail = this.body.m_171324_("tail");
        this.leftArm = this.body_main.m_171324_("leftArm");
        this.rightArm = this.body_main.m_171324_("rightArm");
        this.leftLeg = this.body_main.m_171324_("leftLeg");
        this.rightLeg = this.body_main.m_171324_("rightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body_main = root.m_171599_("body_main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-5.5f, (float)0.5f));
        PartDefinition body = body_main.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -2.5f, -3.5f, 4.0f, 5.0f, 7.0f, new CubeDeformation(0.1f)).m_171514_(0, 0).m_171488_(-0.5f, -3.5f, -3.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-1.5f, -1.0f, -7.0f, 3.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(13, 12).m_171488_(-0.5f, -2.0f, -4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-3.5f));
        PartDefinition leftEar = head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(0.0f, -2.0f, -0.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)1.5f, (float)-1.0f, (float)-2.5f));
        PartDefinition rightEar = head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(0.0f, -2.0f, -0.5f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)-1.5f, (float)-1.0f, (float)-2.5f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(2, 22).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 5.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)3.5f));
        PartDefinition leftArm = body_main.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)2.5f, (float)-2.5f));
        PartDefinition rightArm = body_main.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)2.5f, (float)-2.5f));
        PartDefinition leftLeg = body_main.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)2.5f, (float)2.5f));
        PartDefinition rightLeg = body_main.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)2.5f, (float)2.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(DawnHorse entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_20072_()) {
            this.m_267799_(DawnHorseAnims.RUN, limbSwing, limbSwingAmount, 2.0f, 1.0f);
        }
        this.animateIdle(entity.idleAnimationState, DawnHorseAnims.IDLE, ageInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)entity.getInWaterTicks() / 5.0f - Math.abs(limbSwingAmount)));
        this.animateIdle(entity.idleAnimationState, DawnHorseAnims.SWIM, ageInTicks, 1.0f, (float)entity.getInWaterTicks() / 5.0f);
        this.m_233385_(entity.idleEarsState, DawnHorseAnims.IDLE_EARS, ageInTicks, 1.0f);
        this.m_233385_(entity.idleTailState, DawnHorseAnims.IDLE_TAIL, ageInTicks, 1.0f);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        if (this.f_102610_) {
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
        }
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

