/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.model.entity.animal.dodo;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.marvelous_menagerie.client.animations.DodoAnims;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.Dodo;

public class DodoModel<T extends Dodo>
extends MarvelousModel<T> {
    private final ModelPart root;
    private final ModelPart main;
    private final ModelPart body;
    private final ModelPart leftwing;
    private final ModelPart rightwing;
    private final ModelPart tail;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart legs;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public DodoModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.main = this.root.m_171324_("main");
        this.body = this.main.m_171324_("body");
        this.leftwing = this.body.m_171324_("leftwing");
        this.rightwing = this.body.m_171324_("rightwing");
        this.tail = this.body.m_171324_("tail");
        this.neck = this.body.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.legs = this.main.m_171324_("legs");
        this.leftleg = this.legs.m_171324_("leftleg");
        this.rightleg = this.legs.m_171324_("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition main = root.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-7.5f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition body = main.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        PartDefinition leftwing = body.m_171599_("leftwing", CubeListBuilder.m_171558_().m_171514_(17, 30).m_171488_(-1.0f, -0.5f, -4.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-1.5f, (float)2.0f));
        PartDefinition rightwing = body.m_171599_("rightwing", CubeListBuilder.m_171558_().m_171514_(29, 13).m_171488_(0.0f, -0.5f, -4.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-1.5f, (float)2.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(21, 15).m_171488_(0.0f, -7.0f, -7.159f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-2.841f));
        PartDefinition tail_r1 = tail.m_171599_("tail_r1", CubeListBuilder.m_171558_().m_171514_(21, 15).m_171488_(0.0f, -16.0f, -11.0f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.001f)), PartPose.m_171423_((float)0.5f, (float)9.0f, (float)3.841f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition tail_r2 = tail.m_171599_("tail_r2", CubeListBuilder.m_171558_().m_171514_(21, 15).m_171488_(0.0f, -16.0f, -11.0f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.001f)), PartPose.m_171423_((float)-0.5f, (float)9.0f, (float)3.841f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)4.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(25, 0).m_171488_(-1.0f, -6.0f, 4.0f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 17).m_171488_(-2.5f, -8.0f, -1.0f, 5.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition legs = main.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.475f, (float)-2.0f));
        PartDefinition leftleg = legs.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(3, 0).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.001f)).m_171514_(0, 32).m_171488_(-1.5f, 4.0f, 0.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)-2.5f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = legs.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(24, 30).m_171488_(-1.5f, 4.0f, 0.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.001f)).m_171514_(0, 0).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)2.5f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void setupAnim(Dodo entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_20072_()) {
            this.m_233385_(entity.peckingAnimationState, DodoAnims.PECK, ageInTicks, 1.0f);
            if (entity.m_20142_()) {
                this.m_267799_(DodoAnims.RUN, limbSwing, limbSwingAmount, 1.5f, 1.0f);
            } else {
                this.m_267799_(DodoAnims.WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
            }
            this.m_233385_(entity.shakingAnimationState, DodoAnims.SHAKE, ageInTicks, 1.0f);
            this.m_233385_(entity.lookAnimationState, DodoAnims.IDLE_LOOK, ageInTicks, 1.0f);
        }
        this.animateIdle(entity.idleAnimationState, DodoAnims.SWIM, ageInTicks, 1.0f, (float)entity.getInWaterTicks() / 5.0f);
        this.animateIdle(entity.idleAnimationState, DodoAnims.IDLE, ageInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)entity.getTicksOffGround() / 5.0f - (float)entity.getInWaterTicks() / 5.0f - Math.abs(limbSwingAmount)));
        this.animateIdle(entity.idleAnimationState, DodoAnims.FLAP, ageInTicks, 1.0f, (float)entity.getTicksOffGround() / 5.0f - (float)entity.getInWaterTicks() / 5.0f);
        float prevNeckX = this.neck.f_104203_;
        float prevNeckY = this.neck.f_104204_;
        this.neck.f_104203_ = prevNeckX - headPitch * ((float)Math.PI / 180);
        this.neck.f_104204_ = prevNeckY + netHeadYaw * ((float)Math.PI / 180);
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

