/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.model.entity.animal.elephant_bird;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.marvelous_menagerie.client.animations.BabyEleBirdAnims;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.ElephantBird;

public class BabyEleBirdModel<T extends ElephantBird>
extends MarvelousModel<T> {
    private final ModelPart root;
    private final ModelPart main;
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart legs;
    private final ModelPart leg_left;
    private final ModelPart leg_right;

    public BabyEleBirdModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.main = this.root.m_171324_("main");
        this.body = this.main.m_171324_("body");
        this.neck = this.body.m_171324_("neck");
        this.legs = this.main.m_171324_("legs");
        this.leg_left = this.legs.m_171324_("leg_left");
        this.leg_right = this.legs.m_171324_("leg_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition main = root.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = main.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -2.0f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-8.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(15, 12).m_171488_(-1.0f, -5.5f, -3.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 12).m_171488_(-1.0f, -9.5f, -4.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(17, 0).m_171488_(-0.5f, -6.5f, -6.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-3.0f));
        PartDefinition legs = main.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.5f, (float)-5.0f, (float)0.0f));
        PartDefinition leg_left = legs.m_171599_("leg_left", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg_left_r1 = leg_left.m_171599_("leg_left_r1", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.001f)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)-0.75f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition leg_right = legs.m_171599_("leg_right", CubeListBuilder.m_171558_().m_171514_(3, 0).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)-3.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right_r1 = leg_right.m_171599_("leg_right_r1", CubeListBuilder.m_171558_().m_171514_(7, 22).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.001f)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)-0.75f, (float)0.0f, (float)0.7854f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(ElephantBird entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_20072_()) {
            if (entity.m_20142_()) {
                this.m_267799_(BabyEleBirdAnims.RUN, limbSwing, limbSwingAmount, 1.5f, 1.0f);
            } else {
                this.m_267799_(BabyEleBirdAnims.WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
            }
            this.m_233385_(entity.shakeAnimationState, BabyEleBirdAnims.SHAKE, ageInTicks, 1.0f);
        }
        this.animateIdle(entity.idleAnimationState, BabyEleBirdAnims.SWIM, ageInTicks, 1.0f, (float)entity.getInWaterTicks() / 5.0f);
        this.animateIdle(entity.idleAnimationState, BabyEleBirdAnims.IDLE, ageInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)entity.getInWaterTicks() / 5.0f - Math.abs(limbSwingAmount)));
        this.neck.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.neck.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

