/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.model.entity.animal.elephant_bird;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.marvelous_menagerie.client.animations.EleBirdAnims;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.ElephantBird;

public class EleBirdModel<T extends ElephantBird>
extends MarvelousModel<T> {
    private final ModelPart root;
    private final ModelPart main;
    private final ModelPart body_overlay;
    private final ModelPart body;
    private final ModelPart body_shag;
    private final ModelPart carpet;
    private final ModelPart passenger;
    private final ModelPart chest_l;
    private final ModelPart chest_r;
    private final ModelPart head_look;
    private final ModelPart neck_overlay;
    private final ModelPart neck;
    private final ModelPart neck_shag;
    private final ModelPart hat;
    private final ModelPart legs;
    private final ModelPart leg_left;
    private final ModelPart leg_right;

    public EleBirdModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.main = this.root.m_171324_("main");
        this.body_overlay = this.main.m_171324_("body_overlay");
        this.body = this.body_overlay.m_171324_("body");
        this.body_shag = this.body.m_171324_("body_shag");
        this.carpet = this.body.m_171324_("carpet");
        this.passenger = this.carpet.m_171324_("passenger");
        this.chest_l = this.body.m_171324_("chest_l");
        this.chest_r = this.body.m_171324_("chest_r");
        this.head_look = this.body.m_171324_("head_look");
        this.neck_overlay = this.head_look.m_171324_("neck_overlay");
        this.neck = this.neck_overlay.m_171324_("neck");
        this.neck_shag = this.neck.m_171324_("neck_shag");
        this.hat = this.neck.m_171324_("hat");
        this.legs = this.main.m_171324_("legs");
        this.leg_left = this.legs.m_171324_("leg_left");
        this.leg_right = this.legs.m_171324_("leg_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition main = root.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-30.0f, (float)2.0f));
        PartDefinition body_overlay = main.m_171599_("body_overlay", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.6f, (float)-0.4f));
        PartDefinition body = body_overlay.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -7.4f, -12.6f, 18.0f, 15.0f, 25.0f, new CubeDeformation(0.05f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body_shag = body.m_171599_("body_shag", CubeListBuilder.m_171558_().m_171514_(0, 82).m_171488_(-9.0f, 0.0f, -12.5f, 18.0f, 6.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.6f, (float)-0.1f));
        PartDefinition carpet = body.m_171599_("carpet", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171488_(-9.0f, 0.175f, -12.5f, 18.0f, 15.0f, 25.0f, new CubeDeformation(0.2f)), PartPose.m_171419_((float)0.0f, (float)-7.575f, (float)-0.1f));
        PartDefinition passenger = carpet.m_171599_("passenger", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.025f, (float)0.0f));
        PartDefinition chest_l = body.m_171599_("chest_l", CubeListBuilder.m_171558_().m_171514_(25, 126).m_171488_(0.0f, -1.0f, -4.5f, 4.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.0f, (float)-4.5f, (float)7.0f));
        PartDefinition chest_r = body.m_171599_("chest_r", CubeListBuilder.m_171558_().m_171514_(25, 126).m_171480_().m_171488_(-4.0f, -1.0f, -4.5f, 4.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-9.0f, (float)-4.5f, (float)7.0f));
        PartDefinition head_look = body.m_171599_("head_look", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.65f, (float)-11.6f));
        PartDefinition neck_overlay = head_look.m_171599_("neck_overlay", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.25f, (float)0.0f));
        PartDefinition neck = neck_overlay.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 114).m_171488_(-4.0f, -4.0f, -5.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.075f)).m_171514_(87, 0).m_171488_(-4.0f, -30.0f, -13.0f, 8.0f, 34.0f, 8.0f, new CubeDeformation(0.05f)).m_171514_(29, 114).m_171488_(-2.0f, -30.0f, -19.0f, 4.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck_shag = neck.m_171599_("neck_shag", CubeListBuilder.m_171558_().m_171514_(87, 43).m_171488_(-4.0f, 0.0f, 0.0f, 8.0f, 4.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-13.0f));
        PartDefinition hat = neck.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(112, 122).m_171488_(-4.0f, 0.15f, -4.0f, 8.0f, 14.0f, 8.0f, new CubeDeformation(0.3f)), PartPose.m_171419_((float)0.0f, (float)-30.15f, (float)-9.0f));
        PartDefinition legs = main.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)1.0f));
        PartDefinition leg_left = legs.m_171599_("leg_left", CubeListBuilder.m_171558_().m_171514_(87, 62).m_171488_(-3.5f, -2.0688f, -3.4284f, 7.0f, 26.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right = legs.m_171599_("leg_right", CubeListBuilder.m_171558_().m_171514_(87, 96).m_171488_(-3.5f, -2.0688f, -3.4284f, 7.0f, 26.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)144, (int)144);
    }

    public void setupAnim(ElephantBird entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_20072_()) {
            if (entity.m_20142_()) {
                this.m_267799_(EleBirdAnims.RUN, limbSwing, limbSwingAmount, 1.5f, 1.0f);
            } else {
                this.m_267799_(EleBirdAnims.WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
            }
            this.m_233385_(entity.shakeAnimationState, EleBirdAnims.SHAKE, ageInTicks, 1.0f);
        }
        this.m_233385_(entity.smhAnimationState, EleBirdAnims.NUH_UH, ageInTicks, 1.0f);
        this.animateIdle(entity.idleAnimationState, EleBirdAnims.SWIM, ageInTicks, 1.0f, (float)entity.getInWaterTicks() / 5.0f);
        this.animateIdle(entity.idleAnimationState, EleBirdAnims.IDLE, ageInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)entity.getInWaterTicks() / 5.0f - Math.abs(limbSwingAmount)));
        this.head_look.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head_look.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

