/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.model.entity.animal.flubber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.voidarkana.marvelous_menagerie.client.animations.FlubberAnimsBasics;
import net.voidarkana.marvelous_menagerie.client.animations.FlubberAnimsIdle;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.Flubber;

public class FlubberModel<T extends Flubber>
extends MarvelousModel<T> {
    private final ModelPart root;
    private final ModelPart swim_rot;
    private final ModelPart body_main;
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart head_flap;
    private final ModelPart head;
    private final ModelPart trunk;
    private final ModelPart hips;
    private final ModelPart leg_l;
    private final ModelPart leg_r;
    private final ModelPart tail;
    private final ModelPart tail_end;
    private final ModelPart arm_l;
    private final ModelPart hand_l;
    private final ModelPart arm_r;
    private final ModelPart hand_r;

    public FlubberModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.swim_rot = this.root.m_171324_("swim_rot");
        this.body_main = this.swim_rot.m_171324_("body_main");
        this.body = this.body_main.m_171324_("body");
        this.neck = this.body.m_171324_("neck");
        this.head_flap = this.neck.m_171324_("head_flap");
        this.head = this.neck.m_171324_("head");
        this.trunk = this.head.m_171324_("trunk");
        this.hips = this.body.m_171324_("hips");
        this.leg_l = this.hips.m_171324_("leg_l");
        this.leg_r = this.hips.m_171324_("leg_r");
        this.tail = this.hips.m_171324_("tail");
        this.tail_end = this.tail.m_171324_("tail_end");
        this.arm_l = this.body_main.m_171324_("arm_l");
        this.hand_l = this.arm_l.m_171324_("hand_l");
        this.arm_r = this.body_main.m_171324_("arm_r");
        this.hand_r = this.arm_r.m_171324_("hand_r");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition swim_rot = root.m_171599_("swim_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)-5.0f));
        PartDefinition body_main = swim_rot.m_171599_("body_main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)2.0f));
        PartDefinition body = body_main.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 79).m_171488_(0.0f, -14.0f, 2.0f, 0.0f, 4.0f, 11.0f, new CubeDeformation(0.001f)).m_171514_(0, 0).m_171488_(-8.0f, -11.0f, -5.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(41, 50).m_171488_(-2.5f, -17.0f, -5.0f, 5.0f, 20.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)-3.0f));
        PartDefinition head_flap = neck.m_171599_("head_flap", CubeListBuilder.m_171558_().m_171514_(72, 67).m_171488_(0.0f, -4.0f, -5.0f, 0.0f, 9.0f, 13.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)-15.0f, (float)2.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(81, 54).m_171488_(-3.0f, -2.65f, -2.0f, 6.0f, 1.0f, 4.0f, new CubeDeformation(0.2f)).m_171514_(56, 100).m_171488_(-3.0f, -2.5f, -5.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-14.6f, (float)-3.0f));
        PartDefinition trunk = head.m_171599_("trunk", CubeListBuilder.m_171558_().m_171514_(78, 90).m_171488_(-2.0f, -0.1f, -3.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(23, 93).m_171488_(-2.0f, 6.9f, -3.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.4f, (float)-5.0f));
        PartDefinition hips = body.m_171599_("hips", CubeListBuilder.m_171558_().m_171514_(65, 0).m_171488_(-4.0f, -5.0f, -2.0f, 8.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(23, 80).m_171488_(0.0f, -8.0f, 0.0f, 0.0f, 3.0f, 9.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)-0.1f, (float)11.0f));
        PartDefinition leg_l = hips.m_171599_("leg_l", CubeListBuilder.m_171558_().m_171514_(93, 90).m_171488_(-1.0f, 0.0f, -1.5f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(42, 92).m_171488_(3.0f, 0.0f, -1.5f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)3.0f, (float)2.5f));
        PartDefinition leg_r = hips.m_171599_("leg_r", CubeListBuilder.m_171558_().m_171514_(93, 90).m_171480_().m_171488_(-3.0f, 0.0f, -1.5f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(42, 92).m_171480_().m_171488_(-6.0f, 0.0f, -1.5f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)3.0f, (float)2.5f));
        PartDefinition tail = hips.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(42, 80).m_171488_(-1.0f, -2.5f, -2.0f, 2.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.4f, (float)8.0f));
        PartDefinition tail_end = tail.m_171599_("tail_end", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(-1.0f, -7.5f, 0.0f, 2.0f, 10.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(72, 49).m_171488_(0.0f, -8.5f, 1.0f, 0.0f, 1.0f, 16.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition arm_l = body_main.m_171599_("arm_l", CubeListBuilder.m_171558_().m_171514_(65, 21).m_171488_(0.0f, -2.0f, -2.5f, 10.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)-2.0f, (float)-3.5f));
        PartDefinition hand_l = arm_l.m_171599_("hand_l", CubeListBuilder.m_171558_().m_171514_(57, 33).m_171488_(-1.0f, -1.0f, -2.5f, 9.0f, 2.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(0, 33).m_171488_(-1.0f, 0.0f, -2.5f, 12.0f, 0.0f, 16.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)11.0f, (float)-1.0f, (float)0.0f));
        PartDefinition arm_r = body_main.m_171599_("arm_r", CubeListBuilder.m_171558_().m_171514_(65, 21).m_171480_().m_171488_(-10.0f, -2.0f, -2.5f, 10.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-8.0f, (float)-2.0f, (float)-3.5f));
        PartDefinition hand_r = arm_r.m_171599_("hand_r", CubeListBuilder.m_171558_().m_171514_(57, 33).m_171480_().m_171488_(-8.0f, -1.0f, -2.5f, 9.0f, 2.0f, 13.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 33).m_171480_().m_171488_(-11.0f, 0.0f, -2.5f, 12.0f, 0.0f, 16.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171419_((float)-11.0f, (float)-1.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)112, (int)112);
    }

    public void setupAnim(Flubber entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.isFromInventory().booleanValue()) {
            if (entity.m_20072_()) {
                this.m_288214_(FlubberAnimsIdle.SWIM_POSE);
            } else {
                this.m_288214_(FlubberAnimsIdle.IDLE_POSE);
            }
        }
        this.animateIdle(entity.idleAnimationState, FlubberAnimsBasics.LAND_IDLE, ageInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)entity.getInWaterTicks() / 5.0f - Math.abs(limbSwingAmount * 3.0f)));
        this.animateIdle(entity.idleAnimationState, FlubberAnimsBasics.SWIM_IDLE, ageInTicks, 1.0f, (float)entity.getInWaterTicks() / 5.0f - Math.abs(limbSwingAmount));
        this.m_267799_(FlubberAnimsBasics.SWIM, limbSwing, limbSwingAmount * (float)entity.getInWaterTicks() / 5.0f, 1.5f, 2.5f);
        this.m_267799_(FlubberAnimsBasics.WALK, limbSwing, limbSwingAmount * 2.0f * (1.0f - (float)entity.getInWaterTicks() / 5.0f), 2.0f, 2.5f);
        this.m_233381_(entity.landDanceAnimationState, FlubberAnimsBasics.CELEBRATION_LAND, ageInTicks);
        this.m_233381_(entity.waterDanceAnimationState1, FlubberAnimsBasics.CELEBRATION_WATER_1, ageInTicks);
        this.m_233381_(entity.waterDanceAnimationState2, FlubberAnimsBasics.CELEBRATION_WATER_2, ageInTicks);
        this.m_233381_(entity.waterDigAnimationState, FlubberAnimsBasics.SWIM_DIG_OVERLAY, ageInTicks);
        this.m_233381_(entity.landDigAnimationState, FlubberAnimsBasics.LAND_DIG, ageInTicks);
        float prevHeadxRot = this.neck.f_104203_;
        float prevHeadyRot = this.neck.f_104204_;
        this.neck.f_104203_ = prevHeadxRot + headPitch * ((float)Math.PI / 180) / 2.0f;
        this.neck.f_104204_ = prevHeadyRot + netHeadYaw * ((float)Math.PI / 180) / 2.0f;
        this.swim_rot.f_104203_ = Mth.m_14179_((float)((float)entity.getInWaterTicks() / 5.0f), (float)0.0f, (float)(headPitch * ((float)Math.PI / 180)));
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

