/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.model.entity.animal.steller_sea_cow;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.marvelous_menagerie.client.animations.BabyStellerAnims;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.StellerSeaCow;

public class BabyStellerModel<T extends StellerSeaCow>
extends MarvelousModel<T> {
    private final ModelPart root;
    private final ModelPart swim_rot;
    private final ModelPart main;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart flipper_l;
    private final ModelPart flipper_r;
    private final ModelPart tail;
    private final ModelPart tail_fin;

    public BabyStellerModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.swim_rot = this.root.m_171324_("swim_rot");
        this.main = this.swim_rot.m_171324_("main");
        this.body = this.main.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.flipper_l = this.body.m_171324_("flipper_l");
        this.flipper_r = this.body.m_171324_("flipper_r");
        this.tail = this.body.m_171324_("tail");
        this.tail_fin = this.tail.m_171324_("tail_fin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition swim_rot = root.m_171599_("swim_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-5.0f));
        PartDefinition main = swim_rot.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition body = main.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -5.0f, -3.0f, 10.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-4.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-3.5f, -4.25f, -7.5f, 7.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.25f, (float)-2.5f));
        PartDefinition flipper_l = body.m_171599_("flipper_l", CubeListBuilder.m_171558_().m_171514_(35, 5).m_171488_(0.0f, -1.0f, -1.5f, 5.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)4.0f, (float)0.0f));
        PartDefinition flipper_r = body.m_171599_("flipper_r", CubeListBuilder.m_171558_().m_171514_(35, 0).m_171488_(-5.0f, -1.0f, -1.5f, 5.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(23, 34).m_171488_(-2.5f, -3.0f, -0.5f, 5.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)10.5f));
        PartDefinition tail_fin = tail.m_171599_("tail_fin", CubeListBuilder.m_171558_().m_171514_(31, 25).m_171488_(-5.0f, -0.5f, 0.0f, 10.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)5.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)80, (int)80);
    }

    public void setupAnim(StellerSeaCow entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.isFromInventory().booleanValue()) {
            this.m_288214_(BabyStellerAnims.POSE);
        }
        if (entity.m_20072_()) {
            this.m_267799_(BabyStellerAnims.SWIM, limbSwing, limbSwingAmount * 4.0f, 1.5f, 3.0f);
            this.swim_rot.f_104203_ = headPitch * ((float)Math.PI / 180) / 2.0f;
        } else {
            this.swim_rot.m_233569_();
        }
        this.animateIdle(entity.idleAnimationState, BabyStellerAnims.IDLE, ageInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)entity.getOutOfWaterTicks() / 5.0f - Math.abs(limbSwingAmount)));
        this.animateIdle(entity.idleAnimationState, BabyStellerAnims.FLOP, ageInTicks, 1.0f, (float)entity.getOutOfWaterTicks() / 5.0f);
        this.head.f_104204_ = netHeadYaw * (float)Math.PI / 180.0f;
        this.head.f_104203_ = headPitch * (float)Math.PI / 180.0f;
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

