/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.model.entity.animal.steller_sea_cow;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.voidarkana.marvelous_menagerie.client.animations.StellerAnims;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.StellerSeaCow;

public class StellerModel<T extends StellerSeaCow>
extends MarvelousModel<T> {
    private final ModelPart root;
    private final ModelPart swim_rot;
    private final ModelPart main;
    private final ModelPart body;
    private final ModelPart neck_rot;
    private final ModelPart neck;
    private final ModelPart head_rot;
    private final ModelPart head;
    private final ModelPart flipper_l;
    private final ModelPart flipper_r;
    private final ModelPart tail_rot;
    private final ModelPart tail;
    private final ModelPart tail_tip_rot;
    private final ModelPart tail_fin;

    public StellerModel(ModelPart root) {
        super(1.0f, 1.0f);
        this.root = root.m_171324_("root");
        this.swim_rot = this.root.m_171324_("swim_rot");
        this.main = this.swim_rot.m_171324_("main");
        this.body = this.main.m_171324_("body");
        this.neck_rot = this.body.m_171324_("neck_rot");
        this.neck = this.neck_rot.m_171324_("neck");
        this.head_rot = this.neck.m_171324_("head_rot");
        this.head = this.head_rot.m_171324_("head");
        this.flipper_l = this.body.m_171324_("flipper_l");
        this.flipper_r = this.body.m_171324_("flipper_r");
        this.tail_rot = this.body.m_171324_("tail_rot");
        this.tail = this.tail_rot.m_171324_("tail");
        this.tail_tip_rot = this.tail.m_171324_("tail_tip_rot");
        this.tail_fin = this.tail_tip_rot.m_171324_("tail_fin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition swim_rot = root.m_171599_("swim_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-18.0f, (float)-22.0f));
        PartDefinition main = swim_rot.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)22.0f));
        PartDefinition body = main.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-18.0f, -18.0f, -11.0f, 36.0f, 36.0f, 68.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-23.0f));
        PartDefinition neck_rot = body.m_171599_("neck_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)-10.5f));
        PartDefinition neck = neck_rot.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(79, 104).m_171488_(-12.0f, -13.5f, -10.5f, 24.0f, 25.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        PartDefinition head_rot = neck.m_171599_("head_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.25f, (float)-10.0f));
        PartDefinition head = head_rot.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -6.25f, -7.5f, 12.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 31).m_171488_(-5.0f, -6.25f, -13.5f, 10.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition flipper_l = body.m_171599_("flipper_l", CubeListBuilder.m_171558_().m_171514_(27, 23).m_171488_(0.0f, -2.0f, -3.5f, 10.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)18.0f, (float)16.0f, (float)0.5f));
        PartDefinition flipper_r = body.m_171599_("flipper_r", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(-10.0f, -2.0f, -3.5f, 10.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-18.0f, (float)16.0f, (float)0.5f));
        PartDefinition tail_rot = body.m_171599_("tail_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)56.5f));
        PartDefinition tail = tail_rot.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(1, 119).m_171488_(-7.0f, -7.0f, -1.5f, 14.0f, 14.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail_tip_rot = tail.m_171599_("tail_tip_rot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)20.5f));
        PartDefinition tail_fin = tail_tip_rot.m_171599_("tail_fin", CubeListBuilder.m_171558_().m_171514_(140, 128).m_171488_(-15.0f, -1.0f, -1.0f, 30.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)240, (int)240);
    }

    public void setupAnim(StellerSeaCow entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.isFromInventory().booleanValue()) {
            this.m_288214_(StellerAnims.POSE);
        }
        if (entity.m_20072_()) {
            this.m_267799_(StellerAnims.SWIM, limbSwing, limbSwingAmount * 4.0f, 1.5f, 3.0f);
            this.swim_rot.f_104203_ = headPitch * ((float)Math.PI / 180) / 8.0f;
        } else {
            this.swim_rot.m_233569_();
        }
        this.animateIdle(entity.idleAnimationState, StellerAnims.IDLE, ageInTicks, 1.0f, Math.max(0.0f, 1.0f - (float)entity.getOutOfWaterTicks() / 5.0f - Math.abs(limbSwingAmount)));
        this.animateIdle(entity.idleAnimationState, StellerAnims.BEACHED, ageInTicks, 1.0f, (float)entity.getOutOfWaterTicks() / 5.0f);
        this.head.f_104204_ = netHeadYaw * (float)Math.PI / 180.0f / 2.0f;
        this.head.f_104203_ = headPitch * (float)Math.PI / 180.0f / 2.0f;
        this.neck_rot.f_104204_ = netHeadYaw * (float)Math.PI / 180.0f / 2.0f;
        this.neck_rot.f_104203_ = headPitch * (float)Math.PI / 180.0f / 2.0f;
    }

    @Override
    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

