/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.renderer.entity.animal;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.voidarkana.marvelous_menagerie.client.model.MMModelLayers;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.client.model.entity.animal.dodo.BabyDodoModel;
import net.voidarkana.marvelous_menagerie.client.model.entity.animal.dodo.DodoModel;
import net.voidarkana.marvelous_menagerie.common.entity.animal.Dodo;

public class DodoRenderer
extends MobRenderer<Dodo, MarvelousModel<Dodo>> {
    private final DodoModel<Dodo> dodoModel;
    private final BabyDodoModel<Dodo> babyDodoModel;
    private static final ResourceLocation TEXTURE_BLUE = new ResourceLocation("marvelous_menagerie", "textures/entity/animal/dodo/dodo.png");
    private static final ResourceLocation TEXTURE_BROWN = new ResourceLocation("marvelous_menagerie", "textures/entity/animal/dodo/dodo_variant.png");
    private static final ResourceLocation TEXTURE_BABY_BLUE = new ResourceLocation("marvelous_menagerie", "textures/entity/animal/dodo/baby_dodo.png");
    private static final ResourceLocation TEXTURE_BABY_BROWN = new ResourceLocation("marvelous_menagerie", "textures/entity/animal/dodo/baby_dodo_variant.png");
    private static final ResourceLocation TEXTURE_NUGGET = new ResourceLocation("marvelous_menagerie", "textures/entity/animal/dodo/dodo_nugget.png");
    private static final ResourceLocation TEXTURE_BABY_NUGGET = new ResourceLocation("marvelous_menagerie", "textures/entity/animal/dodo/baby_dodo_nugget.png");
    private static final ResourceLocation TEXTURE_SPAWN = new ResourceLocation("marvelous_menagerie", "textures/entity/animal/dodo/dodo_spawn.png");
    private static final ResourceLocation TEXTURE_BABY_SPAWN = new ResourceLocation("marvelous_menagerie", "textures/entity/animal/dodo/baby_dodo_spawn.png");

    public DodoRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new DodoModel(pContext.m_174023_(MMModelLayers.DODO_LAYER)), 0.4f);
        this.dodoModel = new DodoModel(pContext.m_174023_(MMModelLayers.DODO_LAYER));
        this.babyDodoModel = new BabyDodoModel(pContext.m_174023_(MMModelLayers.BABY_DODO_LAYER));
    }

    public ResourceLocation getTextureLocation(Dodo entity) {
        if (entity.isSpawn()) {
            return entity.m_6162_() ? TEXTURE_BABY_SPAWN : TEXTURE_SPAWN;
        }
        if (entity.isNugget()) {
            return entity.m_6162_() ? TEXTURE_BABY_NUGGET : TEXTURE_NUGGET;
        }
        return switch (entity.getVariant()) {
            case 1 -> {
                if (entity.m_6162_()) {
                    yield TEXTURE_BABY_BLUE;
                }
                yield TEXTURE_BLUE;
            }
            default -> entity.m_6162_() ? TEXTURE_BABY_BROWN : TEXTURE_BROWN;
        };
    }

    public void render(Dodo pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        this.f_115290_ = pEntity.m_6162_() ? this.babyDodoModel : this.dodoModel;
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }
}

