/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.renderer.entity.animal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.voidarkana.marvelous_menagerie.client.model.MMModelLayers;
import net.voidarkana.marvelous_menagerie.client.model.base.MarvelousModel;
import net.voidarkana.marvelous_menagerie.client.model.entity.animal.trilobite.TrilobiteFatModel;
import net.voidarkana.marvelous_menagerie.client.model.entity.animal.trilobite.TrilobiteIttyModel;
import net.voidarkana.marvelous_menagerie.client.model.entity.animal.trilobite.TrilobiteMidModel;
import net.voidarkana.marvelous_menagerie.client.renderer.entity.layers.TrilobiteHighlightLayer;
import net.voidarkana.marvelous_menagerie.client.renderer.entity.layers.TrilobiteSecondLayer;
import net.voidarkana.marvelous_menagerie.common.entity.animal.Trilobite;
import org.jetbrains.annotations.Nullable;

public class TrilobiteRenderer
extends MobRenderer<Trilobite, MarvelousModel<Trilobite>> {
    private final TrilobiteIttyModel<Trilobite> triloIttyModel;
    private final TrilobiteMidModel<Trilobite> triloMidModel;
    private final TrilobiteFatModel<Trilobite> triloFatModel;

    public TrilobiteRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new TrilobiteMidModel(pContext.m_174023_(MMModelLayers.TRILO_MID_LAYER)), 0.25f);
        this.triloIttyModel = new TrilobiteIttyModel(pContext.m_174023_(MMModelLayers.TRILO_ITTY_LAYER));
        this.triloMidModel = new TrilobiteMidModel(pContext.m_174023_(MMModelLayers.TRILO_MID_LAYER));
        this.triloFatModel = new TrilobiteFatModel(pContext.m_174023_(MMModelLayers.TRILO_FAT_LAYER));
        this.m_115326_(new TrilobiteSecondLayer((RenderLayerParent<Trilobite, MarvelousModel<Trilobite>>)this, pContext));
        this.m_115326_(new TrilobiteHighlightLayer((RenderLayerParent<Trilobite, MarvelousModel<Trilobite>>)this, pContext));
    }

    public void render(Trilobite pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        switch (pEntity.getVariantModel()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.f_115290_ = this.triloMidModel;
                break;
            }
            case 5: {
                this.f_115290_ = this.triloIttyModel;
                break;
            }
            default: {
                this.f_115290_ = this.triloFatModel;
            }
        }
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(Trilobite entity) {
        if (entity.isLGBTrilo()) {
            return new ResourceLocation("marvelous_menagerie", "textures/entity/animal/trilobite/lgbtrilos/" + Trilobite.getLGBTVariantName(entity.getLGBTVariant()) + "/" + Trilobite.getModelName(entity.getVariantModel()) + "_" + Trilobite.getLGBTVariantName(entity.getLGBTVariant()) + ".png");
        }
        return new ResourceLocation("marvelous_menagerie", "textures/entity/animal/trilobite/" + Trilobite.getModelName(entity.getVariantModel()) + "/base/" + Trilobite.getModelName(entity.getVariantModel()) + "_base_" + Trilobite.getColorName(entity.getVariantBaseColor()) + ".png");
    }

    @Nullable
    protected RenderType getRenderType(Trilobite pLivingEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        ResourceLocation resourcelocation = this.getTextureLocation(pLivingEntity);
        if (pTranslucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (pBodyVisible) {
            return ((MarvelousModel)this.f_115290_).m_103119_(resourcelocation);
        }
        return pGlowing ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    protected void setupRotations(Trilobite pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.m_7523_((LivingEntity)pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        if (pEntityLiving.isFromInventory().booleanValue()) {
            pPoseStack.m_252781_(Axis.f_252495_.m_252977_(25.0f));
        }
    }
}

