/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.renderer.entity.misc;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.voidarkana.marvelous_menagerie.common.entity.misc.MMBoatEntity;
import net.voidarkana.marvelous_menagerie.common.entity.misc.MMChestBoatEntity;

public class MMBoatRenderer
extends BoatRenderer {
    private final Map<MMBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(MMBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("marvelous_menagerie", MMBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, (MMBoatEntity.Type)((Object)type), pChestBoat))));

    public MMBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
    }

    private static String getTextureLocation(MMBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context pContext, MMBoatEntity.Type pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? MMBoatRenderer.createChestBoatModelName(pType) : MMBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.m_174023_(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(MMBoatEntity.Type pType) {
        return MMBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(MMBoatEntity.Type pType) {
        return MMBoatRenderer.createLocation("chest_boat/" + pType.getName(), "main");
    }

    private static ModelLayerLocation createLocation(String pPath, String pModel) {
        return new ModelLayerLocation(new ResourceLocation("marvelous_menagerie", pPath), pModel);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof MMBoatEntity) {
            MMBoatEntity MMBoat = (MMBoatEntity)boat;
            return this.boatResources.get((Object)MMBoat.getMMVariant());
        }
        if (boat instanceof MMChestBoatEntity) {
            MMChestBoatEntity modChestBoatEntity = (MMChestBoatEntity)boat;
            return this.boatResources.get((Object)modChestBoatEntity.getMMVariant());
        }
        return null;
    }
}

