/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.screen.book;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.voidarkana.marvelous_menagerie.client.screen.book.BookEntry;
import net.voidarkana.marvelous_menagerie.client.screen.book.EntityLinkButton;
import net.voidarkana.marvelous_menagerie.client.screen.book.LineData;
import net.voidarkana.marvelous_menagerie.client.screen.book.PaleonomiconPage;
import net.voidarkana.marvelous_menagerie.client.screen.book.widget.EntityData;
import net.voidarkana.marvelous_menagerie.data.manager.PaleonomiconIndexManager;
import net.voidarkana.marvelous_menagerie.data.manager.codec.IndexTagsCodec;
import org.joml.Vector3f;

public class PaleonomiconScreen
extends Screen {
    public static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("marvelous_menagerie", "textures/gui/book/paleonomicon.png");
    public static final int PAGE_SIZE_IN_LINES = 15;
    public static final int TEXT_COLOR = 8546881;
    public static final int TEXT_LINK_COLOR = 0x111111;
    public static final int TEXT_LINK_HOVER_COLOR = 38143;
    public static final int TEXT_LINK_LOCKED_COLOR = 13879723;
    public boolean unlockTooltip;
    protected ResourceLocation prevEntryJSON = null;
    protected ResourceLocation currentEntryJSON;
    protected ResourceLocation nextEntryJSON;
    protected final ResourceLocation rootEntryJSON = new ResourceLocation("marvelous_menagerie", "books/root.json");
    int imageWidth;
    int imageHeight;
    int leftPos;
    int topPos;
    int nextButtonStartX = 282;
    int nextButtonEndX = 302;
    int prevButtonStartX = 12;
    int prevButtonEndX = 32;
    int buttonStartY = 149;
    int buttonEndY = 179;
    int homeButtonStartX = 128;
    int homeButtonEndX = 148;
    int homeButtonStartY = 185;
    int homeButtonEndY = 221;
    protected String entityTooltip;
    private boolean incrementingPage;
    private boolean decrementingPage;
    private PaleonomiconPage leftPageRenderer = new PaleonomiconPage(0);
    private PaleonomiconPage rightPageRenderer = new PaleonomiconPage(1);
    protected final List<LineData> lines = new ArrayList<LineData>();
    private BookEntry currentEntry;
    private BookEntry prevEntry;
    private BookEntry nextEntry;
    private int entryPageNumber = 0;
    private int lastEntryPageBeforeLinkClick = -1;
    private final List<EntityData> indexLinkData = new ArrayList<EntityData>();
    private final List<EntityData> currentIndexLinkData = new ArrayList<EntityData>();
    protected int xSize = 390;
    protected int ySize = 320;
    private static final ResourceLocation BOOK_WIDGET_TEXTURE = new ResourceLocation("marvelous_menagerie:textures/gui/book/widgets.png");

    private static Optional<? extends HolderSet.ListBacked<EntityType>> getHolders(ResourceOrTagKeyArgument.Result<EntityType> pStructure, Registry<EntityType> pStructureRegistry) {
        return (Optional)pStructure.m_245276_().map(p_258231_ -> pStructureRegistry.m_203636_(p_258231_).map(p_214491_ -> HolderSet.m_205809_((Holder[])new Holder[]{p_214491_})), arg_0 -> pStructureRegistry.m_203431_(arg_0));
    }

    public PaleonomiconScreen(String openTo) {
        super((Component)Component.m_237115_((String)"item.marvelous_menagerie.paleonomicon"));
        System.out.println(new ResourceLocation(PaleonomiconScreen.getBookFileDirectory() + openTo));
        this.currentEntryJSON = new ResourceLocation(PaleonomiconScreen.getBookFileDirectory() + openTo);
        this.imageWidth = 314;
        this.imageHeight = 207;
        this.resetEntry();
        for (PaleonomiconIndexManager.EntityCodec data : PaleonomiconIndexManager.DATA) {
            this.indexLinkData.add(new EntityData(data.entityName().toString(), data.icon(), data.link(), data.tags()));
            System.out.println(data.icon());
        }
        Collections.sort(this.indexLinkData, Comparator.comparing(EntityData::getEntity));
    }

    public PaleonomiconScreen() {
        this("root.json");
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
    }

    public void m_86600_() {
        if (this.incrementingPage) {
            if (this.nextEntryJSON != null) {
                this.prevEntryJSON = this.currentEntryJSON;
                this.currentEntryJSON = this.nextEntryJSON;
                this.nextEntryJSON = null;
                this.nextEntry = null;
                this.resetEntry();
            } else {
                ++this.entryPageNumber;
            }
            this.incrementingPage = false;
            this.updatePageRenderers();
        }
        if (this.decrementingPage) {
            --this.entryPageNumber;
            if (this.entryPageNumber < 0 && this.prevEntry != null) {
                int i = this.lastEntryPageBeforeLinkClick == -1 ? 0 : this.lastEntryPageBeforeLinkClick;
                this.lastEntryPageBeforeLinkClick = -1;
                this.currentEntryJSON = this.prevEntryJSON;
                this.resetEntry();
                this.entryPageNumber = i;
            }
            this.decrementingPage = false;
            this.updatePageRenderers();
        }
        if (this.nextEntryJSON != null) {
            this.prevEntryJSON = this.currentEntryJSON;
            this.currentEntryJSON = this.nextEntryJSON;
            this.nextEntryJSON = null;
            this.nextEntry = null;
            this.resetEntry();
        }
    }

    public void resetEntry() {
        if (this.currentEntryJSON != null) {
            this.currentEntry = this.readBookEntry(this.currentEntryJSON);
            if (this.currentEntry != null) {
                this.currentEntry.init(this);
            }
        }
        this.prevEntryJSON = this.currentEntry != null && this.currentEntry.getParent() != null && !this.currentEntry.getParent().isEmpty() ? new ResourceLocation(PaleonomiconScreen.getBookFileDirectory() + this.currentEntry.getParent()) : null;
        if (this.prevEntryJSON != null) {
            this.prevEntry = this.readBookEntry(this.prevEntryJSON);
            if (this.prevEntry != null) {
                this.prevEntry.init(this);
            }
        }
        if (this.nextEntryJSON != null) {
            this.nextEntry = this.readBookEntry(this.nextEntryJSON);
            if (this.nextEntry != null) {
                this.nextEntry.init(this);
            }
        }
        if (this.currentEntry != null) {
            this.entryPageNumber = 0;
        }
        this.updatePageRenderers();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float fakePartialTickThatsZeroForSomeReason) {
        boolean hoveringOverHome;
        this.m_7522_(null);
        this.m_280273_(guiGraphics);
        float partialTick = Minecraft.m_91087_().getPartialTick();
        PoseStack poseStack = guiGraphics.m_280168_();
        guiGraphics.m_280168_().m_85836_();
        poseStack.m_252880_(0.0f, -10.0f, 1.0f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280163_(BOOK_TEXTURE, this.leftPos, this.topPos, 16.0f, 16.0f, this.imageWidth, this.imageHeight, 510, 510);
        if (this.entryPageNumber == 0) {
            guiGraphics.m_280163_(BOOK_TEXTURE, this.leftPos + 27, this.topPos + 24, 336.0f, 16.0f, 112, 32, 510, 510);
        }
        boolean hoveringOverRight = mouseX >= this.leftPos + this.nextButtonStartX && mouseX <= this.leftPos + this.nextButtonEndX && mouseY >= this.topPos + this.buttonStartY && mouseY <= this.topPos + this.buttonEndY;
        boolean hoveringOverLeft = mouseX >= this.leftPos + this.prevButtonStartX && mouseX <= this.leftPos + this.prevButtonEndX && mouseY >= this.topPos + this.buttonStartY && mouseY <= this.topPos + this.buttonEndY;
        boolean bl = hoveringOverHome = mouseX >= this.leftPos + this.homeButtonStartX && mouseX <= this.leftPos + this.homeButtonEndX && mouseY >= this.topPos + this.homeButtonStartY - 12 && mouseY <= this.topPos + this.homeButtonEndY - 12;
        if (this.canGoLeft()) {
            guiGraphics.m_280163_(BOOK_TEXTURE, this.leftPos + 10, this.topPos + 155, 336.0f, hoveringOverLeft ? 192.0f : 160.0f, 48, 32, 510, 510);
        }
        if (this.canGoRight()) {
            guiGraphics.m_280163_(BOOK_TEXTURE, this.leftPos + 265, this.topPos + 155, 336.0f, hoveringOverRight ? 128.0f : 96.0f, 48, 32, 510, 510);
        }
        guiGraphics.m_280163_(BOOK_TEXTURE, this.leftPos + this.homeButtonStartX, this.topPos + this.homeButtonStartY, 336.0f, hoveringOverHome ? 48.0f : 56.0f, 20, 36, 510, 510);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(this.leftPos + 28), (float)(this.topPos + 28), 0.0f);
        poseStack.m_85836_();
        poseStack.m_85841_(0.85f, 0.85f, 0.0f);
        this.renderBookContents(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280262_();
        poseStack.m_85849_();
        poseStack.m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.leftPos, (float)this.topPos, 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BOOK_TEXTURE);
        guiGraphics.m_280168_().m_85849_();
        if (this.currentEntry != null) {
            this.currentEntry.mouseOver(this, this.entryPageNumber, mouseX, mouseY);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, fakePartialTickThatsZeroForSomeReason);
        this.addLinkButtons();
        if (this.entityTooltip != null) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(-5.0f, 10.0f, 550.0f);
            guiGraphics.m_280245_(this.f_96547_, Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)this.entityTooltip), Math.max(this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
            this.entityTooltip = null;
            guiGraphics.m_280168_().m_85849_();
        }
        if (this.unlockTooltip) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)"book.marvelous_menagerie.page_locked_0").m_130940_(ChatFormatting.GRAY));
            list.add(Component.m_237115_((String)"book.marvelous_menagerie.page_locked_1").m_130940_(ChatFormatting.GRAY));
            guiGraphics.m_280677_(this.f_96547_, list, Optional.empty(), mouseX - 5, mouseY - 5);
        }
        poseStack.m_85849_();
    }

    private void renderBookContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderForPageType(this.leftPageRenderer, 0, graphics, mouseX, mouseY, partialTick);
        this.renderForPageType(this.rightPageRenderer, 1, graphics, mouseX, mouseY, partialTick);
    }

    private void renderForPageType(PaleonomiconPage contents, int kind, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        if (kind == 1) {
            poseStack.m_252880_(173.0f, 0.0f, 0.0f);
        }
        contents.renderPage(this, graphics, mouseX, mouseY, partialTick, kind >= 2);
        poseStack.m_85849_();
    }

    public void updatePageRenderers() {
        this.leftPageRenderer.setEntryPageNumber(this.entryPageNumber);
        this.leftPageRenderer.setEntry(this.currentEntry);
        this.rightPageRenderer.setEntryPageNumber(this.entryPageNumber);
        this.rightPageRenderer.setEntry(this.currentEntry);
    }

    private boolean isBookOpened() {
        return this.currentEntry != null;
    }

    public boolean canGoLeft() {
        return this.isBookOpened() && (this.entryPageNumber > 0 || this.prevEntryJSON != null);
    }

    public boolean canGoRight() {
        return this.isBookOpened() && this.entryPageNumber + 1 < this.currentEntry.getPageCount();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean prev = super.m_6375_(mouseX, mouseY, button);
        if (!prev) {
            boolean hoveringOverHome;
            if (this.currentEntry != null && this.currentEntry.consumeMouseClick(this)) {
                return true;
            }
            boolean bl = hoveringOverHome = mouseX >= (double)(this.leftPos + this.homeButtonStartX) && mouseX <= (double)(this.leftPos + this.homeButtonEndX) && mouseY >= (double)(this.topPos + this.homeButtonStartY - 12) && mouseY <= (double)(this.topPos + this.homeButtonEndY - 12);
            if (hoveringOverHome) {
                this.currentEntryJSON = this.rootEntryJSON;
                this.resetEntry();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                return true;
            }
            if (!this.decrementingPage && !this.incrementingPage) {
                boolean hoveringOverLeft;
                boolean hoveringOverRight = mouseX >= (double)(this.leftPos + this.nextButtonStartX) && mouseX <= (double)(this.leftPos + this.nextButtonEndX) && mouseY >= (double)(this.topPos + this.buttonStartY) && mouseY <= (double)(this.topPos + this.buttonEndY);
                boolean bl2 = hoveringOverLeft = mouseX >= (double)(this.leftPos + this.prevButtonStartX) && mouseX <= (double)(this.leftPos + this.prevButtonEndX) && mouseY >= (double)(this.topPos + this.buttonStartY) && mouseY <= (double)(this.topPos + this.buttonEndY);
                if (hoveringOverLeft && this.canGoLeft()) {
                    this.decrementingPage = true;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                    return true;
                }
                if (hoveringOverRight && this.canGoRight()) {
                    this.incrementingPage = true;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Nullable
    protected BookEntry readBookEntry(ResourceLocation res) {
        BookEntry page;
        block3: {
            Optional resource = null;
            page = null;
            try {
                resource = Minecraft.m_91087_().m_91098_().m_213713_(res);
                if (resource.isPresent()) {
                    BufferedReader inputstream = ((Resource)resource.get()).m_215508_();
                    page = BookEntry.deserialize(inputstream);
                }
            }
            catch (IOException e1) {
                if (e1 instanceof AccessDeniedException) break block3;
                e1.printStackTrace();
            }
        }
        return page;
    }

    public int getEntryPageNumber() {
        return this.entryPageNumber;
    }

    public static String getBookFileDirectory() {
        return "marvelous_menagerie:books/";
    }

    public boolean attemptChangePage(ResourceLocation changePageTo, boolean goingForwards) {
        if (goingForwards) {
            this.prevEntryJSON = this.currentEntryJSON;
        }
        this.nextEntryJSON = changePageTo;
        if (goingForwards) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        }
        return true;
    }

    public static void fixLighting() {
        Vector3f light0 = new Vector3f(1.0f, 1.0f, -1.0f);
        Vector3f light1 = new Vector3f(1.0f, 1.0f, -1.0f);
        RenderSystem.setShaderLights((Vector3f)light0, (Vector3f)light1);
    }

    public void setEntityTooltip(String hoverText) {
        this.entityTooltip = hoverText;
    }

    protected int getBindingColor() {
        return 6961942;
    }

    protected int getWidgetColor() {
        return this.getBindingColor();
    }

    protected ResourceLocation getBookWidgetTexture() {
        return BOOK_WIDGET_TEXTURE;
    }

    private boolean isIndex() {
        return this.currentEntry != null && this.currentEntry.getIsIndex();
    }

    private void addLinkButtons() {
        this.f_169369_.clear();
        this.m_169413_();
        if (this.isIndex()) {
            this.renderIndexButtons();
        }
    }

    private void renderIndexButtons() {
        int k = (this.f_96543_ - this.xSize) / 2;
        int l = (this.f_96544_ - this.ySize + 128) / 2;
        int linkDataSize = 0;
        this.currentIndexLinkData.clear();
        for (int i = 0; i < this.indexLinkData.size(); ++i) {
            List<IndexTagsCodec> indexes = this.indexLinkData.get(i).getTags();
            for (IndexTagsCodec j : indexes) {
                if (!Objects.equals(j.getIndex(), this.currentEntry.getTranslatableTitle())) continue;
                this.currentIndexLinkData.add(this.indexLinkData.get(i));
                ++linkDataSize;
            }
        }
        int rowCount = 0;
        int columnCount = 0;
        boolean isRight = false;
        int startingEntity = 0;
        if (this.entryPageNumber != 0) {
            int startingSize = 25;
            startingEntity = this.entryPageNumber == 1 ? linkDataSize - (linkDataSize - startingSize * (startingSize - 0)) : linkDataSize - (linkDataSize - startingSize * (startingSize - 0) * 2);
            if (startingEntity < 0) {
                return;
            }
        }
        int startingOffsetX = 16;
        int startingOffsetY = 16;
        if (this.entryPageNumber == 0) {
            startingOffsetX += 57;
        }
        startingOffsetY += 13;
        if (this.entryPageNumber < 0) {
            return;
        }
        for (int i = startingEntity; i < linkDataSize; ++i) {
            String icon = this.currentIndexLinkData.get(i).getItem();
            String name = this.currentIndexLinkData.get(i).getEntity();
            String link = this.currentIndexLinkData.get(i).getLink();
            if (rowCount == (isRight ? 6 : 5) || this.entryPageNumber != 0 && i > startingEntity + 50) break;
            String finalLink = link;
            this.m_142416_((GuiEventListener)new EntityLinkButton(this, icon, name, startingOffsetX + k + columnCount * 24, startingOffsetY + l + rowCount * 22, p_213021_1_ -> this.attemptChangePage(new ResourceLocation(PaleonomiconScreen.getBookFileDirectory() + finalLink), true)));
            if (++columnCount == 5) {
                ++rowCount;
                columnCount = 0;
            }
            if (rowCount == 5 && !isRight) {
                startingOffsetX = 220;
                startingOffsetY = 5;
                rowCount = 0;
                columnCount = 0;
                isRight = true;
            }
            if (rowCount == 6 && isRight) break;
        }
    }
}

