/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.screen.book.widget;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.voidarkana.marvelous_menagerie.client.renderer.rendertypes.MMRenderTypes;
import net.voidarkana.marvelous_menagerie.client.screen.book.widget.BookWidget;
import net.voidarkana.marvelous_menagerie.client.screen.book.widget.ItemWidget;
import net.voidarkana.marvelous_menagerie.common.block.MMBlocks;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CraftingRecipeWidget
extends BookWidget {
    @Expose
    @SerializedName(value="recipe_id")
    private String recipeId;
    @Expose
    private boolean sepia;
    @Expose(serialize=false, deserialize=false)
    private Recipe recipe;
    private static final int GRID_TEXTURE_SIZE = 64;
    @Expose(serialize=false, deserialize=false)
    private boolean smelting = false;
    private static final ResourceLocation CRAFTING_GRID_TEXTURE = new ResourceLocation("marvelous_menagerie", "textures/gui/book/crafting_grid.png");
    private static final ResourceLocation SMELTING_GRID_TEXTURE = new ResourceLocation("marvelous_menagerie", "textures/gui/book/smelting_grid.png");

    public CraftingRecipeWidget(int displayPage, String recipeId, boolean sepia, int x, int y, float scale) {
        super(displayPage, BookWidget.Type.CRAFTING_RECIPE, x, y, scale);
        this.recipeId = recipeId;
        this.sepia = sepia;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, boolean onFlippingPage, int mouseX, int mouseY) {
        if (this.recipe == null && this.recipeId != null) {
            this.recipe = this.getRecipeByName(this.recipeId);
            if (this.recipe instanceof AbstractCookingRecipe) {
                this.smelting = true;
            }
        }
        if (this.recipe != null) {
            float texHeight;
            float texWidth;
            float scaledV1;
            float scaledU1;
            float itemScale = 16.0f;
            float playerTicks = Minecraft.m_91087_().f_91074_.f_19797_;
            VertexConsumer vertexconsumer = bufferSource.m_6299_(MMRenderTypes.getBookWidget(this.smelting ? SMELTING_GRID_TEXTURE : CRAFTING_GRID_TEXTURE, this.sepia));
            poseStack.m_85836_();
            poseStack.m_252880_((float)this.getX(), (float)this.getY(), 0.0f);
            poseStack.m_85841_(this.getScale(), this.getScale(), 1.0f);
            poseStack.m_85836_();
            poseStack.m_85841_(1.5f, 1.5f, 1.0f);
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            if (this.smelting) {
                scaledU1 = 0.859375f;
                scaledV1 = 0.578125f;
                texWidth = 27.5f;
                texHeight = 18.5f;
            } else {
                texWidth = 30.0f;
                texHeight = 20.0f;
                scaledU1 = 0.9375f;
                scaledV1 = 0.625f;
            }
            vertexconsumer.m_252986_(matrix4f, -texWidth, -texHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, texWidth, -texHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(scaledU1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_7421_(0.0f, scaledV1).m_5752_();
            vertexconsumer.m_252986_(matrix4f, texWidth, texHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(scaledU1, scaledV1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, -texWidth, texHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, scaledV1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_7421_(scaledU1, 0.0f).m_5752_();
            poseStack.m_85849_();
            if (this.smelting) {
                poseStack.m_85836_();
                poseStack.m_252880_(43.0f, -15.0f, 0.0f);
                poseStack.m_85841_(1.35f, 1.35f, 1.0f);
                ItemStack output = this.recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_());
                if (output.m_150930_(Items.f_42009_)) {
                    output = new ItemStack((ItemLike)MMBlocks.CHEST_BOOK.get());
                }
                if (output.m_150930_(((Block)MMBlocks.PALEO_TABLE.get()).m_5456_())) {
                    output = new ItemStack((ItemLike)MMBlocks.PALEO_TABLE_BOOK.get());
                }
                if (output.m_150930_(((Block)MMBlocks.CHRONO_ALTAR.get()).m_5456_())) {
                    output = new ItemStack((ItemLike)MMBlocks.CHRONO_ALTAR_BOOK.get());
                }
                if (output.m_150930_(((Block)MMBlocks.CHRONO_PEDESTAL.get()).m_5456_())) {
                    output = new ItemStack((ItemLike)MMBlocks.CHRONO_PEDESTAL_BOOK.get());
                }
                ItemWidget.renderItem(output, poseStack, bufferSource, this.sepia, itemScale * 1.25f);
                poseStack.m_85849_();
                Ingredient ing = (Ingredient)this.recipe.m_7527_().get(0);
                ItemStack stack = ItemStack.f_41583_;
                if (!ing.m_43947_()) {
                    if (ing.m_43908_().length > 1) {
                        int currentIndex = (int)(playerTicks / 20.0f % (float)ing.m_43908_().length);
                        stack = ing.m_43908_()[currentIndex];
                    } else {
                        stack = ing.m_43908_()[0];
                    }
                }
                poseStack.m_85836_();
                poseStack.m_252880_(-27.5f, -12.5f, 0.0f);
                if (stack.m_150930_(Items.f_42009_)) {
                    stack = new ItemStack((ItemLike)MMBlocks.CHEST_BOOK.get());
                }
                if (stack.m_150930_(((Block)MMBlocks.PALEO_TABLE.get()).m_5456_())) {
                    stack = new ItemStack((ItemLike)MMBlocks.PALEO_TABLE_BOOK.get());
                }
                if (stack.m_150930_(((Block)MMBlocks.CHRONO_ALTAR.get()).m_5456_())) {
                    stack = new ItemStack((ItemLike)MMBlocks.CHRONO_ALTAR_BOOK.get());
                }
                if (stack.m_150930_(((Block)MMBlocks.CHRONO_PEDESTAL.get()).m_5456_())) {
                    stack = new ItemStack((ItemLike)MMBlocks.CHRONO_PEDESTAL_BOOK.get());
                }
                ItemWidget.renderItem(stack, poseStack, bufferSource, this.sepia, itemScale);
                poseStack.m_85849_();
            } else {
                poseStack.m_85836_();
                poseStack.m_252880_(60.0f, -1.0f, 0.0f);
                poseStack.m_85841_(1.35f, 1.35f, 1.0f);
                ItemStack output = this.recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_());
                if (output.m_150930_(Items.f_42009_)) {
                    output = new ItemStack((ItemLike)MMBlocks.CHEST_BOOK.get());
                }
                if (output.m_150930_(((Block)MMBlocks.PALEO_TABLE.get()).m_5456_())) {
                    output = new ItemStack((ItemLike)MMBlocks.PALEO_TABLE_BOOK.get());
                }
                if (output.m_150930_(((Block)MMBlocks.CHRONO_ALTAR.get()).m_5456_())) {
                    output = new ItemStack((ItemLike)MMBlocks.CHRONO_ALTAR_BOOK.get());
                }
                if (output.m_150930_(((Block)MMBlocks.CHRONO_PEDESTAL.get()).m_5456_())) {
                    output = new ItemStack((ItemLike)MMBlocks.CHRONO_PEDESTAL_BOOK.get());
                }
                ItemWidget.renderItem(output, poseStack, bufferSource, this.sepia, itemScale * 1.25f);
                poseStack.m_85849_();
                NonNullList ingredients = this.recipe.m_7527_();
                NonNullList displayedStacks = NonNullList.m_122779_();
                int width = 3;
                int height = 3;
                Recipe recipe = this.recipe;
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    width = shapedRecipe.m_44220_();
                    height = shapedRecipe.m_44221_();
                }
                int renderY = 0;
                int renderX = 0;
                poseStack.m_85836_();
                poseStack.m_85841_(1.025f, 1.025f, 1.0f);
                poseStack.m_85837_(0.0, -0.1, 0.0);
                for (int i = 0; i < ingredients.size(); ++i) {
                    Ingredient ing = (Ingredient)ingredients.get(i);
                    ItemStack stack = ItemStack.f_41583_;
                    if (!ing.m_43947_()) {
                        if (ing.m_43908_().length > 1) {
                            int currentIndex = (int)(playerTicks / 20.0f % (float)ing.m_43908_().length);
                            stack = ing.m_43908_()[currentIndex];
                        } else {
                            stack = ing.m_43908_()[0];
                        }
                    }
                    if (i % width == 0) {
                        if (i != 0) {
                            ++renderY;
                        }
                        renderX = 0;
                    } else {
                        ++renderX;
                    }
                    if (!stack.m_41619_()) {
                        if (stack.m_150930_(Items.f_42009_)) {
                            stack = new ItemStack((ItemLike)MMBlocks.CHEST_BOOK.get());
                        }
                        if (stack.m_150930_(((Block)MMBlocks.PALEO_TABLE.get()).m_5456_())) {
                            stack = new ItemStack((ItemLike)MMBlocks.PALEO_TABLE_BOOK.get());
                        }
                        if (stack.m_150930_(((Block)MMBlocks.CHRONO_ALTAR.get()).m_5456_())) {
                            stack = new ItemStack((ItemLike)MMBlocks.CHRONO_ALTAR_BOOK.get());
                        }
                        if (stack.m_150930_(((Block)MMBlocks.CHRONO_PEDESTAL.get()).m_5456_())) {
                            stack = new ItemStack((ItemLike)MMBlocks.CHRONO_PEDESTAL_BOOK.get());
                        }
                        poseStack.m_85836_();
                        poseStack.m_252880_((float)(-33 + renderX * 19), -18.5f + (float)(renderY * 19), 0.0f);
                        ItemWidget.renderItem(stack, poseStack, bufferSource, this.sepia, itemScale);
                        poseStack.m_85849_();
                    }
                    displayedStacks.add(i, (Object)stack);
                }
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    private Recipe getRecipeByName(String registryName) {
        try {
            RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
            if (manager.m_44043_(new ResourceLocation(registryName)).isPresent()) {
                return (Recipe)manager.m_44043_(new ResourceLocation(registryName)).get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

