/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.screen.fossil;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.marvelous_menagerie.client.screen.guiparticle.DistortableGUIParticle;
import net.voidarkana.marvelous_menagerie.client.screen.guiparticle.GUIParticle;
import net.voidarkana.marvelous_menagerie.client.screen.guiparticle.GUIParticleSystem;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.util.Mathf;
import net.voidarkana.marvelous_menagerie.util.lambda.Funcf2;
import net.voidarkana.marvelous_menagerie.util.network.MMMessages;
import net.voidarkana.marvelous_menagerie.util.network.message.ChangeFossilMessage;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public class FossilMinigameScreen
extends Screen {
    public GUIParticleSystem particles;
    public static final ResourceLocation GUI = new ResourceLocation("marvelous_menagerie", "textures/gui/fossil/fossil_minigame.png");
    public static final ResourceLocation VIGNETTE = new ResourceLocation("marvelous_menagerie", "textures/gui/fossil/fossil_minigame_2.png");
    final int dirtSize = 176;
    int imageWidth;
    int imageHeight;
    int leftPos;
    int topPos;
    Player player;
    BlockPos clickedPos;
    private boolean draggingChisel = false;
    private boolean draggingHammer = false;
    private boolean draggingPick = false;
    private float chiselPosXInit;
    private float chiselPosYInit;
    private float chiselPosX;
    private float chiselPosY;
    private float prevChiselPosX;
    private float prevChiselPosY;
    private float hammerPosXInit;
    private float hammerPosYInit;
    private float hammerPosX;
    private float hammerPosY;
    private float prevHammerPosX;
    private float prevHammerPosY;
    private float pickPosXInit;
    private float pickPosYInit;
    private float pickPosX;
    private float pickPosY;
    private float prevPickPosX;
    private float prevPickPosY;
    private int lastMouseX;
    private int lastMouseY;
    int bone1TileX = 0;
    int bone1TileY = 0;
    private int bone1Damage = 0;
    private boolean bone1Undiscovered = true;
    int bone2TileX = 0;
    int bone2TileY = 0;
    private int bone2Damage = 0;
    private boolean bone2Undiscovered = true;
    int bone3TileX = 0;
    int bone3TileY = 0;
    private int bone3Damage = 0;
    private boolean bone3Undiscovered = true;
    boolean hasAppliedDamage;
    int maxHits = 15;
    int currentHits;
    public Boolean isDud;
    int successLevel = 0;
    public int[][] tileHasFossil = new int[7][7];
    public int[][] tileSoilLevel = new int[7][7];
    public int[][] dirtParticleTicks = new int[7][7];
    public int[][] stoneParticleTicks = new int[7][7];
    public int[][] deepslateParticleTicks = new int[7][7];
    int fossilProgress1;
    int fossilProgress2;
    int fossilProgress3;
    double lastClicked1X;
    double lastClicked1Y;
    double lastClicked2X;
    double lastClicked2Y;
    double lastClicked3X;
    double lastClicked3Y;
    int shakeProgress = 0;
    double shakeAmount = 0.0;
    int shakeX = 1;
    int shakeY = 1;

    public FossilMinigameScreen(Player pPlayer, BlockPos clicked) {
        super((Component)Component.m_237115_((String)"fossil.title"));
        this.player = pPlayer;
        this.imageWidth = 241;
        this.imageHeight = 176;
        this.plantFalseEvidence();
        this.currentHits = 0;
        this.clickedPos = clicked;
        this.particles = new GUIParticleSystem();
    }

    protected void plantFalseEvidence() {
        int tempyBig;
        int tempxBig;
        int tempySmall;
        int tempxSmall;
        int tempyMed;
        int tempxMed;
        this.isDud = this.player.m_217043_().m_188503_(10) == 0;
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 7; ++y) {
                this.tileHasFossil[x][y] = 0;
                this.dirtParticleTicks[x][y] = 0;
                this.stoneParticleTicks[x][y] = 0;
                this.deepslateParticleTicks[x][y] = 0;
            }
        }
        int array = this.player.m_217043_().m_188503_(3);
        if (array == 0) {
            tempxMed = this.player.m_217043_().m_216339_(3, 6);
            tempyMed = this.player.m_217043_().m_216339_(0, 2);
            tempxSmall = this.player.m_217043_().m_216339_(0, 3);
            tempySmall = this.player.m_217043_().m_216339_(0, 5);
            tempxBig = this.player.m_217043_().m_216339_(3, 5);
            tempyBig = this.player.m_217043_().m_216339_(3, 6);
        } else if (array == 1) {
            tempxMed = this.player.m_217043_().m_216339_(3, 6);
            tempyMed = this.player.m_217043_().m_216339_(3, 6);
            tempxSmall = this.player.m_217043_().m_216339_(3, 7);
            tempySmall = this.player.m_217043_().m_216339_(0, 2);
            tempxBig = 0;
            tempyBig = this.player.m_217043_().m_216339_(3, 6);
        } else {
            tempxMed = this.player.m_217043_().m_216339_(0, 2);
            tempyMed = this.player.m_217043_().m_216339_(0, 6);
            tempxSmall = this.player.m_217043_().m_216339_(3, 7);
            tempySmall = this.player.m_217043_().m_216339_(3, 6);
            tempxBig = this.player.m_217043_().m_216339_(3, 5);
            tempyBig = this.player.m_217043_().m_216339_(0, 2);
        }
        this.bone1TileX = tempxMed;
        this.bone1TileY = tempyMed;
        this.tileHasFossil[tempxMed][tempyMed] = 1;
        this.tileHasFossil[tempxMed + 1][tempyMed] = 1;
        this.tileHasFossil[tempxMed][tempyMed + 1] = 1;
        this.tileHasFossil[tempxMed + 1][tempyMed + 1] = 1;
        this.bone2TileX = tempxSmall;
        this.bone2TileY = tempySmall;
        this.tileHasFossil[tempxSmall][tempySmall] = 2;
        this.tileHasFossil[tempxSmall][tempySmall + 1] = 2;
        this.bone3TileX = tempxBig;
        this.bone3TileY = tempyBig;
        this.tileHasFossil[tempxBig][tempyBig] = 3;
        this.tileHasFossil[tempxBig + 1][tempyBig] = 3;
        this.tileHasFossil[tempxBig + 2][tempyBig] = 3;
        this.tileHasFossil[tempxBig][tempyBig + 1] = 3;
        this.tileHasFossil[tempxBig + 1][tempyBig + 1] = 3;
        this.tileHasFossil[tempxBig + 2][tempyBig + 1] = 3;
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 7; ++y) {
                if (this.tileHasFossil[x][y] > 0) {
                    if (this.player.m_217043_().m_188499_()) {
                        this.tileSoilLevel[x][y] = this.player.m_217043_().m_216339_(2, 4);
                        continue;
                    }
                    if (this.player.m_217043_().m_188499_()) {
                        this.tileSoilLevel[x][y] = this.player.m_217043_().m_216339_(1, 4);
                        continue;
                    }
                    this.tileSoilLevel[x][y] = this.player.m_217043_().m_216339_(0, 2);
                    continue;
                }
                this.tileSoilLevel[x][y] = this.player.m_217043_().m_188499_() ? (this.player.m_217043_().m_188499_() ? this.player.m_217043_().m_216339_(1, 4) : this.player.m_217043_().m_216339_(1, 3)) : this.player.m_217043_().m_216339_(0, 2);
                int spreadChanceX = this.player.m_217043_().m_188503_(6);
                int spreadChanceY = this.player.m_217043_().m_188503_(6);
                if (x > 0 && (this.tileSoilLevel[x - 1][y] > 0 && this.tileSoilLevel[x - 1][y] < 3 || this.tileSoilLevel[x - 1][y] == 3 && this.player.m_217043_().m_188499_()) && spreadChanceX == 0) {
                    this.tileSoilLevel[x][y] = this.tileSoilLevel[x - 1][y];
                }
                if (y <= 0 || (this.tileSoilLevel[x][y - 1] <= 0 || this.tileSoilLevel[x][y - 1] >= 3) && (this.tileSoilLevel[x][y - 1] != 3 || !this.player.m_217043_().m_188499_()) || spreadChanceY != 0) continue;
                this.tileSoilLevel[x][y] = this.tileSoilLevel[x][y - 1];
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.chiselPosXInit = this.prevChiselPosX = (this.chiselPosX = (float)(this.leftPos + 185));
        this.chiselPosYInit = this.prevChiselPosY = (this.chiselPosY = (float)(this.topPos + 63));
        this.hammerPosXInit = this.prevHammerPosX = (this.hammerPosX = (float)(this.leftPos + 185 + 18));
        this.hammerPosYInit = this.prevHammerPosY = (this.hammerPosY = (float)(this.topPos + 63));
        this.pickPosXInit = this.prevPickPosX = (this.pickPosX = (float)(this.leftPos + 185 + 36));
        this.pickPosYInit = this.prevPickPosY = (this.pickPosY = (float)(this.topPos + 63));
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.particles.update();
        this.m_7522_(null);
        this.m_280273_(pGuiGraphics);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85837_(this.shakeAmount * (double)this.shakeX, this.shakeAmount * (double)this.shakeY, 0.0);
        int i = this.leftPos;
        int j = this.topPos;
        this.lastMouseX = pMouseX;
        this.lastMouseY = pMouseY;
        pGuiGraphics.m_280218_(GUI, i, j, 0, 0, this.imageWidth, this.imageHeight);
        this.renderClockArm(pGuiGraphics);
        this.renderBones(pGuiGraphics);
        this.renderSoil(pGuiGraphics);
        this.drawTexturedQuadColor(pGuiGraphics, VIGNETTE, this.leftPos + 32, this.leftPos + 32 + 112, this.topPos + 32, this.topPos + 32 + 112, 0.0f, 0.0f, 0.4375f, 0.0f, 0.4375f, 0.0f, 0.0f, 0.0f, 0.8f);
        this.renderTools(pGuiGraphics);
        this.renderSelection(pGuiGraphics, pMouseX, pMouseY);
        this.renderParticles(pGuiGraphics);
        pGuiGraphics.m_280168_().m_85849_();
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)i, (float)j, 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
        pGuiGraphics.m_280168_().m_85849_();
        RenderSystem.disableDepthTest();
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)i, (float)j, 0.0f);
        pGuiGraphics.m_280168_().m_85849_();
        RenderSystem.enableDepthTest();
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderSoil(GuiGraphics pGuiGraphics) {
        int y;
        int x;
        for (x = 0; x < 7; ++x) {
            for (y = 0; y < 7; ++y) {
                if (this.tileSoilLevel[x][y] <= 0) continue;
                pGuiGraphics.m_280218_(GUI, this.leftPos + 32 + x * 16, this.topPos + 32 + y * 16, 208, 208, 16, y == 6 ? 16 : 20);
            }
        }
        for (x = 0; x < 7; ++x) {
            for (y = 0; y < 7; ++y) {
                if (this.tileSoilLevel[x][y] <= 1) continue;
                pGuiGraphics.m_280218_(GUI, this.leftPos + 32 + x * 16, this.topPos + 32 + y * 16, 224, 208, 16, y == 6 ? 16 : 20);
            }
        }
        for (x = 0; x < 7; ++x) {
            for (y = 0; y < 7; ++y) {
                if (this.tileSoilLevel[x][y] <= 2) continue;
                pGuiGraphics.m_280218_(GUI, this.leftPos + 32 + x * 16, this.topPos + 32 + y * 16, 240, 208, 16, y == 6 ? 16 : 20);
            }
        }
    }

    public void renderBones(GuiGraphics pGuiGraphics) {
        PoseStack poseStack;
        if (this.bone1Damage < 2 && (this.bone1Undiscovered || this.fossilProgress1 > 0)) {
            poseStack = pGuiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)(this.leftPos + 32 + this.bone1TileX * 16 + 16), (float)(this.topPos + 32 + this.bone1TileY * 16 + 16), 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.fossilProgress1 * 36.0f));
            if (this.fossilProgress1 > 0) {
                poseStack.m_85841_((float)this.fossilProgress1 / 10.0f, (float)this.fossilProgress1 / 10.0f, (float)this.fossilProgress1 / 10.0f);
            }
            pGuiGraphics.m_280218_(VIGNETTE, -16, -16, this.isDud != false ? 0 : 48, 192 + 32 * this.bone1Damage, 32, 32);
            poseStack.m_85849_();
        }
        if (this.bone2Damage < 2 && (this.bone2Undiscovered || this.fossilProgress2 > 0)) {
            poseStack = pGuiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)(this.leftPos + 32 + this.bone2TileX * 16 + 8), (float)(this.topPos + 32 + this.bone2TileY * 16 + 16), 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.fossilProgress2 * 36.0f));
            if (this.fossilProgress2 > 0) {
                poseStack.m_85841_((float)this.fossilProgress2 / 10.0f, (float)this.fossilProgress2 / 10.0f, (float)this.fossilProgress2 / 10.0f);
            }
            pGuiGraphics.m_280218_(VIGNETTE, -8, -16, 32, 192 + 32 * this.bone2Damage, 16, 32);
            poseStack.m_85849_();
        }
        if (this.bone3Damage < 2 && (this.bone3Undiscovered || this.fossilProgress3 > 0)) {
            poseStack = pGuiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)(this.leftPos + 32 + this.bone3TileX * 16 + 16 + 8), (float)(this.topPos + 32 + this.bone3TileY * 16 + 16), 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.fossilProgress3 * 36.0f));
            if (this.fossilProgress3 > 0) {
                poseStack.m_85841_((float)this.fossilProgress3 / 10.0f, (float)this.fossilProgress3 / 10.0f, (float)this.fossilProgress3 / 10.0f);
            }
            pGuiGraphics.m_280218_(VIGNETTE, -24, -16, 80, 192 + 32 * this.bone3Damage, 48, 32);
            poseStack.m_85849_();
        }
    }

    public void renderSelection(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        if (this.draggingChisel && pMouseX > this.leftPos + 33 && pMouseX < this.leftPos + 144 && pMouseY > this.topPos + 32 && pMouseY < this.topPos + 140) {
            pGuiGraphics.m_280218_(GUI, this.getUnevenSlotX(pMouseX) * 16 + this.leftPos + 32, this.getUnevenSlotY(pMouseY) * 16 + this.topPos + 32, 0, 192, 16, 16);
        }
        if (this.draggingPick && pMouseX > this.leftPos + 33 + 16 && pMouseX < this.leftPos + 144 - 16 && pMouseY > this.topPos + 32 + 16 && pMouseY < this.topPos + 140 - 16) {
            int slotX = this.getUnevenSlotX(pMouseX);
            int slotY = this.getUnevenSlotY(pMouseY);
            int pUoffset = 32;
            int pVOffset = 176;
            int width = 48;
            int height = 48;
            pGuiGraphics.m_280218_(GUI, slotX * 16 + 16 + this.leftPos, slotY * 16 + 16 + this.topPos, pUoffset, pVOffset, width, height);
        }
        if (this.draggingHammer && pMouseX > this.leftPos + 33 + 8 && pMouseX < this.leftPos + 144 - 8 && pMouseY > this.topPos + 32 + 8 && pMouseY < this.topPos + 140 - 8) {
            pGuiGraphics.m_280218_(GUI, this.getEvenSlotX(pMouseX) * 16 + this.leftPos + 16, this.getEvenSlotY(pMouseY) * 16 + this.topPos + 16, 96, 176, 32, 32);
        }
    }

    public void renderTools(GuiGraphics pGuiGraphics) {
        this.renderChisel(pGuiGraphics);
        this.renderHammer(pGuiGraphics);
        this.renderPick(pGuiGraphics);
    }

    public int getUnevenSlotX(int x) {
        int totalX = (x - this.leftPos) / 16 - 2;
        return Math.max(Math.min(totalX, 6), 0);
    }

    public int getUnevenSlotY(int y) {
        int totalY = (y - this.topPos) / 16 - 2;
        return Math.max(Math.min(totalY, 6), 0);
    }

    public int getEvenSlotX(int x) {
        int totalX = (x - this.leftPos + 8) / 16 - 2;
        return Math.max(Math.min(totalX, 6), 0);
    }

    public int getEvenSlotY(int y) {
        int totalY = (y - this.topPos + 8) / 16 - 2;
        return Math.max(Math.min(totalY, 6), 0);
    }

    public void renderParticles(GuiGraphics pGuiGraphics) {
        PoseStack poseStack = pGuiGraphics.m_280168_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
        pGuiGraphics.m_280168_().m_85836_();
        this.particles.draw(poseStack, this);
        pGuiGraphics.m_280168_().m_85849_();
        if (this.fossilProgress1 > 0) {
            pGuiGraphics.m_280168_().m_85836_();
            poseStack.m_85837_(this.lastClicked1X, this.lastClicked1Y, 0.0);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.fossilProgress1 * 36.0f));
            poseStack.m_85841_(1.0f / (float)this.fossilProgress1 + 0.5f, 1.0f / (float)this.fossilProgress1 + 0.5f, 1.0f / (float)this.fossilProgress1 + 0.5f);
            this.drawTexturedQuadColor(pGuiGraphics, VIGNETTE, -16.0f, 16.0f, -16.0f, 16.0f, 1.0f, 0.0f, 0.125f, 0.4375f, 0.5625f, 1.0f, 1.0f, 1.0f, (float)this.fossilProgress1 / 10.0f);
            pGuiGraphics.m_280168_().m_85849_();
        }
        if (this.fossilProgress2 > 0) {
            pGuiGraphics.m_280168_().m_85836_();
            poseStack.m_85837_(this.lastClicked2X, this.lastClicked2Y, 0.0);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.fossilProgress2 * 36.0f));
            poseStack.m_85841_(1.0f / (float)this.fossilProgress2 + 0.5f, 1.0f / (float)this.fossilProgress2 + 0.5f, 1.0f / (float)this.fossilProgress2 + 0.5f);
            this.drawTexturedQuadColor(pGuiGraphics, VIGNETTE, -16.0f, 16.0f, -16.0f, 16.0f, 1.0f, 0.0f, 0.125f, 0.4375f, 0.5625f, 1.0f, 1.0f, 1.0f, (float)this.fossilProgress2 / 10.0f);
            pGuiGraphics.m_280168_().m_85849_();
        }
        if (this.fossilProgress3 > 0) {
            pGuiGraphics.m_280168_().m_85836_();
            poseStack.m_85837_(this.lastClicked3X, this.lastClicked3Y, 0.0);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.fossilProgress3 * 36.0f));
            poseStack.m_85841_(1.0f / (float)this.fossilProgress3 + 0.5f, 1.0f / (float)this.fossilProgress3 + 0.5f, 1.0f / (float)this.fossilProgress3 + 0.5f);
            this.drawTexturedQuadColor(pGuiGraphics, VIGNETTE, -16.0f, 16.0f, -16.0f, 16.0f, 1.0f, 0.0f, 0.125f, 0.4375f, 0.5625f, 1.0f, 1.0f, 1.0f, (float)this.fossilProgress3 / 10.0f);
            pGuiGraphics.m_280168_().m_85849_();
        }
    }

    public void renderClockArm(GuiGraphics pGuiGraphics) {
        PoseStack poseStack = pGuiGraphics.m_280168_();
        poseStack.m_85836_();
        float centerX = (float)this.leftPos + 208.5f;
        float centerY = (float)this.topPos + 119.5f;
        poseStack.m_252880_(centerX, centerY, 0.0f);
        float actualPartialTick = Minecraft.m_91087_().m_91296_();
        float red = (float)((Math.sin(((float)this.player.f_19797_ + actualPartialTick) * 0.2f * (float)(this.currentHits - 12)) + 1.0) / 2.0);
        if (this.currentHits > this.maxHits - 3) {
            poseStack.m_85841_(1.0f * red / 2.5f + 1.0f, 1.0f * red / 2.5f + 1.0f, 1.0f * red / 2.5f + 1.0f);
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)Math.min(360, this.currentHits * 24)));
        this.drawTexturedQuadColor(pGuiGraphics, GUI, -3.0f, 3.0f, -13.0f, 13.0f, 0.0f, 0.66015625f, 0.68359375f, 0.7578125f, 0.859375f, 1.0f, this.currentHits > this.maxHits - 3 ? red : 1.0f, this.currentHits > this.maxHits - 3 ? red : 1.0f, 1.0f);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    public void renderChisel(GuiGraphics guiGraphics) {
        float actualPartialTick = Minecraft.m_91087_().m_91296_();
        float lerpX = this.getChiselPosX(actualPartialTick);
        float lerpY = this.getChiselPosY(actualPartialTick);
        float zOffset = this.draggingChisel ? 500.0f : 200.0f;
        this.drawTexturedQuadColor(guiGraphics, GUI, lerpX, lerpX + 16.0f, lerpY, lerpY + 16.0f, zOffset, 0.8125f, 0.875f, 0.9375f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderHammer(GuiGraphics guiGraphics) {
        float actualPartialTick = Minecraft.m_91087_().m_91296_();
        float lerpX = this.getHammerPosX(actualPartialTick);
        float lerpY = this.getHammerPosY(actualPartialTick);
        float zOffset = this.draggingHammer ? 500.0f : 200.0f;
        this.drawTexturedQuadColor(guiGraphics, GUI, lerpX, lerpX + 16.0f, lerpY, lerpY + 16.0f, zOffset, 0.875f, 0.9375f, 0.9375f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderPick(GuiGraphics guiGraphics) {
        float actualPartialTick = Minecraft.m_91087_().m_91296_();
        float lerpX = this.getPickPosX(actualPartialTick);
        float lerpY = this.getPickPosY(actualPartialTick);
        float zOffset = this.draggingPick ? 500.0f : 200.0f;
        this.drawTexturedQuadColor(guiGraphics, GUI, lerpX, lerpX + 16.0f, lerpY, lerpY + 16.0f, zOffset, 0.9375f, 1.0f, 0.9375f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawTexturedQuadColor(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV, float pRed, float pGreen, float pBlue, float pAlpha) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)pAtlasLocation);
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = pGuiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_252986_(matrix4f, pX1, pY1, pBlitOffset).m_85950_(pRed, pGreen, pBlue, pAlpha).m_7421_(pMinU, pMinV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX1, pY2, pBlitOffset).m_85950_(pRed, pGreen, pBlue, pAlpha).m_7421_(pMinU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX2, pY2, pBlitOffset).m_85950_(pRed, pGreen, pBlue, pAlpha).m_7421_(pMaxU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX2, pY1, pBlitOffset).m_85950_(pRed, pGreen, pBlue, pAlpha).m_7421_(pMaxU, pMinV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public float getChiselPosX(float f) {
        return this.prevChiselPosX + (this.chiselPosX - this.prevChiselPosX) * f;
    }

    public float getChiselPosY(float f) {
        return this.prevChiselPosY + (this.chiselPosY - this.prevChiselPosY) * f;
    }

    public float getHammerPosX(float f) {
        return this.prevHammerPosX + (this.hammerPosX - this.prevHammerPosX) * f;
    }

    public float getHammerPosY(float f) {
        return this.prevHammerPosY + (this.hammerPosY - this.prevHammerPosY) * f;
    }

    public float getPickPosX(float f) {
        return this.prevPickPosX + (this.pickPosX - this.prevPickPosX) * f;
    }

    public float getPickPosY(float f) {
        return this.prevPickPosY + (this.pickPosY - this.prevPickPosY) * f;
    }

    public boolean m_7043_() {
        return false;
    }

    public final void m_86600_() {
        super.m_86600_();
        if (this.currentHits > this.maxHits) {
            this.f_96541_.f_91074_.m_6915_();
            if (this.successLevel == 0) {
                this.player.m_216990_(SoundEvents.f_12018_);
            } else {
                this.player.m_216990_(SoundEvents.f_11871_);
            }
            this.breakFossils();
        }
        int fossilsAvailable = 3;
        if (this.bone1Damage >= 2) {
            --fossilsAvailable;
        }
        if (this.bone2Damage >= 2) {
            --fossilsAvailable;
        }
        if (this.bone3Damage >= 2) {
            --fossilsAvailable;
        }
        if (this.successLevel >= fossilsAvailable) {
            this.f_96541_.f_91074_.m_6915_();
            if (fossilsAvailable == 3) {
                this.player.m_216990_(SoundEvents.f_12275_);
            } else {
                this.player.m_216990_(SoundEvents.f_11871_);
            }
            this.breakFossils();
        }
        if (this.f_96541_.f_91074_.m_6084_() && !this.f_96541_.f_91074_.m_213877_()) {
            this.containerTick();
        } else {
            this.f_96541_.f_91074_.m_6915_();
        }
    }

    protected void containerTick() {
        int targetPickY;
        int targetPickX;
        int targetHammerY;
        int targetHammerX;
        int targetChiselY;
        int targetChiselX;
        if (this.shakeProgress > 0) {
            --this.shakeProgress;
            this.shakeAmount = -this.shakeAmount * 0.75;
        }
        if (this.fossilProgress1 > 0) {
            --this.fossilProgress1;
        }
        if (this.fossilProgress2 > 0) {
            --this.fossilProgress2;
        }
        if (this.fossilProgress3 > 0) {
            --this.fossilProgress3;
        }
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 7; ++y) {
                if (this.dirtParticleTicks[x][y] > 0) {
                    int[] nArray = this.dirtParticleTicks[x];
                    int n = y;
                    nArray[n] = nArray[n] - 1;
                }
                if (this.stoneParticleTicks[x][y] > 0) {
                    int[] nArray = this.stoneParticleTicks[x];
                    int n = y;
                    nArray[n] = nArray[n] - 1;
                }
                if (this.deepslateParticleTicks[x][y] <= 0) continue;
                int[] nArray = this.deepslateParticleTicks[x];
                int n = y;
                nArray[n] = nArray[n] - 1;
            }
        }
        this.prevChiselPosX = this.chiselPosX;
        this.prevChiselPosY = this.chiselPosY;
        if (this.draggingChisel) {
            targetChiselX = this.lastMouseX - 13;
            targetChiselY = this.lastMouseY + 2;
        } else {
            targetChiselX = (int)this.chiselPosXInit;
            targetChiselY = (int)this.chiselPosYInit;
        }
        Vec3 chiselVec3 = new Vec3((double)((float)targetChiselX - this.chiselPosX), (double)((float)targetChiselY - this.chiselPosY), 0.0);
        this.chiselPosX += (float)chiselVec3.f_82479_;
        this.chiselPosY += (float)chiselVec3.f_82480_;
        this.prevHammerPosX = this.hammerPosX;
        this.prevHammerPosY = this.hammerPosY;
        if (this.draggingHammer) {
            targetHammerX = this.lastMouseX - 7;
            targetHammerY = this.lastMouseY - 3;
        } else {
            targetHammerX = (int)this.hammerPosXInit;
            targetHammerY = (int)this.hammerPosYInit;
        }
        Vec3 hammerVec3 = new Vec3((double)((float)targetHammerX - this.hammerPosX), (double)((float)targetHammerY - this.hammerPosY), 0.0);
        this.hammerPosX += (float)hammerVec3.f_82479_;
        this.hammerPosY += (float)hammerVec3.f_82480_;
        this.prevPickPosX = this.pickPosX;
        this.prevPickPosY = this.pickPosY;
        if (this.draggingPick) {
            targetPickX = this.lastMouseX - 13;
            targetPickY = this.lastMouseY - 9;
        } else {
            targetPickX = (int)this.pickPosXInit;
            targetPickY = (int)this.pickPosYInit;
        }
        Vec3 pickVec3 = new Vec3((double)((float)targetPickX - this.pickPosX), (double)((float)targetPickY - this.pickPosY), 0.0);
        this.pickPosX += (float)pickVec3.f_82479_;
        this.pickPosY += (float)pickVec3.f_82480_;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean prev = super.m_6375_(mouseX, mouseY, button);
        if (!prev) {
            if (button == 1) {
                if (this.draggingPick) {
                    this.draggingPick = false;
                    GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212993);
                }
                if (this.draggingHammer) {
                    this.draggingHammer = false;
                    GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212993);
                }
                if (this.draggingChisel) {
                    this.draggingChisel = false;
                    GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212993);
                }
            } else {
                int y;
                int x;
                if ((float)this.lastMouseX >= this.chiselPosXInit && (float)this.lastMouseX <= this.chiselPosXInit + 16.0f && (float)this.lastMouseY >= this.chiselPosYInit && (float)this.lastMouseY <= this.chiselPosYInit + 16.0f) {
                    boolean bl = this.draggingChisel = !this.draggingChisel;
                    if (this.draggingChisel) {
                        GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212995);
                    } else {
                        GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212993);
                    }
                    if (this.draggingHammer) {
                        this.draggingHammer = false;
                    }
                    if (this.draggingPick) {
                        this.draggingPick = false;
                    }
                }
                if ((float)this.lastMouseX >= this.hammerPosXInit && (float)this.lastMouseX <= this.hammerPosXInit + 16.0f && (float)this.lastMouseY >= this.hammerPosYInit && (float)this.lastMouseY <= this.hammerPosYInit + 16.0f) {
                    boolean bl = this.draggingHammer = !this.draggingHammer;
                    if (this.draggingHammer) {
                        GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212995);
                    } else {
                        GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212993);
                    }
                    if (this.draggingPick) {
                        this.draggingPick = false;
                    }
                    if (this.draggingChisel) {
                        this.draggingChisel = false;
                    }
                }
                if ((float)this.lastMouseX >= this.pickPosXInit && (float)this.lastMouseX <= this.pickPosXInit + 16.0f && (float)this.lastMouseY >= this.pickPosYInit && (float)this.lastMouseY <= this.pickPosYInit + 16.0f) {
                    boolean bl = this.draggingPick = !this.draggingPick;
                    if (this.draggingPick) {
                        GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212995);
                    } else {
                        GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212993);
                    }
                    if (this.draggingChisel) {
                        this.draggingChisel = false;
                    }
                    if (this.draggingHammer) {
                        this.draggingHammer = false;
                    }
                }
                if (this.draggingChisel && mouseX > (double)(this.leftPos + 33) && mouseX < (double)(this.leftPos + 144) && mouseY > (double)(this.topPos + 32) && mouseY < (double)(this.topPos + 140)) {
                    if (this.tileSoilLevel[this.getUnevenSlotX((int)mouseX)][this.getUnevenSlotY((int)mouseY)] > 0) {
                        switch (this.tileSoilLevel[this.getUnevenSlotX((int)mouseX)][this.getUnevenSlotY((int)mouseY)]) {
                            case 1: {
                                this.player.m_216990_(SoundEvents.f_11993_);
                                break;
                            }
                            case 2: {
                                this.player.m_216990_(SoundEvents.f_12442_);
                                break;
                            }
                            default: {
                                this.player.m_216990_(SoundEvents.f_144108_);
                            }
                        }
                        this.makeBlockParticles(this.getUnevenSlotX((int)mouseX), this.getUnevenSlotY((int)mouseY), this.tileSoilLevel[this.getUnevenSlotX((int)mouseX)][this.getUnevenSlotY((int)mouseY)]);
                        int[] nArray = this.tileSoilLevel[this.getUnevenSlotX((int)mouseX)];
                        int n = this.getUnevenSlotY((int)mouseY);
                        nArray[n] = nArray[n] - 1;
                        ++this.currentHits;
                    } else if (this.tileHasFossil[this.getUnevenSlotX((int)mouseX)][this.getUnevenSlotY((int)mouseY)] > 0) {
                        switch (this.tileHasFossil[this.getUnevenSlotX((int)mouseX)][this.getUnevenSlotY((int)mouseY)]) {
                            case 1: {
                                if (!this.bone1Undiscovered || this.bone1Damage >= 2) break;
                                ++this.bone1Damage;
                                this.makeBlockParticles(this.getUnevenSlotX((int)mouseX), this.getUnevenSlotY((int)mouseY), 0);
                                this.damageFossil();
                                break;
                            }
                            case 2: {
                                if (!this.bone2Undiscovered || this.bone2Damage >= 2) break;
                                ++this.bone2Damage;
                                this.makeBlockParticles(this.getUnevenSlotX((int)mouseX), this.getUnevenSlotY((int)mouseY), 0);
                                this.damageFossil();
                                break;
                            }
                            default: {
                                if (!this.bone3Undiscovered || this.bone3Damage >= 2) break;
                                ++this.bone3Damage;
                                this.makeBlockParticles(this.getUnevenSlotX((int)mouseX), this.getUnevenSlotY((int)mouseY), 0);
                                this.damageFossil();
                            }
                        }
                    }
                }
                this.hasAppliedDamage = false;
                int hits = 0;
                if (this.draggingPick && mouseX > (double)(this.leftPos + 33 + 16) && mouseX < (double)(this.leftPos + 144 - 16) && mouseY > (double)(this.topPos + 32 + 16) && mouseY < (double)(this.topPos + 140 - 16)) {
                    for (x = -1; x < 2; ++x) {
                        for (y = -1; y < 2; ++y) {
                            if (x == y && x == 0) {
                                this.hasAppliedDamage = false;
                            }
                            if (!(x == 0 && y == 0 || x != 0 && y == 0) && (x != 0 || y == 0)) continue;
                            if (this.tileSoilLevel[this.getUnevenSlotX((int)mouseX) + x][this.getUnevenSlotY((int)mouseY) + y] > 0) {
                                switch (this.tileSoilLevel[this.getUnevenSlotX((int)mouseX) + x][this.getUnevenSlotY((int)mouseY) + y]) {
                                    case 1: {
                                        this.player.m_216990_(SoundEvents.f_11993_);
                                        break;
                                    }
                                    case 2: {
                                        this.player.m_216990_(SoundEvents.f_12442_);
                                        break;
                                    }
                                    default: {
                                        this.player.m_216990_(SoundEvents.f_144108_);
                                    }
                                }
                                this.makeBlockParticles(this.getUnevenSlotX((int)mouseX) + x, this.getUnevenSlotY((int)mouseY) + y, this.tileSoilLevel[this.getUnevenSlotX((int)mouseX) + x][this.getUnevenSlotY((int)mouseY) + y]);
                                int[] nArray = this.tileSoilLevel[this.getUnevenSlotX((int)mouseX) + x];
                                int n = this.getUnevenSlotY((int)mouseY) + y;
                                nArray[n] = nArray[n] - 1;
                                hits = 1;
                                continue;
                            }
                            if (this.tileHasFossil[this.getUnevenSlotX((int)mouseX) + x][this.getUnevenSlotY((int)mouseY) + y] <= 0 || this.hasAppliedDamage) continue;
                            switch (this.tileHasFossil[this.getUnevenSlotX((int)mouseX) + x][this.getUnevenSlotY((int)mouseY) + y]) {
                                case 1: {
                                    if (!this.bone1Undiscovered || this.bone1Damage >= 2) break;
                                    ++this.bone1Damage;
                                    this.makeBlockParticles(this.getUnevenSlotX((int)mouseX), this.getUnevenSlotY((int)mouseY), 0);
                                    this.damageFossil();
                                    break;
                                }
                                case 2: {
                                    if (!this.bone2Undiscovered || this.bone2Damage >= 2) break;
                                    ++this.bone2Damage;
                                    this.makeBlockParticles(this.getUnevenSlotX((int)mouseX), this.getUnevenSlotY((int)mouseY), 0);
                                    this.damageFossil();
                                    break;
                                }
                                default: {
                                    if (!this.bone3Undiscovered || this.bone3Damage >= 2) break;
                                    ++this.bone3Damage;
                                    this.makeBlockParticles(this.getUnevenSlotX((int)mouseX), this.getUnevenSlotY((int)mouseY), 0);
                                    this.damageFossil();
                                }
                            }
                            this.hasAppliedDamage = true;
                        }
                    }
                    this.currentHits += hits;
                }
                if (this.draggingHammer && mouseX > (double)(this.leftPos + 33 + 8) && mouseX < (double)(this.leftPos + 144 - 8) && mouseY > (double)(this.topPos + 32 + 8) && mouseY < (double)(this.topPos + 140 - 8)) {
                    for (x = 0; x < 2; ++x) {
                        for (y = 0; y < 2; ++y) {
                            if (this.tileSoilLevel[this.getEvenSlotX((int)mouseX) + x - 1][this.getEvenSlotY((int)mouseY) + y - 1] > 0) {
                                switch (this.tileSoilLevel[this.getEvenSlotX((int)mouseX) + x - 1][this.getEvenSlotY((int)mouseY) + y - 1]) {
                                    case 1: {
                                        this.player.m_216990_(SoundEvents.f_11993_);
                                        break;
                                    }
                                    case 2: {
                                        this.player.m_216990_(SoundEvents.f_12442_);
                                        break;
                                    }
                                    default: {
                                        this.player.m_216990_(SoundEvents.f_144108_);
                                    }
                                }
                                this.makeBlockParticles(this.getEvenSlotX((int)mouseX) + x - 1, this.getEvenSlotY((int)mouseY) + y - 1, this.tileSoilLevel[this.getEvenSlotX((int)mouseX) + x - 1][this.getEvenSlotY((int)mouseY) + y - 1]);
                                int[] nArray = this.tileSoilLevel[this.getEvenSlotX((int)mouseX) + x - 1];
                                int n = this.getEvenSlotY((int)mouseY) + y - 1;
                                nArray[n] = nArray[n] - 1;
                                hits = 1;
                                continue;
                            }
                            if (this.tileHasFossil[this.getEvenSlotX((int)mouseX) + x - 1][this.getEvenSlotY((int)mouseY) + y - 1] <= 0 || this.hasAppliedDamage) continue;
                            switch (this.tileHasFossil[this.getEvenSlotX((int)mouseX) + x - 1][this.getEvenSlotY((int)mouseY) + y - 1]) {
                                case 1: {
                                    if (!this.bone1Undiscovered || this.bone1Damage >= 2) break;
                                    ++this.bone1Damage;
                                    this.makeBlockParticles(this.getEvenSlotX((int)mouseX), this.getEvenSlotY((int)mouseY), 0);
                                    this.damageFossil();
                                    break;
                                }
                                case 2: {
                                    if (!this.bone2Undiscovered || this.bone2Damage >= 2) break;
                                    ++this.bone2Damage;
                                    this.makeBlockParticles(this.getEvenSlotX((int)mouseX), this.getEvenSlotY((int)mouseY), 0);
                                    this.damageFossil();
                                    break;
                                }
                                default: {
                                    if (!this.bone3Undiscovered || this.bone3Damage >= 2) break;
                                    ++this.bone3Damage;
                                    this.makeBlockParticles(this.getEvenSlotX((int)mouseX), this.getEvenSlotY((int)mouseY), 0);
                                    this.damageFossil();
                                }
                            }
                            this.hasAppliedDamage = true;
                        }
                    }
                    this.currentHits += hits;
                }
                if (!this.draggingChisel && !this.draggingHammer && !this.draggingPick && mouseX > (double)(this.leftPos + 33) && mouseX < (double)(this.leftPos + 144) && mouseY > (double)(this.topPos + 32) && mouseY < (double)(this.topPos + 140)) {
                    boolean isCovered = false;
                    if (this.tileHasFossil[this.getUnevenSlotX((int)mouseX)][this.getUnevenSlotY((int)mouseY)] > 0 && this.tileSoilLevel[this.getUnevenSlotX((int)mouseX)][this.getUnevenSlotY((int)mouseY)] <= 0) {
                        switch (this.tileHasFossil[this.getUnevenSlotX((int)mouseX)][this.getUnevenSlotY((int)mouseY)]) {
                            case 1: {
                                int x2;
                                block32: for (x2 = this.bone1TileX; x2 < this.bone1TileX + 2; ++x2) {
                                    for (int y2 = this.bone1TileY; y2 < this.bone1TileY + 2; ++y2) {
                                        if (this.tileSoilLevel[x2][y2] <= 0) continue;
                                        isCovered = true;
                                        continue block32;
                                    }
                                }
                                if (isCovered || !this.bone1Undiscovered || this.bone1Damage >= 2) break;
                                this.bone1Undiscovered = false;
                                this.fossilProgress1 = 10;
                                ++this.successLevel;
                                this.player.m_216990_(SoundEvents.f_12019_);
                                this.lastClicked1X = mouseX;
                                this.lastClicked1Y = mouseY;
                                this.makeSparks(mouseX, mouseY);
                                break;
                            }
                            case 2: {
                                for (y = this.bone2TileY; y < this.bone2TileY + 2; ++y) {
                                    if (this.tileSoilLevel[this.bone2TileX][y] <= 0) continue;
                                    isCovered = true;
                                    break;
                                }
                                if (isCovered || !this.bone2Undiscovered || this.bone2Damage >= 2) break;
                                this.bone2Undiscovered = false;
                                this.fossilProgress2 = 10;
                                ++this.successLevel;
                                this.player.m_216990_(SoundEvents.f_12019_);
                                this.lastClicked2X = mouseX;
                                this.lastClicked2Y = mouseY;
                                this.makeSparks(mouseX, mouseY);
                                break;
                            }
                            default: {
                                int x2;
                                block35: for (x2 = this.bone3TileX; x2 < this.bone3TileX + 3; ++x2) {
                                    for (int y3 = this.bone3TileY; y3 < this.bone3TileY + 2; ++y3) {
                                        if (this.tileSoilLevel[x2][y3] <= 0) continue;
                                        isCovered = true;
                                        continue block35;
                                    }
                                }
                                if (isCovered || !this.bone3Undiscovered || this.bone3Damage >= 2) break;
                                this.bone3Undiscovered = false;
                                this.fossilProgress3 = 10;
                                ++this.successLevel;
                                this.player.m_216990_(SoundEvents.f_12019_);
                                this.lastClicked3X = mouseX;
                                this.lastClicked3Y = mouseY;
                                this.makeSparks(mouseX, mouseY);
                            }
                        }
                    }
                }
            }
        }
        return prev;
    }

    private void damageFossil() {
        this.player.m_5496_((SoundEvent)MMSounds.PALEO_TOOLKIT_FOSSIL_BREAK.get(), 1.0f, (this.player.m_217043_().m_188501_() - this.player.m_217043_().m_188501_()) * 0.2f + 1.0f);
        this.shakeAmount = 10.0;
        this.shakeProgress = 20;
        this.shakeX = this.player.m_217043_().m_188499_() ? 1 : -1;
        this.shakeY = this.player.m_217043_().m_188499_() ? 1 : -1;
    }

    public void makeBlockParticles(int tilex, int tiley, int soilLevel) {
        int tileCenterX = this.leftPos + tilex * 16 + 32 + 12;
        int tileCenterY = this.topPos + tiley * 16 + 32 + 8;
        for (int i = 0; i < 10; ++i) {
            Vec2 randp = Mathf.randVec2().m_165903_(6.0f);
            int life = this.player.m_217043_().m_216339_(5, 30);
            this.particles.add((GUIParticle)new DistortableGUIParticle((int)6, (int)life, (float)((float)tileCenterX + randp.f_82470_), (float)((float)tileCenterY + randp.f_82471_), (float)((float)(4 + this.player.m_217043_().m_216339_((int)-1, (int)2))), (float)(randp.f_82470_ / 25.0f), (float)1.0f, (float)(208.0f + Mathf.randInt((int)12) + (float)(16 * (soilLevel - 1))), (float)(224.0f + Mathf.randInt((int)12) - 16.0f), (float)256.0f, (float)256.0f, (Funcf2)DistortableGUIParticle.distortTowardsPoint((float)88.0f, (float)50.0f, (float)1.0f, (float)60.0f))).setLayer((int)0, (boolean)false).setLayer((int)1, (boolean)true).renderAffectors = new GUIParticle.RenderAffectors[]{GUIParticle.RenderAffectors.FADE_IN, GUIParticle.RenderAffectors.ADD_BLEND};
        }
    }

    public void makeSparks(double mouseX, double mouseY) {
        for (int i = 0; i < 10; ++i) {
            Vec2 randp = Mathf.randVec2().m_165903_(2.0f);
            int life = this.player.m_217043_().m_216339_(5, 20);
            this.particles.add((GUIParticle)new DistortableGUIParticle((int)0, (int)life, (float)((float)(mouseX + (double)randp.f_82470_)), (float)((float)(mouseY + (double)randp.f_82471_)), (float)7.0f, (float)randp.f_82470_, (float)randp.f_82471_, (float)(0.0f + Mathf.randInt((int)5) * 7.0f), (float)240.0f, (float)256.0f, (float)256.0f, (Funcf2)DistortableGUIParticle.distortTowardsPoint((float)88.0f, (float)50.0f, (float)1.0f, (float)60.0f))).setLayer((int)0, (boolean)false).setLayer((int)1, (boolean)true).renderAffectors = new GUIParticle.RenderAffectors[]{GUIParticle.RenderAffectors.FADE_IN, GUIParticle.RenderAffectors.ADD_BLEND};
        }
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.currentHits > 0) {
            this.breakFossils();
        }
        this.player.m_216990_((SoundEvent)MMSounds.PALEO_TOOLKIT_CLOSE.get());
    }

    public void breakFossils() {
        MMMessages.CHANNEL.sendToServer((Object)new ChangeFossilMessage(this.successLevel, this.clickedPos));
    }

    public void drawTexturedQuad(Matrix4f matrices, float[][] pos, float u0, float u1, float v0, float v1) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrices, pos[0][0], pos[0][1], 0.0f).m_7421_(u0, v1).m_5752_();
        bufferBuilder.m_252986_(matrices, pos[1][0], pos[1][1], 0.0f).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_252986_(matrices, pos[2][0], pos[2][1], 0.0f).m_7421_(u1, v0).m_5752_();
        bufferBuilder.m_252986_(matrices, pos[3][0], pos[3][1], 0.0f).m_7421_(u0, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }
}

