/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.screen.guiparticle;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.util.Mth;
import net.voidarkana.marvelous_menagerie.client.screen.fossil.FossilMinigameScreen;
import net.voidarkana.marvelous_menagerie.client.screen.guiparticle.GUIParticle;
import net.voidarkana.marvelous_menagerie.util.lambda.Funcf2;

public class DistortableGUIParticle
extends GUIParticle {
    float[][] relativePos = new float[4][2];
    float[][] distortPos = new float[4][2];
    Funcf2 distort;
    float u0;
    float u1;
    float v0;
    float v1;
    int maxLife;
    boolean hasMaxLife = false;

    public DistortableGUIParticle(float x, float y, float size, float vx, float vy, float u, float v, float texW, float texH, Funcf2 distort) {
        super(x, y);
        this.u0 = u / texW;
        this.u1 = (u + size) / texW;
        this.v0 = v / texH;
        this.v1 = (v + size) / texH;
        float s2 = size * 0.5f;
        this.relativePos = new float[][]{{-s2, s2}, {s2, s2}, {s2, -s2}, {-s2, -s2}};
        this.distort = distort;
        this.vx = vx;
        this.vy = vy;
        this.prevVY = vy;
    }

    public DistortableGUIParticle(int lifetime, float x, float y, float size, float vx, float vy, float u, float v, float texW, float texH, Funcf2 distort) {
        this(x, y, size, vx, vy, u, v, texW, texH, distort);
        this.maxLife = lifetime;
        this.hasMaxLife = true;
    }

    public DistortableGUIParticle(int pTurnPoint, int lifetime, float x, float y, float size, float vx, float vy, float u, float v, float texW, float texH, Funcf2 distort) {
        this(lifetime, x, y, size, vx, vy, u, v, texW, texH, distort);
        this.turnPoint = pTurnPoint;
        this.canTurn = true;
    }

    @Override
    public void update() {
        super.update();
        if (this.hasMaxLife && this.life > (float)this.maxLife) {
            this.life = -99.0f;
        }
    }

    @Override
    public void draw(PoseStack matrices, FossilMinigameScreen at) {
        this.distort.get(this.relativePos[0][0] + this.x, this.relativePos[0][1] + this.y, this.distortPos[0]);
        this.distort.get(this.relativePos[1][0] + this.x, this.relativePos[1][1] + this.y, this.distortPos[1]);
        this.distort.get(this.relativePos[2][0] + this.x, this.relativePos[2][1] + this.y, this.distortPos[2]);
        this.distort.get(this.relativePos[3][0] + this.x, this.relativePos[3][1] + this.y, this.distortPos[3]);
        at.drawTexturedQuad(matrices.m_85850_().m_252922_(), this.distortPos, this.u0, this.u1, this.v0, this.v1);
    }

    public static Funcf2 distortTowardsPoint(float centerX, float centerY, float innerrad, float shiftam) {
        return (px, py, out) -> {
            float dx = centerX - px;
            float dy = centerY - py;
            float d = Mth.m_14116_((float)(dx * dx + dy * dy));
            float shift = shiftam / (1.0f + d * 0.1f);
            if (d < innerrad) {
                shift = d - innerrad;
            }
            if (shift > d) {
                shift = d;
            }
            float d1 = 1.0f / d;
            out[0] = px + dx * d1 * shift;
            out[1] = py + dy * d1 * shift;
        };
    }
}

