/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.client.screen.guiparticle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.screens.Screen;
import net.voidarkana.marvelous_menagerie.client.screen.fossil.FossilMinigameScreen;
import net.voidarkana.marvelous_menagerie.util.lambda.Cons;

public abstract class GUIParticle {
    public float x;
    public float y;
    public float vx;
    public float vy;
    public float life = 0.0f;
    public int turnPoint;
    public boolean canTurn = false;
    public RenderAffectors[] renderAffectors = new RenderAffectors[0];
    public boolean cantDie = false;
    public long layer = 1L;
    public float prevVY;

    public GUIParticle(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void update() {
        if (this.canTurn && this.life < (float)this.turnPoint) {
            this.y -= this.prevVY;
            this.prevVY /= 1.1f;
        } else {
            if (this.turnPoint > 0) {
                this.prevVY *= 1.1f;
            }
            this.y += this.prevVY;
        }
        this.x += this.vx;
        this.life += 1.0f;
    }

    public abstract void draw(PoseStack var1, FossilMinigameScreen var2);

    public void forceKill() {
        this.life = -99.0f;
        this.cantDie = false;
    }

    public GUIParticle setLayer(int layer, boolean enabled) {
        this.layer = this.layer - (this.layer & 1L << layer) | (enabled ? 1L : 0L) << layer;
        return this;
    }

    public GUIParticle setRenderAffectors(RenderAffectors ... renderAffectors) {
        this.renderAffectors = renderAffectors;
        return this;
    }

    public static class RenderAffectors {
        Cons.Cons3<PoseStack, Screen, GUIParticle> effect = (a, b, c) -> {};
        public static RenderAffectors FADE_IN = new RenderAffectors((a, b, p) -> {
            float[] c = RenderSystem.getShaderColor();
            RenderSystem.setShaderColor((float)c[0], (float)c[1], (float)c[2], (float)Math.min(1.0f, p.life * 0.1f));
        });
        public static RenderAffectors ADD_BLEND = new RenderAffectors((a, b, p) -> RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE));
        public static RenderAffectors NORM_BLEND = new RenderAffectors((a, b, p) -> RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA));

        public RenderAffectors(Cons.Cons3<PoseStack, Screen, GUIParticle> effect) {
            this.effect = effect;
        }
    }
}

