/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.block.custom;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class FossilBlock
extends Block {
    private String lootTable;
    private ItemStack item = ItemStack.f_41583_;
    private Level level;

    public FossilBlock(BlockBehaviour.Properties pProperties, String pLootTable) {
        super(pProperties);
        this.lootTable = pLootTable;
    }

    public FossilBlock(BlockBehaviour.Properties pProperties) {
        this(pProperties, "");
    }

    public String getFossilLootTable() {
        return this.lootTable;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public ResourceLocation getFossilLoottable(int successLevel, String lootTable) {
        String path = "fossil/success_" + successLevel + "/" + lootTable;
        return new ResourceLocation("marvelous_menagerie", path);
    }

    public void unpackLootTable(BlockPos pPos, int successLevel) {
        if (this.level != null && !this.level.m_5776_() && this.level.m_7654_() != null) {
            LootParams lootparams;
            FossilBlock fossilBlock = this;
            ResourceLocation lootTable = this.getFossilLoottable(successLevel, fossilBlock.getFossilLootTable());
            LootTable loottable = this.level.m_7654_().m_278653_().m_278676_(lootTable);
            ObjectArrayList objectarraylist = loottable.m_287195_(lootparams = new LootParams.Builder((ServerLevel)this.level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pPos)).m_287235_(LootContextParamSets.f_81411_));
            ItemStack itemstack = objectarraylist.isEmpty() ? ItemStack.f_41583_ : (ItemStack)objectarraylist.get(0);
            this.item = itemstack;
        }
    }

    private void dropContent(Level pLevel, BlockPos pPos, int successLevel) {
        this.level = pLevel;
        if (!this.level.f_46443_) {
            ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.level), (Vec3)Vec3.m_82512_((Vec3i)pPos), (int)successLevel);
            if (this.level != null && this.level.m_7654_() != null) {
                this.unpackLootTable(pPos, successLevel);
                if (!this.item.m_41619_()) {
                    double d3 = Vec3.m_82512_((Vec3i)pPos).f_82479_;
                    double d4 = (double)pPos.m_123342_() + (double)(EntityType.f_20461_.m_20679_() / 2.0f);
                    double d5 = Vec3.m_82512_((Vec3i)pPos).f_82481_;
                    ItemEntity itementity = new ItemEntity(this.level, d3, d4, d5, this.item.m_41620_(this.level.f_46441_.m_188503_(21) + 10));
                    itementity.m_20256_(Vec3.f_82478_);
                    this.level.m_7967_((Entity)itementity);
                    this.item = ItemStack.f_41583_;
                }
                this.level.m_46961_(pPos, false);
            }
        }
    }

    public void destroyOriginalWithSuccessLevel(Level pLevel, int successLevel, BlockPos pPos) {
        this.level = pLevel;
        if (!this.level.f_46443_) {
            this.dropContent(pLevel, pPos, successLevel);
            for (Direction direction : Direction.values()) {
                BlockPos offsetPos = pPos.m_121945_(direction);
                BlockState state = this.level.m_8055_(offsetPos);
                Block block = state.m_60734_();
                if (!(block instanceof FossilBlock)) continue;
                FossilBlock fossilBlock = (FossilBlock)block;
                this.level.m_186460_(offsetPos, state.m_60734_(), 4 + this.level.m_213780_().m_188503_(4));
                if (offsetPos == pPos) continue;
                fossilBlock.passOnWithSuccessLevel(successLevel, offsetPos, 0, this.level);
            }
        }
    }

    public void passOnWithSuccessLevel(int successLevel, BlockPos pPos, int chance, Level pLevel) {
        if (!pLevel.f_46443_) {
            this.level = pLevel;
            this.dropContent(pLevel, pPos, successLevel);
            for (Direction direction : Direction.values()) {
                BlockPos offsetPos = pPos.m_121945_(direction);
                BlockState state = this.level.m_8055_(offsetPos);
                Block block = state.m_60734_();
                if (!(block instanceof FossilBlock)) continue;
                FossilBlock fossilBlock = (FossilBlock)block;
                this.level.m_186460_(offsetPos, state.m_60734_(), 4 + this.level.m_213780_().m_188503_(4));
                if (offsetPos == pPos || this.level.f_46441_.m_188503_(3) <= chance) continue;
                fossilBlock.passOnWithSuccessLevel(successLevel, offsetPos, chance, pLevel);
            }
        }
    }
}

