/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.voidarkana.marvelous_menagerie.common.entity.base.MarvelousAnimal;

public class SingleEggBlock
extends Block {
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private Supplier<? extends EntityType> creature;
    private TagKey<Block> validBlock;

    public SingleEggBlock(BlockBehaviour.Properties pProperties, Supplier<? extends EntityType> entityType, TagKey<Block> nestBlock) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0)));
        this.creature = entityType;
        this.validBlock = nestBlock;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HATCH});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.SHAPE;
    }

    public int getHatchLevel(BlockState state) {
        return (Integer)state.m_61143_((Property)HATCH);
    }

    private boolean isReadyToHatch(BlockState state) {
        return this.getHatchLevel(state) == 2;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.shouldUpdateHatchLevel((Level)level, pos.m_7495_()) && state.m_60713_((Block)this)) {
            int i = (Integer)state.m_61143_((Property)HATCH);
            if (i < 2) {
                level.m_5594_(null, pos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchLevel(state) + 1)), 2);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
            } else {
                level.m_5594_(null, pos, SoundEvents.f_276489_, SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                level.m_7471_(pos, false);
                level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                MarvelousAnimal baby = (MarvelousAnimal)this.creature.get().m_20615_((Level)level);
                if (baby != null) {
                    baby.m_146762_(-24000);
                    Vec3 vec3 = pos.m_252807_();
                    baby.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), MobSpawnType.BREEDING, null, null);
                    baby.m_7678_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), Mth.m_14177_((float)(level.f_46441_.m_188501_() * 360.0f)), 0.0f);
                    level.m_7967_((Entity)baby);
                }
            }
        }
    }

    private boolean shouldUpdateHatchLevel(Level level, BlockPos ground) {
        return level.f_46441_.m_188503_(500) == 0 && level.m_8055_(ground).m_204336_(this.validBlock);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        boolean flag = this.hatchBoost((BlockGetter)level, pos);
        if (!level.m_5776_() && flag) {
            level.m_46796_(3009, pos, 0);
        }
        level.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223722_((BlockState)state));
    }

    public boolean hatchBoost(BlockGetter level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_204336_(this.validBlock);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

