/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.block.custom.plant;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.SegmentedAnglePrecision;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.voidarkana.marvelous_menagerie.common.blockentity.custom.CharniaBlockEntity;
import org.jetbrains.annotations.Nullable;

public class CharniaBlock
extends BaseEntityBlock
implements IPlantable,
LiquidBlockContainer {
    private static final SegmentedAnglePrecision SEGMENTED_ANGLE8 = new SegmentedAnglePrecision(3);
    public static final IntegerProperty PICKLES = BlockStateProperties.f_61425_;
    public static final int MAX;
    private static final int ROTATIONS;
    public static final IntegerProperty ROTATION_8;
    protected static final VoxelShape INDIVIDUAL;
    protected static final VoxelShape MULTIPLE;

    public CharniaBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PICKLES, (Comparable)Integer.valueOf(1))).m_61124_((Property)ROTATION_8, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Integer)pState.m_61143_((Property)PICKLES)) {
            default -> INDIVIDUAL;
            case 2, 3, 4 -> MULTIPLE;
        };
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CharniaBlockEntity(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)ROTATION_8, (Comparable)Integer.valueOf(pRotation.m_55949_(((Integer)pState.m_61143_((Property)ROTATION_8)).intValue(), ROTATIONS)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.m_61124_((Property)ROTATION_8, (Comparable)Integer.valueOf(pMirror.m_54843_(((Integer)pState.m_61143_((Property)ROTATION_8)).intValue(), ROTATIONS)));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (!pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockState blockstate = super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        if (!blockstate.m_60795_()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return blockstate;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        return this.mayPlaceOn(pLevel.m_8055_(blockpos), (BlockGetter)pLevel, blockpos);
    }

    protected boolean mayPlaceOn(BlockState p_154539_, BlockGetter p_154540_, BlockPos p_154541_) {
        return p_154539_.m_60783_(p_154540_, p_154541_, Direction.UP) && !p_154539_.m_60713_(Blocks.f_50450_);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)blockstate.m_61124_((Property)PICKLES, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.m_61143_((Property)PICKLES) + 1)));
        }
        return fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8 ? (BlockState)this.m_49966_().m_61124_((Property)ROTATION_8, (Comparable)Integer.valueOf(CharniaBlock.convertToSegment(pContext.m_7074_()))) : null;
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        return !pUseContext.m_7078_() && pUseContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)pState.m_61143_((Property)PICKLES) < 4 ? true : super.m_6864_(pState, pUseContext);
    }

    public static int convertToSegment(float pAngle) {
        return SEGMENTED_ANGLE8.m_264419_(pAngle);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{PICKLES, ROTATION_8});
    }

    public FluidState m_5888_(BlockState p_154537_) {
        return Fluids.f_76193_.m_76068_(false);
    }

    public boolean m_6044_(BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        return false;
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        return false;
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }

    static {
        ROTATIONS = MAX = SEGMENTED_ANGLE8.m_264451_();
        ROTATION_8 = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)MAX);
        INDIVIDUAL = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        MULTIPLE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    }
}

