/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.block.custom.plant;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.voidarkana.marvelous_menagerie.common.block.MMBlocks;

public class PrototaxitesBlock
extends Block
implements IPlantable,
BonemealableBlock {
    public static final BooleanProperty CAN_GROW = BooleanProperty.m_61465_((String)"can_grow");
    public static final IntegerProperty PROTO_THICKNESS = IntegerProperty.m_61631_((String)"proto_thickness", (int)0, (int)4);
    public static final IntegerProperty PROTO_AGE = IntegerProperty.m_61631_((String)"proto_age", (int)0, (int)15);
    private static final VoxelShape TIP_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private final ResourceKey<ConfiguredFeature<?, ?>> feature;

    public PrototaxitesBlock(BlockBehaviour.Properties pProperties, ResourceKey<ConfiguredFeature<?, ?>> pFeature) {
        super(pProperties);
        this.feature = pFeature;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CAN_GROW, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PROTO_THICKNESS, (Comparable)Integer.valueOf(0))).m_61124_((Property)PROTO_AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{CAN_GROW, PROTO_THICKNESS, PROTO_AGE});
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (!pState.m_60710_((LevelReader)pLevel, pPos)) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
        int protoThickness = this.calculatePrototaxitesThickness((LevelReader)pLevel, pPos);
        return (BlockState)pState.m_61124_((Property)PROTO_THICKNESS, (Comparable)Integer.valueOf(protoThickness));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int protoThickness = (Integer)pState.m_61143_((Property)PROTO_THICKNESS);
        VoxelShape voxelshape = switch (protoThickness) {
            case 1 -> FRUSTUM_SHAPE;
            case 2 -> MIDDLE_SHAPE;
            case 3 -> BASE_SHAPE;
            default -> TIP_SHAPE;
        };
        Vec3 vec3 = pState.m_60824_(pLevel, pPos);
        return voxelshape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    public boolean m_6724_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)CAN_GROW) != false && (Integer)pState.m_61143_((Property)PROTO_THICKNESS) == 0;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.m_7898_(pState, (LevelReader)pLevel, pPos)) {
            pLevel.m_46961_(pPos, true);
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.getHeightBelowUpToMax((BlockGetter)pLevel, pPos) == 3 && ((Boolean)pState.m_61143_((Property)CAN_GROW)).booleanValue() && pLevel.m_46859_(pPos.m_7494_())) {
            pState.m_61124_((Property)CAN_GROW, (Comparable)Boolean.valueOf(false));
        } else if (this.getHeightBelowUpToMax((BlockGetter)pLevel, pPos) < 3 && !((Boolean)pState.m_61143_((Property)CAN_GROW)).booleanValue() && pLevel.m_46859_(pPos.m_7494_())) {
            pState.m_61124_((Property)CAN_GROW, (Comparable)Boolean.valueOf(true));
        }
        if (((Boolean)pState.m_61143_((Property)CAN_GROW)).booleanValue() && pLevel.m_46859_(pPos.m_7494_())) {
            int i = 1;
            while (pLevel.m_8055_(pPos.m_6625_(i)).m_60713_((Block)MMBlocks.PROTOTAXITES.get())) {
                ++i;
            }
            if (i < 4) {
                int j = (Integer)pState.m_61143_((Property)PROTO_AGE);
                if (ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (boolean)true)) {
                    if (j == 15) {
                        boolean k = !(i > 2 && pRandom.m_188501_() < 0.25f || i >= 4);
                        pLevel.m_7731_(pPos.m_7494_(), (BlockState)((Block)MMBlocks.PROTOTAXITES.get()).m_49966_().m_61124_((Property)CAN_GROW, (Comparable)Boolean.valueOf(k)), 3);
                        ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos.m_7494_(), (BlockState)((Block)MMBlocks.PROTOTAXITES.get()).m_49966_());
                        this.m_49966_().m_61124_((Property)PROTO_AGE, (Comparable)Integer.valueOf(0));
                    } else {
                        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)PROTO_AGE, (Comparable)Integer.valueOf(j + 1)), 3);
                    }
                }
            }
        }
    }

    protected int getHeightBelowUpToMax(BlockGetter pLevel, BlockPos pPos) {
        int i;
        for (i = 0; i < 4 && pLevel.m_8055_(pPos.m_6625_(i + 1)).m_60713_((Block)MMBlocks.PROTOTAXITES.get()); ++i) {
        }
        return i;
    }

    private int calculatePrototaxitesThickness(LevelReader pLevel, BlockPos pPos) {
        BlockPos above1 = pPos.m_7494_();
        BlockPos above2 = above1.m_7494_();
        BlockPos above3 = above2.m_7494_();
        if (pLevel.m_8055_(above1).m_60713_((Block)MMBlocks.PROTOTAXITES.get())) {
            if (pLevel.m_8055_(above2).m_60713_((Block)MMBlocks.PROTOTAXITES.get())) {
                if (pLevel.m_8055_(above3).m_60713_((Block)MMBlocks.PROTOTAXITES.get())) {
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        int size = this.getHeightBelowUpToMax((BlockGetter)pLevel, pPos) + 1;
        BlockState soil = pLevel.m_8055_(pPos.m_7495_());
        if (soil.canSustainPlant((BlockGetter)pLevel, pPos.m_7495_(), Direction.UP, (IPlantable)this)) {
            return true;
        }
        BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
        if (blockstate.m_60713_((Block)this) && size <= 4) {
            return true;
        }
        return blockstate.m_204336_(BlockTags.f_144274_);
    }

    public boolean growMushroom(ServerLevel pLevel, BlockPos pPos, BlockState pState, RandomSource pRandom) {
        Optional optional = pLevel.m_9598_().m_175515_(Registries.f_256911_).m_203636_(this.feature);
        if (optional.isEmpty()) {
            return false;
        }
        SaplingGrowTreeEvent event = ForgeEventFactory.blockGrowFeature((LevelAccessor)pLevel, (RandomSource)pRandom, (BlockPos)pPos, (Holder)((Holder)optional.get()));
        if (event.getResult().equals((Object)Event.Result.DENY)) {
            return false;
        }
        pLevel.m_7471_(pPos, false);
        if (((ConfiguredFeature)event.getFeature().m_203334_()).m_224953_((WorldGenLevel)pLevel, pLevel.m_7726_().m_8481_(), pRandom, pPos)) {
            return true;
        }
        pLevel.m_7731_(pPos, pState, 3);
        return false;
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.PLAINS;
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        BlockState soil = pLevel.m_8055_(pPos.m_7495_());
        return !soil.m_60713_((Block)this);
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return (double)pRandom.m_188501_() < 0.4;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        this.growMushroom(pLevel, pPos, pState, pRandom);
    }
}

