/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.blockentity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.voidarkana.marvelous_menagerie.client.particles.MMParticles;
import net.voidarkana.marvelous_menagerie.common.block.MMBlocks;
import net.voidarkana.marvelous_menagerie.common.blockentity.MMBlockEntities;
import net.voidarkana.marvelous_menagerie.common.blockentity.custom.BlockEntityBase;
import net.voidarkana.marvelous_menagerie.common.blockentity.custom.PedestalBlockEntity;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.misc.Fracture;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import net.voidarkana.marvelous_menagerie.data.manager.RitualManager;
import net.voidarkana.marvelous_menagerie.util.MMTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AltarBlockEntity
extends BlockEntityBase {
    private static final TargetingConditions TARGET_FRACTURE = TargetingConditions.m_148353_().m_26883_(6.0);
    public int time;
    public float rot;
    public float oRot;
    public float tRot;
    public boolean hasFracture;
    Item[] ingredients = new Item[4];

    public AltarBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)MMBlockEntities.ALTAR_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.hasFracture = tag.m_128471_("hasFracture");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("hasFracture", this.hasFracture);
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        if (this.getFracture(pos) != null) {
            this.getFracture(pos).closeFracture();
        }
    }

    @Override
    public InteractionResult onActivated(BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (this.canBeActivated(this.f_58857_, pos)) {
            if (!(this.f_58857_ instanceof ServerLevel)) {
                return InteractionResult.SUCCESS;
            }
            if (this.hasFracture && this.getFracture(pos) != null) {
                ItemStack item = player.m_21120_(hand);
                Fracture fracture = this.getFracture(pos);
                if (!fracture.isValid() || !item.m_150930_((Item)MMItems.CHRONO_WATCH.get())) {
                    return InteractionResult.FAIL;
                }
                if (!player.m_7500_()) {
                    item.m_41774_(1);
                }
                EntityType entitytype = (EntityType)MMEntities.CHUD.get();
                for (RitualManager.RitualProcessData data : RitualManager.DATA) {
                    System.out.println(data);
                    boolean[] itemUsed = new boolean[4];
                    boolean[] itemChecked = new boolean[4];
                    int itemCount = 0;
                    Ingredient[] inputs = new Ingredient[]{data.input1(), data.input2(), data.input3(), data.input4()};
                    for (int i = 0; i < 4; ++i) {
                        for (int s = 0; s < 4; ++s) {
                            if (itemUsed[i] || itemChecked[s]) continue;
                            for (ItemStack itemstack : inputs[s].m_43908_()) {
                                if (!itemstack.m_150930_(this.ingredients[i])) continue;
                                itemUsed[i] = true;
                                itemChecked[s] = true;
                                ++itemCount;
                            }
                        }
                    }
                    if (itemCount != 4) continue;
                    entitytype = data.output();
                }
                this.clearPedestals(this.f_58857_, pos);
                if (entitytype == MMEntities.CHUD.get()) {
                    BuiltInRegistries.f_256780_.m_203431_(MMTags.EntityTypes.TIME_ABERRATIONS).flatMap(entityTypeNamed -> entityTypeNamed.m_213653_(this.f_58857_.f_46441_)).ifPresent(entityTypeHolder -> this.getFracture(pos).summonCreature((EntityType)entityTypeHolder.get()));
                } else {
                    this.getFracture(pos).summonCreature(entitytype);
                }
            } else {
                Fracture fracture = new Fracture(this.f_58857_, pos.m_252807_().m_7096_(), pos.m_252807_().m_7098_() + 2.0, pos.m_252807_().m_7094_());
                fracture.setIsNatural(false);
                this.f_58857_.m_7967_((Entity)fracture);
                this.hasFracture = true;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public Fracture getFracture(BlockPos pPos) {
        return (Fracture)this.f_58857_.m_45982_(this.f_58857_.m_45976_(Fracture.class, new AABB(new BlockPos(pPos.m_123341_(), pPos.m_123342_() + 2, pPos.m_123343_())).m_82400_(1.0)), TARGET_FRACTURE, null, pPos.m_252807_().m_7096_(), pPos.m_252807_().m_7098_() + 2.0, pPos.m_252807_().m_7094_());
    }

    boolean canBeActivated(Level pLevel, BlockPos pPos) {
        int radius;
        int formationSize = this.formationSize(pLevel, pPos);
        int height = formationSize > 3 ? 1 : 0;
        int n = radius = formationSize > 3 ? formationSize - 3 : formationSize;
        if (radius > 0) {
            BlockEntity be1 = pLevel.m_7702_(pPos.m_7918_(radius, height, radius));
            BlockEntity be2 = pLevel.m_7702_(pPos.m_7918_(-radius, height, radius));
            BlockEntity be3 = pLevel.m_7702_(pPos.m_7918_(radius, height, -radius));
            BlockEntity be4 = pLevel.m_7702_(pPos.m_7918_(-radius, height, -radius));
            if (be1 instanceof PedestalBlockEntity) {
                PedestalBlockEntity pedestal1 = (PedestalBlockEntity)be1;
                if (be2 instanceof PedestalBlockEntity) {
                    PedestalBlockEntity pedestal2 = (PedestalBlockEntity)be2;
                    if (be3 instanceof PedestalBlockEntity) {
                        PedestalBlockEntity pedestal3 = (PedestalBlockEntity)be3;
                        if (be4 instanceof PedestalBlockEntity) {
                            PedestalBlockEntity pedestal4 = (PedestalBlockEntity)be4;
                            if (!(pedestal1.stack.m_41619_() || pedestal2.stack.m_41619_() || pedestal3.stack.m_41619_() || pedestal4.stack.m_41619_())) {
                                this.ingredients[0] = pedestal1.stack.m_41720_();
                                this.ingredients[1] = pedestal2.stack.m_41720_();
                                this.ingredients[2] = pedestal3.stack.m_41720_();
                                this.ingredients[3] = pedestal4.stack.m_41720_();
                                return true;
                            }
                            return false;
                        }
                    }
                }
            }
        }
        return false;
    }

    public void clearPedestals(Level level, BlockPos pos) {
        int radius;
        int formationSize = this.formationSize(level, pos);
        int height = formationSize > 3 ? 1 : 0;
        int n = radius = formationSize > 3 ? formationSize - 3 : formationSize;
        if (radius > 0) {
            BlockPos pos1 = pos.m_7918_(radius, height, radius);
            BlockPos pos2 = pos.m_7918_(-radius, height, radius);
            BlockPos pos3 = pos.m_7918_(radius, height, -radius);
            BlockPos pos4 = pos.m_7918_(-radius, height, -radius);
            BlockEntity be1 = level.m_7702_(pos1);
            BlockEntity be2 = level.m_7702_(pos2);
            BlockEntity be3 = level.m_7702_(pos3);
            BlockEntity be4 = level.m_7702_(pos4);
            if (be1 instanceof PedestalBlockEntity) {
                PedestalBlockEntity pedestal1 = (PedestalBlockEntity)be1;
                if (be2 instanceof PedestalBlockEntity) {
                    PedestalBlockEntity pedestal2 = (PedestalBlockEntity)be2;
                    if (be3 instanceof PedestalBlockEntity) {
                        PedestalBlockEntity pedestal3 = (PedestalBlockEntity)be3;
                        if (be4 instanceof PedestalBlockEntity) {
                            PedestalBlockEntity pedestal4 = (PedestalBlockEntity)be4;
                            ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, pedestal1.stack), (double)pos1.m_123341_() + 0.5, (double)pos1.m_123342_() + 1.0, (double)pos1.m_123343_() + 0.5, 8, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, (double)0.075f);
                            ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, pedestal2.stack), (double)pos2.m_123341_() + 0.5, (double)pos2.m_123342_() + 1.0, (double)pos2.m_123343_() + 0.5, 8, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, (double)0.075f);
                            ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, pedestal3.stack), (double)pos3.m_123341_() + 0.5, (double)pos3.m_123342_() + 1.0, (double)pos3.m_123343_() + 0.5, 8, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, (double)0.075f);
                            ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, pedestal4.stack), (double)pos4.m_123341_() + 0.5, (double)pos4.m_123342_() + 1.0, (double)pos4.m_123343_() + 0.5, 8, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, (double)0.075f);
                            pedestal1.take();
                            pedestal2.take();
                            pedestal3.take();
                            pedestal4.take();
                        }
                    }
                }
            }
        }
    }

    public int formationSize(Level pLevel, BlockPos pPos) {
        int size = 1;
        if (pLevel.m_8055_(pPos.m_7918_(size, 0, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(size, 0, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 0, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 0, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get())) {
            return size;
        }
        if (pLevel.m_8055_(pPos.m_7918_(size, 1, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(size, 1, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 1, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 1, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get())) {
            return 4;
        }
        if (pLevel.m_8055_(pPos.m_7918_(++size, 0, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(size, 0, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 0, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 0, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get())) {
            return size;
        }
        if (pLevel.m_8055_(pPos.m_7918_(size, 1, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(size, 1, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 1, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 1, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get())) {
            return 5;
        }
        if (pLevel.m_8055_(pPos.m_7918_(++size, 0, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(size, 0, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 0, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 0, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get())) {
            return size;
        }
        if (pLevel.m_8055_(pPos.m_7918_(size, 1, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(size, 1, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 1, size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get()) && pLevel.m_8055_(pPos.m_7918_(-size, 1, -size)).m_60713_((Block)MMBlocks.CHRONO_PEDESTAL.get())) {
            return 6;
        }
        return 0;
    }

    public static void altarTick(Level pLevel, BlockPos pPos, BlockState pState, AltarBlockEntity pBlockEntity) {
        float f2;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof AltarBlockEntity) {
            AltarBlockEntity altar = (AltarBlockEntity)blockEntity;
            int formationSize = altar.formationSize(pLevel, pPos);
            boolean height = formationSize > 3;
            int radius = formationSize > 3 ? formationSize - 3 : formationSize;
            Fracture fracture = altar.getFracture(pPos);
            if (fracture != null && fracture.getSummoningTime() > 70 && fracture.getSummoningTime() <= 80 && pLevel.m_213780_().m_188503_(4) > 0) {
                pLevel.m_7106_((ParticleOptions)MMParticles.ITEM_MORPH.get(), (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 4.5, (double)pPos.m_123343_() + 0.5, (double)radius, (double)((float)height) - 3.5, (double)radius);
                pLevel.m_7106_((ParticleOptions)MMParticles.ITEM_MORPH.get(), (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 4.5, (double)pPos.m_123343_() + 0.5, (double)(-radius), (double)((float)height) - 3.5, (double)radius);
                pLevel.m_7106_((ParticleOptions)MMParticles.ITEM_MORPH.get(), (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 4.5, (double)pPos.m_123343_() + 0.5, (double)radius, (double)((float)height) - 3.5, (double)(-radius));
                pLevel.m_7106_((ParticleOptions)MMParticles.ITEM_MORPH.get(), (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 4.5, (double)pPos.m_123343_() + 0.5, (double)(-radius), (double)((float)height) - 3.5, (double)(-radius));
            }
        }
        pBlockEntity.oRot = pBlockEntity.rot;
        Player player = pLevel.m_45924_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.m_20185_() - ((double)pPos.m_123341_() + 0.5);
            double d1 = player.m_20189_() - ((double)pPos.m_123343_() + 0.5);
            pBlockEntity.tRot = (float)Mth.m_14136_((double)d1, (double)d0);
        } else {
            pBlockEntity.tRot += 0.02f;
        }
        while (pBlockEntity.rot >= (float)Math.PI) {
            pBlockEntity.rot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.rot < (float)(-Math.PI)) {
            pBlockEntity.rot += (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot >= (float)Math.PI) {
            pBlockEntity.tRot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot < (float)(-Math.PI)) {
            pBlockEntity.tRot += (float)Math.PI * 2;
        }
        for (f2 = pBlockEntity.tRot - pBlockEntity.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        pBlockEntity.rot += f2 * 0.4f;
        ++pBlockEntity.time;
    }
}

