/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.blockentity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import net.voidarkana.marvelous_menagerie.common.blockentity.MMBlockEntities;
import net.voidarkana.marvelous_menagerie.common.blockentity.custom.BlockEntityBase;
import net.voidarkana.marvelous_menagerie.data.manager.FossilCleaningManager;
import net.voidarkana.marvelous_menagerie.util.MMTags;
import org.jetbrains.annotations.NotNull;

public class PaleontologyTableBlockEntity
extends BlockEntityBase {
    public ItemStack stack = ItemStack.f_41583_;
    private static final int BRUSH_COOLDOWN_TICKS = 10;
    private static final int BRUSH_RESET_TICKS = 40;
    private static final int REQUIRED_BRUSHES_TO_BREAK = 10;
    private int brushCount;
    private long coolDownEndsAtTick;
    private long brushCountResetsAtTick;

    public PaleontologyTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MMBlockEntities.PALEO_TABLE_ENTITY.get(), pos, state);
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        if (!this.stack.m_41619_()) {
            Containers.m_18992_((Level)this.f_58857_, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)this.stack);
        }
    }

    @Override
    public InteractionResult onActivated(BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ItemStack itemInHand = player.m_21120_(hand);
            boolean flag = itemInHand.m_204117_(MMTags.Items.NATURAL_FOSSILS);
            if (itemInHand.m_41619_() && !this.stack.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.stack);
                this.stack = ItemStack.f_41583_;
                if (!this.f_58857_.f_46443_) {
                    this.sync();
                }
                return InteractionResult.SUCCESS;
            }
            if (!itemInHand.m_41619_() && this.stack.m_41619_() && flag) {
                this.stack = itemInHand.m_41620_(1);
                if (!this.f_58857_.f_46443_) {
                    this.sync();
                }
                return InteractionResult.SUCCESS;
            }
            if (!itemInHand.m_41619_() && !this.stack.m_41619_() && flag) {
                ItemStack oldstack = this.stack.m_41777_();
                this.stack = itemInHand.m_41620_(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)oldstack);
                if (!this.f_58857_.f_46443_) {
                    this.sync();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void checkReset() {
        if (this.f_58857_ != null) {
            if (this.brushCount != 0 && this.f_58857_.m_46467_() >= this.brushCountResetsAtTick) {
                this.brushCount = Math.max(0, this.brushCount - 2);
                this.brushCountResetsAtTick = this.f_58857_.m_46467_() + 4L;
            }
            if (this.brushCount == 0) {
                this.brushCountResetsAtTick = 0L;
                this.coolDownEndsAtTick = 0L;
            } else {
                this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), (int)(this.brushCountResetsAtTick - this.f_58857_.m_46467_()));
            }
        }
    }

    public boolean brush(long pStartTick, Player pPlayer, Direction pHitDirection) {
        if (pHitDirection == Direction.UP) {
            this.brushCountResetsAtTick = pStartTick + 40L;
            if (pStartTick >= this.coolDownEndsAtTick && this.f_58857_ instanceof ServerLevel) {
                this.coolDownEndsAtTick = pStartTick + 10L;
                if (++this.brushCount >= 2) {
                    this.brushingCompleted();
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void brushingCompleted() {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            this.dropContent();
            BlockState blockstate = this.m_58900_();
            this.f_58857_.m_46796_(3008, this.m_58899_(), Block.m_49956_((BlockState)blockstate));
            this.brushCountResetsAtTick = 0L;
            this.coolDownEndsAtTick = 0L;
            this.brushCount = 0;
        }
    }

    private void dropContent() {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            boolean hasRecipe = FossilCleaningManager.containsRecipe(this.stack.m_41720_());
            ItemStack result = ItemStack.f_41583_;
            if (hasRecipe) {
                result = FossilCleaningManager.getRandomItemStack(this.stack.m_41720_(), this.f_58857_);
                this.stack = ItemStack.f_41583_;
                if (!this.f_58857_.f_46443_) {
                    this.sync();
                }
            }
            if (!result.m_41619_()) {
                double d0 = EntityType.f_20461_.m_20678_();
                double d1 = 1.0 - d0;
                double d2 = d0 / 2.0;
                BlockPos blockpos = this.f_58858_.m_5484_(Direction.UP, 1);
                double d3 = (double)blockpos.m_123341_() + 0.5 * d1 + d2;
                double d4 = (double)blockpos.m_123342_() + 0.5 + (double)(EntityType.f_20461_.m_20679_() / 2.0f);
                double d5 = (double)blockpos.m_123343_() + 0.5 * d1 + d2;
                ItemEntity itementity = new ItemEntity(this.f_58857_, d3, d4, d5, result);
                itementity.m_20256_(Vec3.f_82478_);
                this.f_58857_.m_7967_((Entity)itementity);
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.f_58857_), (Vec3)new Vec3(d3, d4, d5), (int)1);
                this.stack = ItemStack.f_41583_;
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack"));
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("stack", (Tag)this.stack.m_41739_(new CompoundTag()));
    }
}

