/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.abomination;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.common.entity.ai.AnimatedAttackGoal;
import net.voidarkana.marvelous_menagerie.common.entity.base.Abomination;
import net.voidarkana.marvelous_menagerie.common.entity.base.IAnimatedAttacker;

public class Beholder
extends Abomination
implements IAnimatedAttacker {
    public Boolean hasJawsOpened = false;
    public Boolean hasJawsClosed = false;
    public Boolean hasReleased = true;
    public boolean isLandNavigator;
    public float prevTilt;
    public float tilt;
    public float currentRoll = 0.0f;
    private static final EntityDataAccessor<Integer> IN_WATER_TICKS = SynchedEntityData.m_135353_(Beholder.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(Beholder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WANTS_TO_GRAB = SynchedEntityData.m_135353_(Beholder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_GRABBING = SynchedEntityData.m_135353_(Beholder.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GRABBING_TICKS = SynchedEntityData.m_135353_(Beholder.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int attackAnimationTimeout;
    int prevTicksInWater;
    public final AnimationState idleTwitchState = new AnimationState();
    int idleTwitchTimeout;
    public final AnimationState idleSignalState = new AnimationState();
    int idleSignalTimeout;
    public final AnimationState idleOverlay = new AnimationState();
    public final AnimationState idleLookAround = new AnimationState();
    int idleLookTimeout;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState openJawsStartState = new AnimationState();
    int openJawsStartTimeout;
    public final AnimationState keepJawsOpenState = new AnimationState();
    public final AnimationState closeJawsState = new AnimationState();
    int closeJawsStartTimeout;
    public final AnimationState keepGrabbingState = new AnimationState();
    public final AnimationState releaseJawsState = new AnimationState();
    int releaseJawsStartTimeout;
    int attackTime = 11;
    int attackAnimLength = 20;

    public Beholder(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(true);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new BeholderAttackGoal(this, 1.25, true, 11, 9));
        this.f_21345_.m_25352_(1, (Goal)new BeholderGrabGoal(this, 1.25, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 32.0f));
        this.f_21345_.m_25352_(7, (Goal)new BeholderStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new BeholderSwimGoal((PathfinderMob)this, 1.0, 7));
        this.f_21345_.m_25352_(8, (Goal)new BeholderLookAtPlayer(this));
        this.f_21345_.m_25352_(8, (Goal)new BeholderRandomLook(this));
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22278_, 0.25).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22284_, 5.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(WANTS_TO_GRAB, (Object)false);
        this.f_19804_.m_135372_(IS_GRABBING, (Object)false);
        this.f_19804_.m_135372_(GRABBING_TICKS, (Object)0);
        this.f_19804_.m_135372_(IN_WATER_TICKS, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsAttacking", this.isAttacking());
        pCompound.m_128379_("WantsToGrab", this.wantsToGrab());
        pCompound.m_128379_("IsGrabbing", this.isGrabbing());
        pCompound.m_128405_("GrabbingTicks", this.getGrabbingTicks());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAttacking(pCompound.m_128471_("IsAttacking"));
        this.setWantsToGrab(pCompound.m_128471_("WantsToGrab"));
        this.setIsGrabbing(pCompound.m_128471_("IsGrabbing"));
        this.setGrabbingTicks(pCompound.m_128451_("GrabbingTicks"));
    }

    @Override
    public int getInWaterTicks() {
        return (Integer)this.f_19804_.m_135370_(IN_WATER_TICKS);
    }

    @Override
    public void setInWaterTicks(int variant) {
        this.f_19804_.m_135381_(IN_WATER_TICKS, (Object)variant);
    }

    @Override
    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    @Override
    public void setAttacking(boolean pFromBucket) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)pFromBucket);
    }

    public boolean wantsToGrab() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_GRAB);
    }

    public void setWantsToGrab(boolean pFromBucket) {
        this.f_19804_.m_135381_(WANTS_TO_GRAB, (Object)pFromBucket);
    }

    public boolean isGrabbing() {
        return (Boolean)this.f_19804_.m_135370_(IS_GRABBING);
    }

    public void setIsGrabbing(boolean pFromBucket) {
        this.f_19804_.m_135381_(IS_GRABBING, (Object)pFromBucket);
    }

    public int getGrabbingTicks() {
        return (Integer)this.f_19804_.m_135370_(GRABBING_TICKS);
    }

    public void setGrabbingTicks(int pFromBucket) {
        this.f_19804_.m_135381_(GRABBING_TICKS, (Object)pFromBucket);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            PathNavigation prevNav = this.f_21344_;
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.f_21365_ = new LookControl((Mob)this);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.2f, 0.1f, true);
            PathNavigation prevNav = this.f_21344_;
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
            this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
            this.isLandNavigator = false;
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (!this.m_20069_() && this.getInWaterTicks() > 0) {
                this.prevTicksInWater = this.getInWaterTicks();
                this.setInWaterTicks(this.prevTicksInWater - 1);
            } else if (this.m_20069_() && this.getInWaterTicks() < 5) {
                this.prevTicksInWater = this.getInWaterTicks();
                this.setInWaterTicks(this.prevTicksInWater + 1);
            }
        }
        this.prevTilt = this.tilt;
        if (this.m_20069_() && !this.m_20096_() && !this.isLandNavigator) {
            float v = Mth.m_14118_((float)this.m_146908_(), (float)this.f_19859_);
            if (Math.abs(v) > 1.0f) {
                if (Math.abs(this.tilt) < 25.0f) {
                    this.tilt -= Math.signum(v);
                }
            } else if (Math.abs(this.tilt) > 0.0f) {
                float tiltSign = Math.signum(this.tilt);
                this.tilt -= tiltSign * 0.85f;
                if (this.tilt * tiltSign < 0.0f) {
                    this.tilt = 0.0f;
                }
            }
        } else {
            this.tilt = 0.0f;
        }
        float prevRoll = this.currentRoll;
        float targetRoll = Math.max(-0.45f, Math.min(0.45f, (this.m_146908_() - this.f_19859_) * 0.1f));
        targetRoll = -targetRoll;
        this.currentRoll = prevRoll + (targetRoll - prevRoll) * 0.05f;
    }

    @Override
    public int attackAnimationTimeout() {
        return this.attackAnimationTimeout;
    }

    @Override
    public void setAttackAnimationTimeout(int attackAnimationTimeout) {
        this.attackAnimationTimeout = attackAnimationTimeout;
    }

    @Override
    public void m_8119_() {
        Entity entity;
        if (this.getGrabbingTicks() > 0) {
            int prevGrabbingTicks = this.getGrabbingTicks();
            this.setGrabbingTicks(prevGrabbingTicks - 1);
        }
        super.m_8119_();
        boolean inWater = this.m_20072_();
        if (inWater && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!inWater && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.isGrabbing() && (entity = this.m_146895_()) != null) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.m_7500_()) {
                    entity.m_20260_(false);
                }
            } else {
                entity.m_20260_(false);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.m_5448_() != null && !this.wantsToGrab() && this.m_217043_().m_188503_(150) == 0 && !this.m_5448_().m_20159_()) {
                this.m_216990_((SoundEvent)MMSounds.BEHOLDER_OPEN.get());
                this.setWantsToGrab(true);
            }
            if (this.canGrabOrGrabbing() && !this.m_5912_() && this.m_20197_().isEmpty()) {
                this.setWantsToGrab(false);
                this.setIsGrabbing(false);
                this.setGrabbingTicks(0);
            }
            if (!this.canContinueGrabbing() && !this.m_20197_().isEmpty()) {
                this.setWantsToGrab(false);
                this.setIsGrabbing(false);
                this.setGrabbingTicks(0);
                this.m_20153_();
            }
        }
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunc) {
        if (!this.m_20197_().isEmpty()) {
            this.f_20883_ = Mth.m_14177_((float)(this.m_146908_() - 180.0f));
        }
        if (this.m_20363_(passenger)) {
            float radius = 0.8f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = 0.8f * Mth.m_14031_((float)((float)Math.PI + angle));
            double extraZ = 0.8f * Mth.m_14089_((float)angle);
            passenger.m_6034_(this.m_20185_() + extraX, this.m_20186_() + (double)0.1f, this.m_20189_() + extraZ);
        }
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
            this.m_267651_(true);
            if (this.f_19862_ && this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public boolean canGrabOrGrabbing() {
        return this.wantsToGrab() || this.isGrabbing();
    }

    public boolean canContinueGrabbing() {
        return this.wantsToGrab() && this.m_20160_() && this.isGrabbing() && this.getGrabbingTicks() > 0;
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        if (this.wantsToGrab()) {
            if (this.hasReleased.booleanValue()) {
                this.hasReleased = false;
            }
            if (this.releaseJawsState.m_216984_()) {
                this.releaseJawsState.m_216973_();
            }
            if (!this.hasJawsOpened.booleanValue()) {
                this.openJawsStartTimeout = 10;
                this.hasJawsOpened = true;
                this.openJawsStartState.m_216977_(this.f_19797_);
            }
            if (this.openJawsStartTimeout > 0) {
                --this.openJawsStartTimeout;
                if (this.openJawsStartTimeout == 0) {
                    this.openJawsStartState.m_216973_();
                }
            }
            if (!this.hasJawsClosed.booleanValue() && this.hasJawsOpened.booleanValue() && this.closeJawsStartTimeout == 0) {
                this.closeJawsStartTimeout = 12;
                this.closeJawsState.m_216977_(this.f_19797_);
            }
            if (this.closeJawsStartTimeout > 0) {
                --this.closeJawsStartTimeout;
                if (this.closeJawsStartTimeout == 0) {
                    this.closeJawsState.m_216973_();
                    this.hasJawsClosed = true;
                }
            } else if (this.closeJawsStartTimeout != 0) {
                this.closeJawsStartTimeout = 0;
            }
        } else {
            this.openJawsStartState.m_216973_();
            this.closeJawsState.m_216973_();
            if (!this.hasReleased.booleanValue() && this.hasJawsClosed.booleanValue()) {
                this.hasReleased = true;
                this.releaseJawsState.m_216977_(this.f_19797_);
                this.releaseJawsStartTimeout = 15;
            }
            if (this.releaseJawsStartTimeout > 0) {
                --this.releaseJawsStartTimeout;
                if (this.releaseJawsStartTimeout == 0) {
                    this.releaseJawsState.m_216973_();
                }
            }
            if (this.hasJawsOpened.booleanValue()) {
                this.hasJawsOpened = false;
            }
            if (this.hasJawsClosed.booleanValue()) {
                this.hasJawsClosed = false;
            }
        }
        this.keepGrabbingState.m_246184_(this.wantsToGrab() && this.closeJawsStartTimeout == 0 && this.isGrabbing() && this.hasJawsClosed != false && !this.m_20197_().isEmpty(), this.f_19797_);
        this.keepJawsOpenState.m_246184_(this.wantsToGrab() && this.hasJawsOpened != false && this.hasJawsClosed == false, this.f_19797_);
        if (!this.isAttacking() && !this.wantsToGrab()) {
            if (this.idleLookTimeout <= 0) {
                this.idleLookTimeout = this.f_19796_.m_188503_(40) + 80;
                this.idleLookAround.m_216977_(this.f_19797_);
            } else {
                --this.idleLookTimeout;
            }
            if (this.idleTwitchTimeout <= 0) {
                this.idleTwitchTimeout = this.f_19796_.m_188503_(60) + 80;
                this.idleTwitchState.m_216977_(this.f_19797_);
            } else {
                --this.idleTwitchTimeout;
            }
            if (this.idleSignalTimeout <= 0) {
                this.idleSignalTimeout = this.f_19796_.m_188503_(30) + 60;
                this.idleSignalState.m_216977_(this.f_19797_);
            } else {
                --this.idleSignalTimeout;
            }
        } else {
            if (this.idleLookAround.m_216984_()) {
                this.idleLookAround.m_216973_();
            }
            if (this.idleTwitchState.m_216984_()) {
                this.idleTwitchState.m_216973_();
            }
        }
        this.idleOverlay.m_246184_(!this.m_20072_() && this.m_6084_(), this.f_19797_);
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12435_, 0.05f, this.m_6100_());
    }

    protected SoundEvent m_7515_() {
        return this.isGrabbing() ? (SoundEvent)MMSounds.BEHOLDER_GRABBING.get() : (SoundEvent)MMSounds.BEHOLDER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)MMSounds.BEHOLDER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MMSounds.BEHOLDER_DEATH.get();
    }

    public boolean m_6779_(LivingEntity pTarget) {
        return super.m_6779_(pTarget) && this.m_20197_().isEmpty();
    }

    public boolean m_275843_() {
        return false;
    }

    @Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public class BeholderAttackGoal
    extends AnimatedAttackGoal {
        private final Beholder beholder;

        public BeholderAttackGoal(Beholder pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, int pAttackDelay, int pTicksUntilNextAttack) {
            super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen, pAttackDelay, pTicksUntilNextAttack);
            this.beholder = pMob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.beholder.m_20197_().isEmpty() && !this.beholder.wantsToGrab();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.beholder.m_20197_().isEmpty() && !this.beholder.wantsToGrab();
        }
    }

    public class BeholderGrabGoal
    extends MeleeAttackGoal {
        private final Beholder beholder;

        public BeholderGrabGoal(Beholder pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.beholder = pMob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.beholder.wantsToGrab() && this.beholder.m_20197_().isEmpty();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.beholder.wantsToGrab() && this.beholder.m_20197_().isEmpty();
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if (pDistToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.beholder.m_216990_((SoundEvent)MMSounds.BEHOLDER_CLOSE.get());
                pEnemy.m_7998_((Entity)this.beholder, true);
                this.beholder.f_21365_.m_24946_(0.0, 0.0, 0.0);
                this.beholder.setIsGrabbing(true);
                this.beholder.setGrabbingTicks(60 + this.beholder.m_217043_().m_216339_(1, 5) * 20);
            }
            super.m_6739_(pEnemy, pDistToEnemySqr);
        }
    }

    public class BeholderStrollGoal
    extends RandomStrollGoal {
        private final Beholder beholder;

        public BeholderStrollGoal(Beholder pMob, double pSpeedModifier) {
            super((PathfinderMob)pMob, pSpeedModifier);
            this.beholder = pMob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.beholder.isLandNavigator;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.beholder.isLandNavigator;
        }
    }

    public class BeholderSwimGoal
    extends RandomStrollGoal {
        public BeholderSwimGoal(PathfinderMob creature, double speed, int chance) {
            super(creature, speed, chance, false);
        }

        public boolean m_8036_() {
            if (this.f_25725_.m_20160_() || this.f_25725_.m_5448_() != null || !this.f_25725_.m_20069_() && this.f_25725_ instanceof Beholder && ((Beholder)this.f_25725_).isLandNavigator) {
                return false;
            }
            if (!this.f_25731_ && this.f_25725_.m_217043_().m_188503_(this.f_25730_) != 0) {
                return false;
            }
            Vec3 vector3d = this.m_7037_();
            if (vector3d == null) {
                return false;
            }
            this.f_25726_ = vector3d.f_82479_;
            this.f_25727_ = vector3d.f_82480_;
            this.f_25728_ = vector3d.f_82481_;
            this.f_25731_ = false;
            return true;
        }

        @Nullable
        protected Vec3 m_7037_() {
            Vec3 vector3d;
            if (this.f_25725_.m_21536_() && this.f_25725_.m_20238_(Vec3.m_82512_((Vec3i)this.f_25725_.m_21534_())) > (double)(this.f_25725_.m_21535_() * this.f_25725_.m_21535_())) {
                return DefaultRandomPos.m_148412_((PathfinderMob)this.f_25725_, (int)7, (int)3, (Vec3)Vec3.m_82539_((Vec3i)this.f_25725_.m_21534_()), (double)1.0);
            }
            if (this.f_25725_.m_217043_().m_188501_() < 0.3f && (vector3d = this.findSurfaceTarget(this.f_25725_, 15, 7)) != null) {
                return vector3d;
            }
            vector3d = DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)7, (int)3);
            int i = 0;
            while (vector3d != null) {
                if (this.f_25725_.m_9236_().m_8055_(BeholderSwimGoal.fromVec3(vector3d)).m_60647_((BlockGetter)this.f_25725_.m_9236_(), BeholderSwimGoal.fromVec3(vector3d), PathComputationType.WATER) || i++ >= 15) break;
                vector3d = DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)10, (int)7);
            }
            return vector3d;
        }

        public static final BlockPos fromVec3(Vec3 vec3) {
            return BeholderSwimGoal.fromCoords(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }

        public static final BlockPos fromCoords(double x, double y, double z) {
            return new BlockPos((int)x, (int)y, (int)z);
        }

        private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
            BlockPos blockpos = pos.m_7918_(dx * scale, 0, dz * scale);
            return this.f_25725_.m_9236_().m_6425_(blockpos).m_205070_(FluidTags.f_13131_) && !this.f_25725_.m_9236_().m_8055_(blockpos).m_280555_();
        }

        private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
            return this.f_25725_.m_9236_().m_8055_(pos.m_7918_(dx * scale, 1, dz * scale)).m_60795_() && this.f_25725_.m_9236_().m_8055_(pos.m_7918_(dx * scale, 2, dz * scale)).m_60795_();
        }

        private Vec3 findSurfaceTarget(PathfinderMob creature, int i, int i1) {
            BlockPos upPos = creature.m_20183_();
            while (creature.m_9236_().m_6425_(upPos).m_205070_(FluidTags.f_13131_)) {
                upPos = upPos.m_7494_();
            }
            if (this.isAirAbove(upPos.m_7495_(), 0, 0, 0) && this.canJumpTo(upPos.m_7495_(), 0, 0, 0)) {
                return new Vec3((double)((float)upPos.m_123341_() + 0.5f), (double)((float)upPos.m_123342_() - 1.0f), (double)((float)upPos.m_123343_() + 0.5f));
            }
            return null;
        }
    }

    public class BeholderLookAtPlayer
    extends LookAtPlayerGoal {
        private final Beholder beholder;

        public BeholderLookAtPlayer(Beholder pMob) {
            super((Mob)pMob, Player.class, 8.0f);
            this.beholder = pMob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.beholder.isGrabbing();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.beholder.isGrabbing();
        }
    }

    public class BeholderRandomLook
    extends RandomLookAroundGoal {
        private final Beholder beholder;

        public BeholderRandomLook(Beholder pMob) {
            super((Mob)pMob);
            this.beholder = pMob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.beholder.isGrabbing();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.beholder.isGrabbing();
        }
    }
}

