/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.abomination;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.common.entity.ai.AnimatedAttackGoal;
import net.voidarkana.marvelous_menagerie.common.entity.base.Abomination;
import net.voidarkana.marvelous_menagerie.common.entity.base.IAnimatedAttacker;

public class Molten
extends Abomination
implements IAnimatedAttacker {
    public final AnimationState biteAttackAnimationState = new AnimationState();
    public final AnimationState slamAttackAnimationState = new AnimationState();
    public final AnimationState swirlAttackAnimationState1 = new AnimationState();
    public final AnimationState swirlAttackAnimationState2 = new AnimationState();
    public final AnimationState breatheFireAnimationState = new AnimationState();
    public final AnimationState shootFireballAnimationState = new AnimationState();
    public int attackAnimationTimeout;
    public int shootFireballAnimationTimeout;
    public int breatheFireAnimationTimeout;
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(Molten.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SHOOTING_FIREBALL = SynchedEntityData.m_135353_(Molten.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_BREATHING_FIRE = SynchedEntityData.m_135353_(Molten.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WANTS_TO_SHOOT_FIREBALL = SynchedEntityData.m_135353_(Molten.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WANTS_TO_BREATHE_FIRE = SynchedEntityData.m_135353_(Molten.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Molten(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new MoltenMeeleeAttackGoal(this, 1.25, true, 12, 18));
        this.f_21345_.m_25352_(1, (Goal)new MoltenShootFireballGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MoltenFireBreathingGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 32.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22284_, 10.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(IS_SHOOTING_FIREBALL, (Object)false);
        this.f_19804_.m_135372_(IS_BREATHING_FIRE, (Object)false);
        this.f_19804_.m_135372_(WANTS_TO_SHOOT_FIREBALL, (Object)false);
        this.f_19804_.m_135372_(WANTS_TO_BREATHE_FIRE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsAttacking", this.isAttacking());
        pCompound.m_128379_("IsShootingFireball", this.isShootingFireball());
        pCompound.m_128379_("IsBreathingFire", this.isBreathingFire());
        pCompound.m_128379_("WantsToShootFireball", this.wantsToShootFireball());
        pCompound.m_128379_("WantsToBreatheFire", this.wantsToBreatheFire());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAttacking(pCompound.m_128471_("IsAttacking"));
        this.setBreathingFire(pCompound.m_128471_("IsBreathingFire"));
        this.setShootingFireball(pCompound.m_128471_("IsShootingFireball"));
        this.setWantsToShootFireball(pCompound.m_128471_("WantsToGrab"));
        this.setWantsToBreatheFire(pCompound.m_128471_("IsGrabbing"));
    }

    public int fireballFollowRange() {
        return 48;
    }

    @Override
    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    @Override
    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)attacking);
    }

    public boolean isShootingFireball() {
        return (Boolean)this.f_19804_.m_135370_(IS_SHOOTING_FIREBALL);
    }

    public void setShootingFireball(boolean attacking) {
        this.f_19804_.m_135381_(IS_SHOOTING_FIREBALL, (Object)attacking);
    }

    public boolean isBreathingFire() {
        return (Boolean)this.f_19804_.m_135370_(IS_BREATHING_FIRE);
    }

    public void setBreathingFire(boolean attacking) {
        this.f_19804_.m_135381_(IS_BREATHING_FIRE, (Object)attacking);
    }

    public boolean wantsToShootFireball() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_SHOOT_FIREBALL);
    }

    public void setWantsToShootFireball(boolean attacking) {
        this.f_19804_.m_135381_(WANTS_TO_SHOOT_FIREBALL, (Object)attacking);
    }

    public boolean wantsToBreatheFire() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_BREATHE_FIRE);
    }

    public void setWantsToBreatheFire(boolean attacking) {
        this.f_19804_.m_135381_(WANTS_TO_BREATHE_FIRE, (Object)attacking);
    }

    @Override
    public int attackAnimationTimeout() {
        return this.attackAnimationTimeout;
    }

    @Override
    public void setAttackAnimationTimeout(int attackAnimationTimeout) {
        this.attackAnimationTimeout = attackAnimationTimeout;
    }

    @Override
    public void m_8119_() {
        block11: {
            super.m_8119_();
            if (!(this.m_204029_(FluidTags.f_13131_) || this.wantsToShootFireball() || this.wantsToBreatheFire() || this.f_19796_.m_188503_(50) != 0 || this.m_5448_() == null)) {
                if (this.m_217043_().m_188499_()) {
                    this.setWantsToBreatheFire(true);
                } else {
                    this.setWantsToShootFireball(true);
                }
            } else if ((this.wantsToBreatheFire() || this.wantsToBreatheFire()) && (this.m_5448_() == null || this.m_204029_(FluidTags.f_13131_))) {
                if (this.wantsToBreatheFire()) {
                    this.setWantsToBreatheFire(false);
                }
                if (this.wantsToShootFireball()) {
                    this.setWantsToShootFireball(false);
                }
            }
            if (!this.m_9236_().f_46443_) break block11;
            Vec3 vec3 = this.m_20252_(0.0f);
            float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float f2 = 1.2f - this.f_19796_.m_188501_() * 0.7f;
            if (this.m_204029_(FluidTags.f_13131_)) {
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + vec3.f_82479_ * (double)f2 + (double)f, this.m_20186_() + vec3.f_82480_ + 1.75, this.m_20189_() + vec3.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + vec3.f_82479_ * (double)f2 - (double)f, this.m_20186_() + vec3.f_82480_ + 1.75, this.m_20189_() + vec3.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + vec3.f_82479_ * (double)f2 + (double)f, this.m_20186_() + vec3.f_82480_ + 1.75, this.m_20189_() + vec3.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + vec3.f_82479_ * (double)f2 - (double)f, this.m_20186_() + vec3.f_82480_ + 1.75, this.m_20189_() + vec3.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            switch (this.m_217043_().m_188503_(4)) {
                case 1: {
                    this.slamAttackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.swirlAttackAnimationState1.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.swirlAttackAnimationState2.m_216977_(this.f_19797_);
                    break;
                }
                default: {
                    this.biteAttackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
            }
        } else {
            --this.attackAnimationTimeout;
        }
        if (this.isBreathingFire() && this.breatheFireAnimationTimeout <= 0) {
            this.breatheFireAnimationTimeout = 60;
            this.breatheFireAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.breatheFireAnimationTimeout;
        }
        if (this.isShootingFireball() && this.shootFireballAnimationTimeout <= 0) {
            this.shootFireballAnimationTimeout = 24;
            this.shootFireballAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.shootFireballAnimationTimeout;
        }
    }

    public float getStepHeight() {
        return 1.5f;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)MMSounds.MOLTEN_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)MMSounds.MOLTEN_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)MMSounds.MOLTEN_IDLE.get();
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            this.m_20124_(Pose.STANDING);
            this.m_6858_(d0 >= 1.25);
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_((SoundEvent)MMSounds.MOLTEN_STEPS.get(), 0.1f, this.m_6100_() + this.f_19796_.m_188501_() * 0.4f);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7640_() instanceof Snowball) {
            return super.m_6469_(pSource, 3.0f);
        }
        return super.m_6469_(pSource, pAmount);
    }

    static class MoltenMeeleeAttackGoal
    extends AnimatedAttackGoal {
        private final Molten molten;

        public MoltenMeeleeAttackGoal(Molten pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, int pAttackDelay, int pTicksUntilNextAttack) {
            super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen, pAttackDelay, pTicksUntilNextAttack);
            this.molten = pMob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.molten.wantsToBreatheFire() && !this.molten.wantsToShootFireball();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.molten.wantsToBreatheFire() && !this.molten.wantsToShootFireball();
        }
    }

    static class MoltenShootFireballGoal
    extends Goal {
        private final Molten molten;
        public int chargeTime;

        public MoltenShootFireballGoal(Molten pMolten) {
            this.molten = pMolten;
        }

        public boolean m_8036_() {
            return this.molten.m_5448_() != null && this.molten.wantsToShootFireball();
        }

        public void m_8056_() {
            this.chargeTime = 0;
        }

        public void m_8041_() {
            this.molten.setShootingFireball(false);
            this.molten.setWantsToShootFireball(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.molten.m_5448_();
            if (livingentity != null) {
                double d0 = 64.0;
                if (livingentity.m_20280_((Entity)this.molten) < 4096.0 && this.molten.m_142582_((Entity)livingentity)) {
                    this.molten.m_21391_((Entity)livingentity, 10.0f, 10.0f);
                    this.molten.setShootingFireball(true);
                    Level level = this.molten.m_9236_();
                    ++this.chargeTime;
                    if (this.chargeTime == 10) {
                        double d1 = 4.0;
                        Vec3 vec3 = this.molten.m_20252_(1.0f);
                        double d2 = livingentity.m_20185_() - (this.molten.m_20185_() + vec3.f_82479_);
                        double d3 = livingentity.m_20227_(0.5) - (0.5 + this.molten.m_20227_(0.5));
                        double d4 = livingentity.m_20189_() - (this.molten.m_20189_() + vec3.f_82481_);
                        if (!this.molten.m_20067_()) {
                            this.molten.m_9236_().m_5898_((Player)null, 1018, this.molten.m_20183_(), 0);
                        }
                        LargeFireball smallFireball = new LargeFireball(level, (LivingEntity)this.molten, d2, d3, d4, 1);
                        smallFireball.m_6034_(this.molten.m_20185_() + vec3.f_82479_ * 4.0, this.molten.m_20227_(0.5) + 0.5, smallFireball.m_20189_() + vec3.f_82481_ * 4.0);
                        level.m_7967_((Entity)smallFireball);
                        this.chargeTime = -40;
                        this.m_8041_();
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
            }
        }
    }

    static class MoltenFireBreathingGoal
    extends Goal {
        private final Molten molten;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public MoltenFireBreathingGoal(Molten pBlaze) {
            this.molten = pBlaze;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.molten.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.molten.m_6779_(livingentity) && this.molten.wantsToBreatheFire();
        }

        public void m_8056_() {
            this.attackTime = 10;
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.lastSeen = 0;
            this.molten.setWantsToBreatheFire(false);
            this.molten.setBreathingFire(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.attackTime == 10 && !this.molten.isBreathingFire()) {
                this.molten.setBreathingFire(true);
            }
            --this.attackTime;
            LivingEntity livingentity = this.molten.m_5448_();
            if (livingentity != null) {
                boolean flag = this.molten.m_21574_().m_148306_((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.molten.m_20280_((Entity)livingentity);
                if (d0 < 225.0 && flag) {
                    double d1 = livingentity.m_20185_() - this.molten.m_20185_();
                    double d2 = livingentity.m_20227_(0.5) - this.molten.m_20227_(0.5);
                    double d3 = livingentity.m_20189_() - this.molten.m_20189_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep <= 5) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                            this.m_8041_();
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            if (!this.molten.m_20067_()) {
                                this.molten.m_9236_().m_5898_((Player)null, 1018, this.molten.m_20183_(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                SmallFireball smallfireball = new SmallFireball(this.molten.m_9236_(), (LivingEntity)this.molten, this.molten.m_217043_().m_216328_(d1, 2.297 * d4), d2, this.molten.m_217043_().m_216328_(d3, 2.297 * d4));
                                smallfireball.m_6034_(smallfireball.m_20185_(), this.molten.m_20227_(0.5) + 0.5, smallfireball.m_20189_());
                                this.molten.m_9236_().m_7967_((Entity)smallfireball);
                            }
                        }
                    }
                    this.molten.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                    this.molten.m_21391_((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.molten.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.5);
                }
                super.m_8037_();
            }
        }

        private double getFollowDistance() {
            return this.molten.fireballFollowRange();
        }
    }
}

