/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.ai;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.voidarkana.marvelous_menagerie.common.entity.base.IAnimatedAttacker;

public class AnimatedAttackGoal
extends MeleeAttackGoal {
    private final LivingEntity entity;
    private int attackDelay;
    private int ticksUntilNextAttack;
    private int attackDelayStored;
    private int ticksUntilNextAttackStored;
    private boolean shouldCountTillNextAttack = false;

    public AnimatedAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, int pAttackDelay, int pTicksUntilNextAttack) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = pMob;
        this.attackDelayStored = pAttackDelay;
        this.ticksUntilNextAttackStored = pTicksUntilNextAttack;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = this.attackDelayStored;
        this.ticksUntilNextAttack = this.ticksUntilNextAttackStored;
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            LivingEntity livingEntity;
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation() && (livingEntity = this.entity) instanceof IAnimatedAttacker) {
                IAnimatedAttacker attacker = (IAnimatedAttacker)livingEntity;
                attacker.setAttacking(true);
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            LivingEntity livingEntity = this.entity;
            if (livingEntity instanceof IAnimatedAttacker) {
                IAnimatedAttacker attacker = (IAnimatedAttacker)livingEntity;
                attacker.setAttacking(false);
                attacker.setAttackAnimationTimeout(0);
            }
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= this.m_6639_(pEnemy);
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(this.attackDelayStored + this.ticksUntilNextAttackStored);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        this.m_25563_();
        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
        this.f_25540_.m_7327_((Entity)pEnemy);
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof IAnimatedAttacker) {
            IAnimatedAttacker attacker = (IAnimatedAttacker)livingEntity;
            attacker.setAttacking(false);
        }
        super.m_8041_();
    }
}

