/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.ai.boids;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.marvelous_menagerie.common.entity.animal.Arandaspis;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoidGoal
extends Goal {
    public static final Logger LOGGER = LogManager.getLogger();
    public final float separationInfluence;
    public final float separationRange;
    public final float alignmentInfluence;
    public final float cohesionInfluence;
    private final Arandaspis mob;
    private int timeToFindNearbyEntities = 0;
    List<? extends Arandaspis> nearbyMobs;
    private boolean enabled = true;

    public BoidGoal(Arandaspis mob, float separationInfluence, float separationRange, float alignmentInfluence, float cohesionInfluence) {
        this.mob = mob;
        this.separationInfluence = separationInfluence;
        this.separationRange = separationRange;
        this.alignmentInfluence = alignmentInfluence;
        this.cohesionInfluence = cohesionInfluence;
    }

    public boolean m_8036_() {
        return this.mob.m_20069_() && this.mob.isFollower();
    }

    public void m_8037_() {
        if (!this.enabled) {
            return;
        }
        if (--this.timeToFindNearbyEntities <= 0) {
            this.timeToFindNearbyEntities = this.m_183277_(40);
            this.nearbyMobs = BoidGoal.getNearbyEntitiesOfSameSchool(this.mob);
        } else {
            this.nearbyMobs.removeIf(LivingEntity::m_21224_);
        }
        if (this.nearbyMobs.isEmpty()) {
            LOGGER.warn("No nearby entities found. There should always be at least the entity itself. Will disable behavior for this entity instead of crash for compatibility reasons");
            this.enabled = false;
        }
        if (this.enabled) {
            this.mob.m_246865_(this.cohesion());
            this.mob.m_246865_(this.alignment());
            this.mob.m_246865_(this.separation());
        }
    }

    public static List<? extends Arandaspis> getNearbyEntitiesOfSameSchool(Arandaspis pMob) {
        Predicate<Arandaspis> predicate = pArandaspis -> {
            if (pArandaspis.isFollower() && pMob.isFollower()) {
                return pArandaspis.leader == pMob.leader;
            }
            if (pArandaspis.isFollower() && pMob.canBeFollowed()) {
                return pArandaspis.leader == pMob;
            }
            if (pArandaspis.canBeFollowed() && pMob.isFollower()) {
                return pMob.leader == pArandaspis;
            }
            return false;
        };
        return pMob.m_9236_().m_6443_(((Object)((Object)pMob)).getClass(), pMob.m_20191_().m_82377_(4.0, 4.0, 4.0), predicate);
    }

    public Vec3 random() {
        Vec3 velocity = this.mob.m_20184_();
        if ((double)Mth.m_14154_((float)((float)velocity.f_82479_)) < 0.1 && (double)Mth.m_14154_((float)((float)velocity.f_82481_)) < 0.1) {
            return new Vec3((double)this.randomSign() * 0.1, 0.0, (double)this.randomSign() * 0.1);
        }
        return Vec3.f_82478_;
    }

    public int randomSign() {
        boolean isNegative = this.mob.m_217043_().m_188499_();
        if (isNegative) {
            return -1;
        }
        return 1;
    }

    public Vec3 separation() {
        Vec3 c = Vec3.f_82478_;
        for (Mob mob : this.nearbyMobs) {
            if (!(mob.m_20182_().m_82546_(this.mob.m_20182_()).m_82553_() < (double)this.separationRange)) continue;
            c = c.m_82546_(mob.m_20182_().m_82546_(this.mob.m_20182_()));
        }
        return c.m_82490_((double)this.separationInfluence);
    }

    public Vec3 alignment() {
        Vec3 c = Vec3.f_82478_;
        for (Mob mob : this.nearbyMobs) {
            c = c.m_82549_(mob.m_20184_());
        }
        c = c.m_82490_((double)(1.0f / (float)this.nearbyMobs.size()));
        c = c.m_82546_(this.mob.m_20184_());
        return c.m_82490_((double)this.alignmentInfluence);
    }

    public Vec3 cohesion() {
        Vec3 c = Vec3.f_82478_;
        for (Mob mob : this.nearbyMobs) {
            c = c.m_82549_(mob.m_20182_());
        }
        c = c.m_82490_((double)(1.0f / (float)this.nearbyMobs.size()));
        c = c.m_82546_(this.mob.m_20182_());
        return c.m_82490_((double)this.cohesionInfluence);
    }
}

