/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.ai.AnimatedAttackGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.FishBreedGoal;
import net.voidarkana.marvelous_menagerie.common.entity.base.AbstractBasicFish;
import net.voidarkana.marvelous_menagerie.common.entity.base.BreedableWaterAnimal;
import net.voidarkana.marvelous_menagerie.common.entity.base.IAnimatedAttacker;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import org.jetbrains.annotations.Nullable;

public class Anomalocaris
extends AbstractBasicFish
implements IAnimatedAttacker,
NeutralMob {
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(Anomalocaris.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SHAKING_TIME = SynchedEntityData.m_135353_(Anomalocaris.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Anomalocaris.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Anomalocaris.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @javax.annotation.Nullable
    private UUID persistentAngerTarget;
    public int attackAnimationTimeout;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState shakeAnimationState = new AnimationState();

    public Anomalocaris(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new AnimatedAttackGoal((PathfinderMob)this, 1.25, true, 7, 13));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this.foodIngredients(), false));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this.fintasticFoodIngredients(), false));
        this.f_21345_.m_25352_(2, (Goal)new FishBreedGoal(this, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Anomalocaris)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    public Ingredient foodIngredients() {
        return Ingredient.m_204132_((TagKey)ItemTags.f_13156_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, (double)0.8f).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22284_, 5.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHAKING_TIME, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ShakingTime", this.getShakingTime());
        pCompound.m_128405_("Variant", this.getVariant());
        pCompound.m_128379_("IsAttacking", this.isAttacking());
        this.m_21678_(pCompound);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setShakingTime(pCompound.m_128451_("ShakingTime"));
        this.setVariant(pCompound.m_128451_("Variant"));
        this.setAttacking(pCompound.m_128471_("IsAttacking"));
        this.m_147285_(this.m_9236_(), pCompound);
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, pEntity);
        }
        return flag;
    }

    @Override
    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    @Override
    public void setAttacking(boolean pFromBucket) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)pFromBucket);
    }

    @Override
    public int attackAnimationTimeout() {
        return this.attackAnimationTimeout;
    }

    @Override
    public void setAttackAnimationTimeout(int attackAnimationTimeout) {
        this.attackAnimationTimeout = attackAnimationTimeout;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int anim) {
        this.f_19804_.m_135381_(VARIANT, (Object)anim);
    }

    public int getShakingTime() {
        return (Integer)this.f_19804_.m_135370_(SHAKING_TIME);
    }

    public void setShakingTime(int variant) {
        this.f_19804_.m_135381_(SHAKING_TIME, (Object)variant);
    }

    @Override
    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Variant", this.getVariant());
        compoundnbt.m_128405_("Age", this.getAge());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    @Override
    public void m_142278_(CompoundTag pTag) {
        super.m_142278_(pTag);
        this.setVariant(pTag.m_128451_("Variant"));
        if (pTag.m_128441_("Age")) {
            this.setAge(pTag.m_128451_("Age"));
        }
        this.setCanGrowUp(pTag.m_128471_("CanGrow"));
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)MMItems.CARIS_BUCKET.get());
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int chance = this.m_217043_().m_188503_(100);
        int variant = chance < 50 ? 0 : (chance < 75 ? 1 : (chance < 85 ? 2 : (chance < 95 ? 3 : 4)));
        this.setVariant(variant);
        if (reason == MobSpawnType.TRIGGERED) {
            this.m_27497_(true);
        }
        if (reason == MobSpawnType.BUCKET && dataTag != null && dataTag.m_128425_("Variant", 3)) {
            if (dataTag.m_128441_("Age")) {
                this.setAge(dataTag.m_128451_("Age"));
            }
            this.m_27497_(dataTag.m_128471_("CanGrowUp"));
            this.setVariant(dataTag.m_128451_("Variant"));
            this.m_27497_(true);
        }
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public String getVariantName(int variantNumber) {
        return switch (variantNumber) {
            case 1 -> "_swampy";
            case 2 -> "_blue";
            case 3 -> "_yellow";
            case 4 -> "_half";
            default -> "";
        };
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        Anomalocaris baby = (Anomalocaris)((EntityType)MMEntities.ANOMALOCARIS.get()).m_20615_((Level)pLevel);
        Anomalocaris otherCaris = (Anomalocaris)pOtherParent;
        if (this.m_217043_().m_188503_(4) == 0) {
            int chance = this.m_217043_().m_188503_(100);
            int variant = chance < 50 ? 0 : (chance < 75 ? 1 : (chance < 85 ? 2 : (chance < 95 ? 3 : 4)));
            baby.setVariant(variant);
        } else if (this.f_19796_.m_188499_()) {
            baby.setVariant(this.getVariant());
        } else {
            baby.setVariant(otherCaris.getVariant());
        }
        baby.m_27497_(true);
        return baby;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getShakingTime() > 0) {
            int prevShakingTime = this.getShakingTime();
            if (this.getShakingTime() == 12) {
                this.m_5496_(SoundEvents.f_279531_, 1.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.0f);
            }
            if (this.getShakingTime() == 10) {
                this.m_19998_((ItemLike)MMItems.CARIS_SCUTE.get());
            }
            this.setShakingTime(prevShakingTime - 1);
        }
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        this.shakeAnimationState.m_246184_(this.getShakingTime() > 0, this.f_19797_);
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_((Item)MMItems.TRILO_BITE.get()) && this.m_20069_() && this.getShakingTime() == 0) {
            this.usePlayerItem(player, hand, itemstack);
            this.m_5496_(SoundEvents.f_11803_, 1.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.0f);
            this.setShakingTime(30);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void usePlayerItem(Player pPlayer, InteractionHand pHand, ItemStack pStack) {
        if (!pPlayer.m_150110_().f_35937_) {
            pStack.m_41774_(1);
        }
    }

    public boolean m_6573_(Player pPlayer) {
        return true;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)MMSounds.ARTHROPOD_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)MMSounds.ARTHROPOD_DEATH.get();
    }

    public boolean m_6779_(LivingEntity entity) {
        return super.m_6779_(entity) && !this.m_6162_();
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }
}

