/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import com.mojang.datafixers.DataFixUtils;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.ai.FishBreedGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.boids.BoidGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.boids.LimitSpeedAndLookInVelocityDirectionGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.boids.StayInWaterGoal;
import net.voidarkana.marvelous_menagerie.common.entity.base.BreedableWaterAnimal;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import org.jetbrains.annotations.Nullable;

public class Arandaspis
extends BreedableWaterAnimal
implements Bucketable {
    public final AnimationState idleAnimationState = new AnimationState();
    @javax.annotation.Nullable
    public Arandaspis leader;
    public int schoolSize = 1;
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Arandaspis.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Arandaspis.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Arandaspis(EntityType<? extends BreedableWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this.fintasticFoodIngredients(), false));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this.foodIngredients(), false));
        this.f_21345_.m_25352_(1, (Goal)new FishBreedGoal(this, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(1, (Goal)new OrganizeBoidsGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BoidGoal(this, 0.2f, 0.4f, 0.4f, 0.05f));
        this.f_21345_.m_25352_(2, (Goal)new StayInWaterGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LimitSpeedAndLookInVelocityDirectionGoal(this, 0.65f));
        this.f_21345_.m_25352_(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
    }

    @Override
    public Ingredient foodIngredients() {
        return Ingredient.m_204132_((TagKey)ItemTags.f_13156_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, (double)0.8f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
        pCompound.m_128405_("Variant", this.getVariant());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
        this.setVariant(pCompound.m_128451_("Variant"));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    protected void m_280447_() {
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)MMItems.ARANDASPIS_BUCKET.get());
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Age", this.getAge());
        compoundnbt.m_128379_("CanGrow", this.getCanGrowUp().booleanValue());
        compoundnbt.m_128405_("Variant", this.getVariant());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
        this.setVariant(pTag.m_128451_("Variant"));
        if (pTag.m_128441_("Age")) {
            this.setAge(pTag.m_128451_("Age"));
        }
        this.setCanGrowUp(pTag.m_128471_("CanGrow"));
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
    }

    @Override
    @Nullable
    public BreedableWaterAnimal getBreedOffspring(ServerLevel pLevel, BreedableWaterAnimal pOtherParent) {
        Arandaspis otherParent = (Arandaspis)pOtherParent;
        Arandaspis baby = (Arandaspis)((EntityType)MMEntities.ARANDASPIS.get()).m_20615_((Level)pLevel);
        baby.m_27497_(true);
        baby.setVariant(this.m_217043_().m_188499_() ? this.getVariant() : otherParent.getVariant());
        return baby;
    }

    public static String getVariantName(int variantNumber) {
        return switch (variantNumber) {
            case 1 -> "blue";
            default -> "green";
        };
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11758_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11761_;
    }

    @Override
    public SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }

    public int m_5792_() {
        return this.getMaxSchoolSize();
    }

    public int getMaxSchoolSize() {
        return 10;
    }

    protected boolean canRandomSwim() {
        return !this.isFollower();
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public Arandaspis startFollowing(Arandaspis pLeader) {
        this.leader = pLeader;
        pLeader.addFollower();
        return pLeader;
    }

    public void stopFollowing() {
        this.leader.removeFollower();
        this.leader = null;
    }

    private void addFollower() {
        ++this.schoolSize;
    }

    private void removeFollower() {
        --this.schoolSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.schoolSize < this.getMaxSchoolSize();
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.schoolSize = 1;
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.idleAnimationState.m_246184_(this.m_6084_(), this.f_19797_);
    }

    @Override
    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public boolean hasFollowers() {
        return this.schoolSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends Arandaspis> pFollowers) {
        pFollowers.limit(this.getMaxSchoolSize() - this.schoolSize).filter(p_27538_ -> p_27538_ != this).forEach(p_27536_ -> p_27536_.startFollowing(this));
    }

    @Override
    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pSpawnData == null) {
            pSpawnData = new SchoolSpawnGroupData(this);
        } else {
            this.startFollowing(((SchoolSpawnGroupData)pSpawnData).leader);
        }
        if (pReason == MobSpawnType.TRIGGERED || pReason == MobSpawnType.BREEDING) {
            this.m_27497_(true);
        }
        if (pReason == MobSpawnType.BUCKET && pDataTag != null && pDataTag.m_128425_("CanGrowUp", 3)) {
            if (pDataTag.m_128441_("Age")) {
                this.setAge(pDataTag.m_128451_("Age"));
            }
            this.setVariant(pDataTag.m_128451_("Variant"));
            this.m_27497_(pDataTag.m_128471_("CanGrowUp"));
            this.m_27497_(true);
        } else {
            this.setVariant(this.m_217043_().m_188503_(2));
        }
        return pSpawnData;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public class OrganizeBoidsGoal
    extends Goal {
        private static final int INTERVAL_TICKS = 200;
        private final Arandaspis mob;
        private int timeToRecalcPath;
        private int nextStartTick;

        public OrganizeBoidsGoal(Arandaspis pFish) {
            this.mob = pFish;
            this.nextStartTick = this.nextStartTick(pFish);
        }

        protected int nextStartTick(Arandaspis pTaskOwner) {
            return OrganizeBoidsGoal.m_186073_((int)(200 + pTaskOwner.m_217043_().m_188503_(200) % 20));
        }

        public boolean m_8036_() {
            if (this.mob.hasFollowers()) {
                return false;
            }
            if (this.mob.isFollower()) {
                return true;
            }
            if (this.nextStartTick > 0) {
                --this.nextStartTick;
                return false;
            }
            this.nextStartTick = this.nextStartTick(this.mob);
            Predicate<Arandaspis> predicate = p_25258_ -> p_25258_.canBeFollowed() || !p_25258_.isFollower();
            List list = this.mob.m_9236_().m_6443_(((Object)((Object)this.mob)).getClass(), this.mob.m_20191_().m_82377_(8.0, 8.0, 8.0), predicate);
            Arandaspis abstractschoolingfish = (Arandaspis)((Object)DataFixUtils.orElse(list.stream().filter(Arandaspis::canBeFollowed).findAny(), (Object)((Object)this.mob)));
            abstractschoolingfish.addFollowers(list.stream().filter(p_25255_ -> !p_25255_.isFollower()));
            return this.mob.isFollower();
        }

        public boolean m_8045_() {
            return this.mob.isFollower() && this.mob.inRangeOfLeader();
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.mob.stopFollowing();
        }
    }

    public static class SchoolSpawnGroupData
    extends BreedableWaterAnimal.AgeableFishGroupData {
        public final Arandaspis leader;

        public SchoolSpawnGroupData(Arandaspis pLeader) {
            super(true);
            this.leader = pLeader;
        }
    }

    static class FishSwimGoal
    extends RandomSwimmingGoal {
        private final Arandaspis fish;

        public FishSwimGoal(Arandaspis boidFish) {
            super((PathfinderMob)boidFish, 1.0, 10);
            this.fish = boidFish;
        }

        public boolean m_8036_() {
            return !this.fish.isFollower() && !this.fish.hasFollowers() && super.m_8036_();
        }
    }
}

