/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.common.block.MMBlocks;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.ai.AnimatedAttackGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.BabyPanicGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.EggLayerBreedGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.LayEggGoal;
import net.voidarkana.marvelous_menagerie.common.entity.base.IAnimatedAttacker;
import net.voidarkana.marvelous_menagerie.common.entity.base.IEggLayer;
import net.voidarkana.marvelous_menagerie.common.entity.base.MarvelousAnimal;
import net.voidarkana.marvelous_menagerie.util.MMTags;

public class Borealopelta
extends MarvelousAnimal
implements IAnimatedAttacker,
IEggLayer {
    public final AnimationState attackAnimationState1 = new AnimationState();
    public final AnimationState attackAnimationState2 = new AnimationState();
    public final AnimationState idleShakeState = new AnimationState();
    public int attackAnimationTimeout;
    int layEggCounter;
    private int idleShakeTimeout = this.m_217043_().m_188503_(160) + 160;
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41865_, Items.f_42211_});
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(Borealopelta.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_PREGNANT = SynchedEntityData.m_135353_(Borealopelta.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LAYING_EGG = SynchedEntityData.m_135353_(Borealopelta.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Borealopelta(EntityType<? extends MarvelousAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new AnimatedAttackGoal((PathfinderMob)this, 1.35, true, 27, 53));
        this.f_21345_.m_25352_(1, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(1, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new BabyPanicGoal((PathfinderMob)this, 1.25).setAlertOthers(new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new EggLayerBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new LayEggGoal(this, 1.0, MMTags.Blocks.DINOSAUR_NEST, (Supplier<Block>)MMBlocks.BOREALOPELTA_EGG, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        this.m_6210_();
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        if (this.m_6162_()) {
            return super.m_6972_(pPose).m_20390_(0.65f, 0.65f);
        }
        return super.m_6972_(pPose);
    }

    public boolean m_21040_(LivingEntity pLivingentity, TargetingConditions pCondition) {
        return super.m_21040_(pLivingentity, pCondition) && !this.m_6162_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(IS_PREGNANT, (Object)false);
        this.f_19804_.m_135372_(IS_LAYING_EGG, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsAttacking", this.isAttacking());
        compound.m_128379_("IsPregnant", this.isPregnant());
        compound.m_128379_("IsLayingEgg", this.isLayingEgg());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAttacking(compound.m_128471_("IsAttacking"));
        this.setPregnant(compound.m_128471_("IsPregnant"));
        this.setLayingEgg(compound.m_128471_("IsLayingEgg"));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.125).m_22268_(Attributes.f_22281_, 14.0);
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 80;
            if (this.m_217043_().m_188499_()) {
                this.attackAnimationState2.m_216977_(this.f_19797_);
            } else {
                this.attackAnimationState1.m_216977_(this.f_19797_);
            }
        } else {
            --this.attackAnimationTimeout;
        }
        if (this.idleShakeTimeout <= 0) {
            this.idleShakeTimeout = this.m_217043_().m_188503_(160) + 160;
            this.idleShakeState.m_216977_(this.f_19797_);
        } else {
            --this.idleShakeTimeout;
        }
    }

    public float getStepHeight() {
        return 1.1f;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)MMSounds.BOREALOPELTA_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)MMSounds.BOREALOPELTA_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)MMSounds.BOREALOPELTA_AMBIENT.get();
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)MMEntities.BOREALOPELTA.get()).m_20615_((Level)level);
    }

    @Override
    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    @Override
    public void setAttacking(boolean pFromBucket) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)pFromBucket);
    }

    @Override
    public boolean isPregnant() {
        return (Boolean)this.f_19804_.m_135370_(IS_PREGNANT);
    }

    @Override
    public void setPregnant(boolean pregnant) {
        this.f_19804_.m_135381_(IS_PREGNANT, (Object)pregnant);
    }

    @Override
    public int getLayEggCounter() {
        return this.layEggCounter;
    }

    @Override
    public void setLayEggCounter(int layEggCounter) {
        this.layEggCounter = layEggCounter;
    }

    @Override
    public boolean isLayingEgg() {
        return (Boolean)this.f_19804_.m_135370_(IS_LAYING_EGG);
    }

    @Override
    public void setLayingEgg(boolean pIsLayingEgg) {
        this.layEggCounter = pIsLayingEgg ? 1 : 0;
        this.f_19804_.m_135381_(IS_LAYING_EGG, (Object)pIsLayingEgg);
    }

    @Override
    public void onEggLaid() {
    }

    @Override
    public int attackAnimationTimeout() {
        return this.attackAnimationTimeout;
    }

    @Override
    public void setAttackAnimationTimeout(int attackAnimationTimeout) {
        this.attackAnimationTimeout = attackAnimationTimeout;
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)MMSounds.LARGE_STEPS.get(), 0.25f, 1.0f);
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            this.m_20124_(Pose.STANDING);
            this.m_6858_(d0 >= 1.25);
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.isLayingEgg() && this.layEggCounter >= 1 && this.layEggCounter % 5 == 0) {
            BlockPos blockpos = this.m_20183_();
            if (this.m_9236_().m_8055_(blockpos.m_7495_()).m_204336_(MMTags.Blocks.DINOSAUR_NEST)) {
                this.m_9236_().m_46796_(2001, blockpos, Block.m_49956_((BlockState)this.m_9236_().m_8055_(blockpos.m_7495_())));
            }
        }
    }
}

