/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.animal.ZombieDawnHorse;
import net.voidarkana.marvelous_menagerie.common.entity.base.MarvelousAnimal;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import net.voidarkana.marvelous_menagerie.util.MMTags;
import org.jetbrains.annotations.Nullable;

public class DawnHorse
extends MarvelousAnimal {
    public final AnimationState idleTailState = new AnimationState();
    public final AnimationState idleEarsState = new AnimationState();
    public final AnimationState neighState = new AnimationState();
    private int idleTailTimeout = this.f_19796_.m_188503_(40) + 80;
    private int idleEarsTimeout = this.f_19796_.m_188503_(40) + 80;
    private int neighTimeout = 0;
    protected boolean canGallop = true;
    protected int gallopSoundCounter;

    public DawnHorse(EntityType<? extends MarvelousAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42677_}), false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_150930_(Items.f_42677_);
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        if (this.idleEarsTimeout <= 0) {
            this.idleEarsTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleEarsState.m_216977_(this.f_19797_);
        } else {
            --this.idleEarsTimeout;
        }
        if (this.idleTailTimeout <= 0) {
            this.idleTailTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleTailState.m_216977_(this.f_19797_);
        } else {
            --this.idleTailTimeout;
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)MMEntities.DAWN_HORSE.get()).m_20615_((Level)p_146743_);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11975_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return SoundEvents.f_11978_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11971_;
    }

    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_204117_(MMTags.Items.DOMESTICATION_INNOVATION_ROTTEN_APPLE) || itemstack.m_150930_((Item)MMItems.CHUD_FLESH.get())) {
            this.m_5496_(SoundEvents.f_11975_, 0.8f, this.m_6100_());
            this.m_5496_(SoundEvents.f_12609_, 0.8f, this.m_6100_());
            CompoundTag horseExtras = new CompoundTag();
            this.m_7380_(horseExtras);
            for (int i = 0; i < 6 + this.m_217043_().m_188503_(5); ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123763_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
            ZombieDawnHorse zombie = (ZombieDawnHorse)((EntityType)MMEntities.ZOMBIE_DAWN_HORSE.get()).m_20615_(this.m_9236_());
            if (this.m_21523_()) {
                zombie.m_21463_(this.m_21524_(), true);
            }
            zombie.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            zombie.m_21557_(this.m_21525_());
            zombie.m_6863_(this.m_6162_());
            if (this.m_8077_()) {
                zombie.m_6593_(this.m_7770_());
                zombie.m_20340_(this.m_20151_());
            }
            zombie.m_7378_(horseExtras);
            zombie.m_21530_();
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)zombie);
            pPlayer.m_9236_().m_7967_((Entity)zombie);
            this.m_146870_();
            if (!pPlayer.m_7500_()) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_7111_(pPlayer, pVec, pHand);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        int i;
        if (pFallDistance > 1.0f) {
            this.m_5496_(SoundEvents.f_11980_, 0.4f, 1.0f);
        }
        if ((i = this.m_5639_(pFallDistance, pMultiplier)) <= 0) {
            return false;
        }
        this.m_6469_(pSource, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(pSource, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    public float m_6100_() {
        return this.m_6162_() ? 4.2f : 2.2f;
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            this.m_20124_(Pose.STANDING);
            this.m_6858_(d0 >= 1.25);
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        if (!pBlock.m_278721_()) {
            BlockState blockstate = this.m_9236_().m_8055_(pPos.m_7494_());
            SoundType soundtype = pBlock.getSoundType((LevelReader)this.m_9236_(), pPos, (Entity)this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)this.m_9236_(), pPos, (Entity)this);
            }
            if (this.m_20160_() && this.canGallop) {
                ++this.gallopSoundCounter;
                if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopSoundCounter <= 5) {
                    this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
                }
            } else if (this.isWoodSoundType(soundtype)) {
                this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                this.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    private boolean isWoodSoundType(SoundType pSoundType) {
        return pSoundType == SoundType.f_56736_ || pSoundType == SoundType.f_244244_ || pSoundType == SoundType.f_56763_ || pSoundType == SoundType.f_271497_ || pSoundType == SoundType.f_243772_;
    }

    protected void playGallopSound(SoundType pSoundType) {
        this.m_5496_(SoundEvents.f_11977_, pSoundType.m_56773_() * 0.15f, pSoundType.m_56774_());
    }
}

