/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.base.MarvelousAnimal;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import net.voidarkana.marvelous_menagerie.util.config.CommonConfig;
import org.jetbrains.annotations.Nullable;

public class Diplocaulus
extends MarvelousAnimal
implements Bucketable {
    public float currentRoll = 0.0f;
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Diplocaulus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Diplocaulus(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.1f, 0.5f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 20);
        this.m_274367_(1.0f);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        this.m_6210_();
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        if (this.m_6162_()) {
            return super.m_6972_(pPose).m_20390_(1.5f, 1.5f);
        }
        return super.m_6972_(pPose);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new AmphibiousPathNavigation((Mob)this, pLevel);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public int m_6062_() {
        return 6000;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this.foodIngredients(), false));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 50));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
    }

    public Ingredient foodIngredients() {
        return Ingredient.m_204132_((TagKey)ItemTags.f_13156_);
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(ItemTags.f_13156_);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)MMEntities.DIPLOCAULUS.get()).m_20615_((Level)pLevel);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.TRIGGERED || reason == MobSpawnType.BREEDING) {
            this.m_27497_(true);
        }
        if (reason == MobSpawnType.BUCKET && dataTag != null && dataTag.m_128425_("Age", 3)) {
            if (dataTag.m_128441_("Age")) {
                this.m_146762_(dataTag.m_128451_("Age"));
            }
            this.m_27497_(true);
        }
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        float prevRoll = this.currentRoll;
        float targetRoll = Math.max(-0.45f, Math.min(0.45f, (this.m_146908_() - this.f_19859_) * 0.1f));
        targetRoll = -targetRoll;
        this.currentRoll = prevRoll + (targetRoll - prevRoll) * 0.05f;
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        if (!this.m_21525_()) {
            this.handleAirSupply(i);
        }
    }

    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20071_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269483_(), 2.0f);
            }
        } else {
            this.m_20301_(this.m_6062_());
        }
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Age", this.m_146764_());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
        if (pTag.m_128441_("Age")) {
            this.m_146762_(pTag.m_128451_("Age"));
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)MMItems.DIPLOCAULUS_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_144077_;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_144063_;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_144062_;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return this.m_20069_() ? SoundEvents.f_144065_ : SoundEvents.f_144064_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_144066_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_144067_;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!this.m_21566_().m_24995_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.0025, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        return this.f_19796_.m_188503_(3) == 0 ? 5.0f : (pLevel.m_6425_(pPos).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7495_()).m_280296_() ? 5.0f : 0.0f);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public static boolean checkSurfaceWaterCreatureRules(EntityType<? extends MarvelousAnimal> pWaterAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.m_5736_();
        int j = i - 13;
        return pPos.m_123342_() >= j && pPos.m_123342_() <= i && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_) && (Boolean)CommonConfig.NATURAL_SPAWNS.get() != false;
    }
}

