/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import java.util.EnumSet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MelonBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.base.MarvelousAnimal;
import net.voidarkana.marvelous_menagerie.util.config.CommonConfig;
import org.jetbrains.annotations.Nullable;

public class Dodo
extends MarvelousAnimal {
    private int eggLayTime;
    private int initialEggTime;
    int prevTicksOffGround;
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42575_, Items.f_42546_, Items.f_42028_, Items.f_42046_});
    private static final int PECK_ANIMATION_TICKS = 36;
    public final AnimationState lookAnimationState = new AnimationState();
    public final AnimationState peckingAnimationState = new AnimationState();
    public final AnimationState shakingAnimationState = new AnimationState();
    public int lookAnimationTimeout = this.f_19796_.m_188503_(320) + 160;
    public int shakingAnimationTimeout;
    public int peckingAnimationTimeout;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Dodo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PECKING_TIME = SynchedEntityData.m_135353_(Dodo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICKS_OFF_GROUND = SynchedEntityData.m_135353_(Dodo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PECKING = SynchedEntityData.m_135353_(Dodo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_PECK = SynchedEntityData.m_135353_(Dodo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Dodo(EntityType<? extends MarvelousAnimal> entityType, Level level) {
        super(entityType, level);
        this.initialEggTime = this.eggLayTime = this.f_19796_.m_188503_(5000) + 5000;
    }

    public boolean m_6898_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new DestroyMelonAndPumpkinGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new DodoLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DodoRandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(PECKING_TIME, (Object)0);
        this.f_19804_.m_135372_(TICKS_OFF_GROUND, (Object)0);
        this.f_19804_.m_135372_(PECKING, (Object)false);
        this.f_19804_.m_135372_(CAN_PECK, (Object)true);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getTicksOffGround() {
        return (Integer)this.f_19804_.m_135370_(TICKS_OFF_GROUND);
    }

    public void setTicksOffGround(int variant) {
        this.f_19804_.m_135381_(TICKS_OFF_GROUND, (Object)variant);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("isPecking", this.getIsPecking());
        compound.m_128379_("canPeck", this.getCanPeck());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setIsPecking(compound.m_128471_("isPecking"));
        this.setCanPeck(compound.m_128471_("canPeck"));
    }

    public void determineVariant(int variantChange) {
        if (variantChange <= 50) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int variantChange = this.f_19796_.m_216339_(0, 100);
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.determineVariant(variantChange);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean isNugget() {
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return s != null && s.toLowerCase().contains("nugget");
    }

    public boolean isSpawn() {
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return s != null && s.toLowerCase().contains("spawn");
    }

    public boolean getIsPecking() {
        return (Boolean)this.f_19804_.m_135370_(PECKING);
    }

    public void setIsPecking(boolean pecking) {
        this.f_19804_.m_135381_(PECKING, (Object)pecking);
    }

    public boolean getCanPeck() {
        return (Boolean)this.f_19804_.m_135370_(CAN_PECK);
    }

    public void setCanPeck(boolean pecking) {
        this.f_19804_.m_135381_(CAN_PECK, (Object)pecking);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return this.m_6162_() ? pSize.f_20378_ * 0.85f : pSize.f_20378_ * 0.92f;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < -0.1 && !this.m_20069_()) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
            if (!this.m_9236_().m_5776_() && this.getTicksOffGround() < 5) {
                this.prevTicksOffGround = this.getTicksOffGround();
                this.setTicksOffGround(this.prevTicksOffGround + 1);
            }
        } else if (!this.m_9236_().m_5776_() && this.getTicksOffGround() > 0) {
            this.prevTicksOffGround = this.getTicksOffGround();
            this.setTicksOffGround(this.prevTicksOffGround - 1);
        }
        if (this.m_6084_() && !this.m_6162_() && --this.eggLayTime <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)Items.f_42402_);
            this.initialEggTime = this.eggLayTime = this.f_19796_.m_188503_(6000) + 6000;
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MMSounds.DODO_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)MMSounds.DODO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MMSounds.DODO_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        Dodo baby = (Dodo)((EntityType)MMEntities.DODO.get()).m_20615_((Level)pLevel);
        Dodo otherParent = (Dodo)pOtherParent;
        baby.setVariant(this.f_19796_.m_188499_() ? this.getVariant() : otherParent.getVariant());
        return baby;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (itemStack.m_150930_(Items.f_42546_) && this.getCanPeck()) {
            this.m_142075_(pPlayer, pHand, itemStack);
            this.m_5496_(SoundEvents.f_11912_, 1.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.0f);
            this.setCanPeck(false);
            for (int j = 0; j < 5; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20208_(1.0), this.m_20187_() + 0.25, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
            return InteractionResult.SUCCESS;
        }
        if ((itemStack.m_150930_(Items.f_42575_) || itemStack.m_150930_(Items.f_42046_) || itemStack.m_150930_(Items.f_42028_)) && !this.getCanPeck()) {
            this.m_142075_(pPlayer, pHand, itemStack);
            this.m_5496_(SoundEvents.f_11912_, 1.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.0f);
            this.setCanPeck(true);
            for (int j = 0; j < 5; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.25, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            this.m_20124_(Pose.STANDING);
            this.m_6858_(d0 >= 1.25);
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        if (this.lookAnimationTimeout <= 0) {
            this.lookAnimationTimeout = this.f_19796_.m_188503_(320) + 160;
            this.lookAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.lookAnimationTimeout;
        }
        if (this.getIsPecking() && this.peckingAnimationTimeout <= 0) {
            this.peckingAnimationTimeout = 30;
            this.peckingAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.peckingAnimationTimeout;
        }
        if (this.eggLayTime <= 20 && this.eggLayTime > 0 || this.initialEggTime / 2 <= this.eggLayTime && this.initialEggTime / 2 > this.eggLayTime - 20 && this.shakingAnimationTimeout <= 0) {
            this.shakingAnimationTimeout = 20;
            this.shakingAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.shakingAnimationTimeout;
        }
    }

    public static boolean m_218104_(EntityType<? extends Animal> pAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return (pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_184228_) || pLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_50195_)) && Dodo.m_186209_((BlockAndTintGetter)pLevel, (BlockPos)pPos) && (Boolean)CommonConfig.NATURAL_SPAWNS.get() != false;
    }

    static class DestroyMelonAndPumpkinGoal
    extends MoveToBlockGoal {
        private final Dodo dodo;
        private int eatAnimationTick;

        public void m_8056_() {
            this.eatAnimationTick = 36;
            this.dodo.m_9236_().m_7605_((Entity)this.dodo, (byte)10);
        }

        public DestroyMelonAndPumpkinGoal(Dodo pDodo) {
            super((PathfinderMob)pDodo, 1.0, 16);
            this.dodo = pDodo;
        }

        public boolean m_8036_() {
            if (!this.dodo.getCanPeck()) {
                return false;
            }
            return super.m_8036_();
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.m_25625_()) {
                if (!this.dodo.getIsPecking()) {
                    this.dodo.setIsPecking(true);
                }
                if (this.dodo.m_21573_().m_26570_() != null) {
                    this.dodo.m_21573_().m_26573_();
                }
                if (this.eatAnimationTick == 12) {
                    BlockPos blockpos;
                    Level level = this.dodo.m_9236_();
                    BlockState blockstate = level.m_8055_(blockpos = this.f_25602_);
                    Block block = blockstate.m_60734_();
                    if (block instanceof MelonBlock || block instanceof PumpkinBlock) {
                        level.m_46953_(blockpos, true, (Entity)this.dodo);
                    }
                    this.f_25600_ = 10;
                    this.dodo.setIsPecking(false);
                } else if (this.eatAnimationTick == 0) {
                    this.dodo.setIsPecking(false);
                }
                --this.eatAnimationTick;
            }
        }

        public void m_8041_() {
            this.f_25600_ = 10;
            this.eatAnimationTick = 0;
            this.dodo.setIsPecking(false);
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockState blockstate = pLevel.m_8055_(pPos);
            return (blockstate.m_60713_(Blocks.f_50186_) || blockstate.m_60713_(Blocks.f_50133_)) && pLevel.m_46859_(pPos.m_7494_());
        }
    }

    public class DodoLookAtPlayerGoal
    extends Goal {
        public static final float DEFAULT_PROBABILITY = 0.02f;
        protected final Mob mob;
        @javax.annotation.Nullable
        protected Entity lookAt;
        protected final float lookDistance;
        private int lookTime;
        protected final float probability;
        private final boolean onlyHorizontal;
        protected final Class<? extends LivingEntity> lookAtType;
        protected final TargetingConditions lookAtContext;

        public DodoLookAtPlayerGoal(Mob pMob, Class<? extends LivingEntity> pLookAtType, float pLookDistance) {
            this(pMob, pLookAtType, pLookDistance, 0.02f);
        }

        public DodoLookAtPlayerGoal(Mob pMob, Class<? extends LivingEntity> pLookAtType, float pLookDistance, float pProbability) {
            this(pMob, pLookAtType, pLookDistance, pProbability, false);
        }

        public DodoLookAtPlayerGoal(Mob pMob, Class<? extends LivingEntity> pLookAtType, float pLookDistance, float pProbability, boolean pOnlyHorizontal) {
            this.mob = pMob;
            this.lookAtType = pLookAtType;
            this.lookDistance = pLookDistance;
            this.probability = pProbability;
            this.onlyHorizontal = pOnlyHorizontal;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
            this.lookAtContext = pLookAtType == Player.class ? TargetingConditions.m_148353_().m_26883_((double)pLookDistance).m_26888_(p_25531_ -> EntitySelector.m_20431_((Entity)pMob).test(p_25531_)) : TargetingConditions.m_148353_().m_26883_((double)pLookDistance);
        }

        public boolean m_8036_() {
            if (Dodo.this.getIsPecking()) {
                return false;
            }
            if (this.mob.m_217043_().m_188501_() >= this.probability) {
                return false;
            }
            if (this.mob.m_5448_() != null) {
                this.lookAt = this.mob.m_5448_();
            }
            this.lookAt = this.lookAtType == Player.class ? this.mob.m_9236_().m_45949_(this.lookAtContext, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_()) : this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(this.lookAtType, this.mob.m_20191_().m_82377_((double)this.lookDistance, 3.0, (double)this.lookDistance), p_148124_ -> true), this.lookAtContext, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
            return this.lookAt != null;
        }

        public boolean m_8045_() {
            if (Dodo.this.getIsPecking()) {
                return false;
            }
            if (!this.lookAt.m_6084_()) {
                return false;
            }
            if (this.mob.m_20280_(this.lookAt) > (double)(this.lookDistance * this.lookDistance)) {
                return false;
            }
            return this.lookTime > 0;
        }

        public void m_8056_() {
            this.lookTime = this.m_183277_(40 + this.mob.m_217043_().m_188503_(40));
        }

        public void m_8041_() {
            this.lookAt = null;
        }

        public void m_8037_() {
            if (this.lookAt.m_6084_()) {
                double d0 = this.onlyHorizontal ? this.mob.m_20188_() : this.lookAt.m_20188_();
                this.mob.m_21563_().m_24946_(this.lookAt.m_20185_(), d0, this.lookAt.m_20189_());
                --this.lookTime;
            }
        }
    }

    public class DodoRandomLookAroundGoal
    extends Goal {
        private final Mob mob;
        private double relX;
        private double relZ;
        private int lookTime;

        public DodoRandomLookAroundGoal(Mob mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !Dodo.this.getIsPecking() && this.mob.m_217043_().m_188501_() < 0.02f;
        }

        public boolean m_8045_() {
            return !Dodo.this.getIsPecking() && this.lookTime >= 0;
        }

        public void m_8056_() {
            double d0 = Math.PI * 2 * this.mob.m_217043_().m_188500_();
            this.relX = Math.cos(d0);
            this.relZ = Math.sin(d0);
            this.lookTime = 20 + this.mob.m_217043_().m_188503_(20);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.lookTime;
            this.mob.m_21563_().m_24946_(this.mob.m_20185_() + this.relX, this.mob.m_20188_(), this.mob.m_20189_() + this.relZ);
        }
    }
}

