/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.PacketDistributor;
import net.voidarkana.marvelous_menagerie.client.screen.ElephantBirdMenu;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.ai.ElephantBirdFollowCaravanGoal;
import net.voidarkana.marvelous_menagerie.common.entity.base.MarvelousAnimal;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import net.voidarkana.marvelous_menagerie.util.MMTags;
import net.voidarkana.marvelous_menagerie.util.network.MMMessages;
import net.voidarkana.marvelous_menagerie.util.network.message.OpenElephantBirdScreenPacket;
import org.jetbrains.annotations.Nullable;

public class ElephantBird
extends MarvelousAnimal
implements ContainerListener,
HasCustomInventoryScreen {
    private static final EntityDataAccessor<Integer> TIME_TO_EAT = SynchedEntityData.m_135353_(ElephantBird.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    int prevEatenTime;
    private static final EntityDataAccessor<Integer> SMH_TIME = SynchedEntityData.m_135353_(ElephantBird.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    int prevSMHTime;
    private static final EntityDataAccessor<ItemStack> WOOL_ITEM = SynchedEntityData.m_135353_(ElephantBird.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    @javax.annotation.Nullable
    private ElephantBird caravanHead;
    @javax.annotation.Nullable
    private ElephantBird caravanTail;
    private static final EntityDataAccessor<Boolean> DATA_ID_CHEST = SynchedEntityData.m_135353_(ElephantBird.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState shakeAnimationState = new AnimationState();
    public final AnimationState smhAnimationState = new AnimationState();
    int shakeAnimationTimeout = this.f_19796_.m_188503_(160) + 100;
    int smhAnimationTimeout;
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42129_});
    public SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;

    public ElephantBird(EntityType<? extends MarvelousAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.5f);
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.m_21573_();
        groundpathnavigation.m_255224_(true);
        this.createInventory();
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        this.m_6210_();
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        if (this.m_6162_()) {
            return super.m_6972_(pPose).m_20390_(0.75f, 0.75f);
        }
        return super.m_6972_(pPose);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22277_, 40.0);
    }

    @javax.annotation.Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new ElephantBirdFollowCaravanGoal(this, 2.1f));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal(this, 1.1){

            public boolean m_8036_() {
                return super.m_8036_() && !ElephantBird.this.inCaravan();
            }

            public boolean m_8045_() {
                return super.m_8045_() && !ElephantBird.this.inCaravan();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    public boolean m_6898_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TIME_TO_EAT, (Object)0);
        this.f_19804_.m_135372_(SMH_TIME, (Object)0);
        this.f_19804_.m_135372_(WOOL_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ID_CHEST, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("timeSinceEaten", this.getEatenTime());
        if (!this.getWoolItem().m_41619_()) {
            compound.m_128365_("woolItem", (Tag)this.getWoolItem().m_41739_(new CompoundTag()));
        }
        compound.m_128379_("chestedBird", this.hasChest());
        if (this.hasChest()) {
            ListTag listTag = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                CompoundTag compoundTag2 = new CompoundTag();
                compoundTag2.m_128344_("Slot", (byte)i);
                itemStack.m_41739_(compoundTag2);
                listTag.add((Object)compoundTag2);
            }
            compound.m_128365_("Items", (Tag)listTag);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEatenTime(compound.m_128451_("timeSinceEaten"));
        CompoundTag compoundtag = compound.m_128469_("woolItem");
        if (compoundtag != null && !compoundtag.m_128456_()) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
            this.setWoolItemData(itemstack);
        }
        this.setChest(compound.m_128471_("chestedBird"));
        this.createInventory();
        if (this.hasChest()) {
            ListTag listtag = compound.m_128437_("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundTag2 = listtag.m_128728_(i);
                int j = compoundTag2.m_128445_("Slot") & 0xFF;
                if (j >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundTag2));
            }
        }
        this.updateContainerEquipment();
    }

    public ItemStack getWoolItem() {
        return (ItemStack)this.m_20088_().m_135370_(WOOL_ITEM);
    }

    public void setWoolItemData(ItemStack pStack) {
        if (!pStack.m_41619_()) {
            pStack = pStack.m_255036_(1);
        }
        this.m_20088_().m_135381_(WOOL_ITEM, (Object)pStack);
    }

    public void setWoolItem(ItemStack pStack, Player player) {
        if (!pStack.m_41619_()) {
            pStack = pStack.m_255036_(1);
        }
        if (!player.m_150110_().f_35937_ && this.hasSwag()) {
            this.m_19983_(this.getWoolItem());
        }
        this.m_20088_().m_135381_(WOOL_ITEM, (Object)pStack);
    }

    public String getSwagColor() {
        ItemStack itemstack = this.getWoolItem();
        if (itemstack.m_150930_(Items.f_42197_)) {
            return "red";
        }
        if (itemstack.m_150930_(Items.f_42131_)) {
            return "orange";
        }
        if (itemstack.m_150930_(Items.f_42134_)) {
            return "yellow";
        }
        if (itemstack.m_150930_(Items.f_42135_)) {
            return "lime";
        }
        if (itemstack.m_150930_(Items.f_42143_)) {
            return "green";
        }
        if (itemstack.m_150930_(Items.f_42139_)) {
            return "cyan";
        }
        if (itemstack.m_150930_(Items.f_42133_)) {
            return "light_blue";
        }
        if (itemstack.m_150930_(Items.f_42141_)) {
            return "blue";
        }
        if (itemstack.m_150930_(Items.f_42140_)) {
            return "purple";
        }
        if (itemstack.m_150930_(Items.f_42132_)) {
            return "magenta";
        }
        if (itemstack.m_150930_(Items.f_42136_)) {
            return "pink";
        }
        if (itemstack.m_150930_(Items.f_42142_)) {
            return "brown";
        }
        if (itemstack.m_150930_(Items.f_42198_)) {
            return "black";
        }
        if (itemstack.m_150930_(Items.f_42137_)) {
            return "gray";
        }
        if (itemstack.m_150930_(Items.f_42138_)) {
            return "light_gray";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_AMBER_WOOL_ITEM)) {
            return "amber";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_AQUA_WOOL_ITEM)) {
            return "aqua";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_BEIGE_WOOL_ITEM)) {
            return "beige";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_CORAL_WOOL_ITEM)) {
            return "coral";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_FOREST_WOOL_ITEM)) {
            return "forest";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_GINGER_WOOL_ITEM)) {
            return "ginger";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_INDIGO_WOOL_ITEM)) {
            return "indigo";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_MAROON_WOOL_ITEM)) {
            return "maroon";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_MINT_WOOL_ITEM)) {
            return "mint";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_NAVY_WOOL_ITEM)) {
            return "navy";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_OLIVE_WOOL_ITEM)) {
            return "olive";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_ROSE_WOOL_ITEM)) {
            return "rose";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_SLATE_WOOL_ITEM)) {
            return "slate";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_TAN_WOOL_ITEM)) {
            return "tan";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_TEAL_WOOL_ITEM)) {
            return "teal";
        }
        if (itemstack.m_204117_(MMTags.Items.DYE_DEPOT_VERDANT_WOOL_ITEM)) {
            return "verdant";
        }
        return "white";
    }

    public boolean hasSwag() {
        return !this.getWoolItem().m_41619_();
    }

    public int getEatenTime() {
        return (Integer)this.f_19804_.m_135370_(TIME_TO_EAT);
    }

    public void setEatenTime(int timeToEatTicks) {
        this.f_19804_.m_135381_(TIME_TO_EAT, (Object)timeToEatTicks);
    }

    public int getSMH() {
        return (Integer)this.f_19804_.m_135370_(SMH_TIME);
    }

    public void setSMH(int smhTime) {
        this.f_19804_.m_135381_(SMH_TIME, (Object)smhTime);
    }

    public boolean getIsSMH() {
        return this.getSMH() > 0;
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(ElephantBird pCaravanHead) {
        this.caravanHead = pCaravanHead;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @javax.annotation.Nullable
    public ElephantBird getCaravanHead() {
        return this.caravanHead;
    }

    protected double m_5823_() {
        return 2.0;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResult type = super.m_6071_(player, hand);
        if (itemstack.m_150930_(Items.f_42677_) && this.m_20096_() && this.getEatenTime() <= 0 && !this.m_6162_()) {
            this.m_142075_(player, hand, itemstack);
            this.m_5496_(SoundEvents.f_11976_, 1.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f + 1.0f);
            this.setEatenTime(600);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_(Items.f_42677_) && this.m_20096_() && this.getEatenTime() > 0 && !this.m_6162_() && this.getSMH() <= 0) {
            this.setSMH(30);
            this.m_216990_((SoundEvent)MMSounds.ELE_GRUMBLE.get());
            for (int j = 0; j < 5; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(2.0), this.m_20187_() + 0.5, this.m_20262_(2.0), 0.0, 0.0, 0.0);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_20160_() && !this.m_6162_()) {
            InteractionResult interactionresult;
            if (!this.hasChest() && itemstack.m_150930_(Items.f_42009_)) {
                this.equipChest(player, itemstack);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (itemstack.m_204117_(ItemTags.f_215867_)) {
                this.m_5496_(SoundEvents.f_12100_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.setWoolItem(itemstack, player);
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (itemstack.m_150930_(Items.f_42574_) && (this.hasSwag() || this.hasChest())) {
                this.m_5496_(SoundEvents.f_12344_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                if (this.hasSwag()) {
                    this.setWoolItem(ItemStack.f_41583_, player);
                } else if (this.hasChest()) {
                    this.m_19983_(new ItemStack((ItemLike)Items.f_42009_));
                    if (this.inventory != null) {
                        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                            ItemStack inventoryItem = this.inventory.m_8020_(i);
                            if (inventoryItem.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)inventoryItem)) continue;
                            this.m_19983_(inventoryItem);
                        }
                    }
                    this.setChest(false);
                    this.inventory.m_6211_();
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (player.m_36341_() && this.hasChest()) {
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!itemstack.m_41619_() && (interactionresult = itemstack.m_41647_(player, (LivingEntity)this, hand)).m_19077_()) {
                return interactionresult;
            }
            this.doPlayerRide(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return type;
    }

    private void equipChest(Player pPlayer, ItemStack pChestStack) {
        this.setChest(true);
        this.playChestEquipsSound();
        if (!pPlayer.m_150110_().f_35937_) {
            pChestStack.m_41774_(1);
        }
        this.createInventory();
    }

    protected void doPlayerRide(Player pPlayer) {
        if (!this.m_9236_().f_46443_) {
            pPlayer.m_146922_(this.m_146908_());
            pPlayer.m_146926_(this.m_146909_());
            pPlayer.m_20329_((Entity)this);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getEatenTime() > 0) {
            if (this.getEatenTime() == 590) {
                this.m_5496_(SoundEvents.f_279531_, 1.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f - 1.0f);
                this.m_19998_((ItemLike)MMItems.ELEPHANT_BIRD_EGG.get());
            }
            if (this.getEatenTime() == 588) {
                this.m_5496_(SoundEvents.f_276434_, 1.0f, this.f_19796_.m_188501_() - this.f_19796_.m_188501_() * 0.2f - 1.0f);
            }
            this.prevEatenTime = this.getEatenTime();
            this.setEatenTime(this.prevEatenTime - 1);
        }
        if (this.getSMH() > 0) {
            this.prevSMHTime = this.getSMH();
            this.setSMH(this.prevSMHTime - 1);
        }
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        if (this.m_6162_()) {
            this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
        } else {
            this.m_5496_((SoundEvent)MMSounds.LARGE_STEPS.get(), 0.25f, 1.0f);
        }
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f;
    }

    protected SoundEvent m_7515_() {
        if (this.m_6162_()) {
            return (SoundEvent)MMSounds.BABY_ELE_IDLE.get();
        }
        return (SoundEvent)MMSounds.ELE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        if (this.m_6162_()) {
            return (SoundEvent)MMSounds.BABY_ELE_HURT.get();
        }
        return (SoundEvent)MMSounds.ELE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        if (this.m_6162_()) {
            return (SoundEvent)MMSounds.BABY_ELE_DEATH.get();
        }
        return (SoundEvent)MMSounds.ELE_DEATH.get();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        ElephantBird baby = (ElephantBird)((EntityType)MMEntities.ELEPHANT_BIRD.get()).m_20615_((Level)pLevel);
        return baby;
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    public void m_5757_(Container pInvBasic) {
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.hasChest()) {
            this.m_19983_(new ItemStack((ItemLike)Items.f_42009_));
        }
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
        if (this.hasSwag()) {
            this.m_19983_(this.getWoolItem());
        }
    }

    public void m_213583_(Player pPlayer) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)pPlayer)) && this.hasChest()) {
            ServerPlayer sp = (ServerPlayer)pPlayer;
            if (sp.f_36096_ != sp.f_36095_) {
                sp.m_6915_();
            }
            sp.m_9217_();
            MMMessages.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new OpenElephantBirdScreenPacket(sp.f_8940_, this.m_19879_()));
            sp.f_36096_ = new ElephantBirdMenu(sp.f_8940_, sp.m_150109_(), (Container)this.getInventory(), this);
            sp.m_143399_(sp.f_36096_);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)sp, sp.f_36096_));
        }
    }

    @javax.annotation.Nullable
    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public boolean hasChest() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_CHEST);
    }

    public void setChest(boolean pChested) {
        this.f_19804_.m_135381_(DATA_ID_CHEST, (Object)pChested);
    }

    public int getInventorySize() {
        return this.hasChest() ? 24 : 0;
    }

    protected void playChestEquipsSound() {
        this.m_5496_(SoundEvents.f_11811_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public boolean hasInventoryChanged(Container pInventory) {
        return this.inventory != pInventory;
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            this.m_20124_(Pose.STANDING);
            this.m_6858_(d0 >= 1.25);
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        if (this.shakeAnimationTimeout <= 0) {
            this.shakeAnimationTimeout = this.f_19796_.m_188503_(160) + 100;
            this.shakeAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.shakeAnimationTimeout;
        }
        if (this.getIsSMH() && this.smhAnimationTimeout <= 0) {
            this.smhAnimationTimeout = 30;
            this.smhAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.smhAnimationTimeout;
        }
    }
}

