/*
 * Decompiled with CFR 0.152.
 */
package net.voidarkana.marvelous_menagerie.common.entity.animal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.voidarkana.marvelous_menagerie.client.sound.MMSounds;
import net.voidarkana.marvelous_menagerie.common.block.MMBlocks;
import net.voidarkana.marvelous_menagerie.common.entity.MMEntities;
import net.voidarkana.marvelous_menagerie.common.entity.ai.EggLayerBreedGoal;
import net.voidarkana.marvelous_menagerie.common.entity.ai.LayEggGoal;
import net.voidarkana.marvelous_menagerie.common.entity.base.IEggLayer;
import net.voidarkana.marvelous_menagerie.common.entity.base.MarvelousAnimal;
import net.voidarkana.marvelous_menagerie.common.item.MMItems;
import net.voidarkana.marvelous_menagerie.util.MMTags;
import org.jetbrains.annotations.Nullable;

public class Flubber
extends MarvelousAnimal
implements IEggLayer,
Bucketable {
    public static final ResourceLocation LOOT_COMMON = new ResourceLocation("marvelous_menagerie", "flubber/flubber_dig");
    private static final EntityDataAccessor<Boolean> IS_LAND_NAVIGATOR = SynchedEntityData.m_135353_(Flubber.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_PREGNANT = SynchedEntityData.m_135353_(Flubber.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LAYING_EGG = SynchedEntityData.m_135353_(Flubber.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WANTS_TO_BE_IN_LAND = SynchedEntityData.m_135353_(Flubber.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DIGGING_COOLDOWN = SynchedEntityData.m_135353_(Flubber.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DANCING_TICKS = SynchedEntityData.m_135353_(Flubber.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DIGGING_TICKS = SynchedEntityData.m_135353_(Flubber.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState waterDigAnimationState = new AnimationState();
    public final AnimationState landDigAnimationState = new AnimationState();
    public final AnimationState landDanceAnimationState = new AnimationState();
    public final AnimationState waterDanceAnimationState1 = new AnimationState();
    public final AnimationState waterDanceAnimationState2 = new AnimationState();
    public int digAnimationTimeout;
    public int danceAnimationTimeout;
    int layEggCounter;
    public float currentRoll = 0.0f;

    public Flubber(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, -1.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, -1.0f);
        this.m_21441_(BlockPathTypes.DOOR_OPEN, -1.0f);
        this.switchNavigator(true);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            PathNavigation prevNav = this.f_21344_;
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.f_21365_ = new LookControl((Mob)this);
            this.setIsLandNavigator(true);
        } else {
            this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.2f, 0.1f, true);
            PathNavigation prevNav = this.f_21344_;
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
            this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
            this.setIsLandNavigator(false);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FlubberPanicGoal(this, 1.2));
        this.f_21345_.m_25352_(0, (Goal)new EggLayerBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0, (TagKey<Block>)BlockTags.f_13029_, (Supplier<Block>)MMBlocks.FLUBBER_EGG, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new FlubberGoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new FlubberExitWaterGoal(this, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(MMTags.Items.FLUBBER_DIG_ITEM), false));
        this.f_21345_.m_25352_(2, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new DigUpSedimentGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MoveToSedimentGoal(this, 1.2f, 12, 3));
        this.f_21345_.m_25352_(3, (Goal)new FlubberStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FlubberSwimGoal(this, 1.5, 7));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(MMTags.Items.FLUBBER_DIG_ITEM);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_PREGNANT, (Object)false);
        this.f_19804_.m_135372_(IS_LAND_NAVIGATOR, (Object)true);
        this.f_19804_.m_135372_(IS_LAYING_EGG, (Object)false);
        this.f_19804_.m_135372_(WANTS_TO_BE_IN_LAND, (Object)true);
        this.f_19804_.m_135372_(DIGGING_COOLDOWN, (Object)6000);
        this.f_19804_.m_135372_(DANCING_TICKS, (Object)0);
        this.f_19804_.m_135372_(DIGGING_TICKS, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsPregnant", this.isPregnant());
        compound.m_128379_("IsLayingEgg", this.isLayingEgg());
        compound.m_128379_("WantsToBeInLand", this.wantsToBeInLand());
        compound.m_128405_("DiggingCooldown", this.getDiggingCooldown());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setPregnant(compound.m_128471_("IsPregnant"));
        this.setLayingEgg(compound.m_128471_("IsLayingEgg"));
        this.setWantsToBeInLand(compound.m_128471_("WantsToBeInLand"));
        this.setDiggingCooldown(compound.m_128451_("DiggingCooldown"));
    }

    public boolean isLandNavigator() {
        return (Boolean)this.f_19804_.m_135370_(IS_LAND_NAVIGATOR);
    }

    public void setIsLandNavigator(boolean isLandNavigator) {
        this.f_19804_.m_135381_(IS_LAND_NAVIGATOR, (Object)isLandNavigator);
    }

    public int getDiggingCooldown() {
        return (Integer)this.f_19804_.m_135370_(DIGGING_COOLDOWN);
    }

    public void setDiggingCooldown(int diggingCooldown) {
        this.f_19804_.m_135381_(DIGGING_COOLDOWN, (Object)diggingCooldown);
    }

    public int getDancingTicks() {
        return (Integer)this.f_19804_.m_135370_(DANCING_TICKS);
    }

    public void setDancingTicks(int diggingCooldown) {
        this.f_19804_.m_135381_(DANCING_TICKS, (Object)diggingCooldown);
    }

    public int getDiggingTicks() {
        return (Integer)this.f_19804_.m_135370_(DIGGING_TICKS);
    }

    public void setDiggingTicks(int diggingCooldown) {
        this.f_19804_.m_135381_(DIGGING_TICKS, (Object)diggingCooldown);
    }

    public boolean wantsToBeInLand() {
        return (Boolean)this.f_19804_.m_135370_(WANTS_TO_BE_IN_LAND);
    }

    public void setWantsToBeInLand(boolean wantsToBeInLand) {
        this.f_19804_.m_135381_(WANTS_TO_BE_IN_LAND, (Object)wantsToBeInLand);
    }

    @Override
    public boolean isPregnant() {
        return (Boolean)this.f_19804_.m_135370_(IS_PREGNANT);
    }

    @Override
    public void setPregnant(boolean pregnant) {
        this.f_19804_.m_135381_(IS_PREGNANT, (Object)pregnant);
    }

    @Override
    public int getLayEggCounter() {
        return this.layEggCounter;
    }

    @Override
    public void setLayEggCounter(int layEggCounter) {
        this.layEggCounter = layEggCounter;
    }

    @Override
    public boolean isLayingEgg() {
        return (Boolean)this.f_19804_.m_135370_(IS_LAYING_EGG);
    }

    @Override
    public void setLayingEgg(boolean pIsLayingEgg) {
        this.layEggCounter = pIsLayingEgg ? 1 : 0;
        this.f_19804_.m_135381_(IS_LAYING_EGG, (Object)pIsLayingEgg);
    }

    @Override
    public void onEggLaid() {
        if (this.isLandNavigator()) {
            this.setDancingTicks(40);
            this.m_5496_((SoundEvent)MMSounds.FLUBBER_CELEBRATE.get(), 0.8f, this.m_6100_());
        }
    }

    public void m_8035_() {
        super.m_8035_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)this.getHeadPos(false, 0.0f)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_);
            LootParams lootParams = builder.m_287286_(LootContextParams.f_81461_, (Object)serverLevel.m_8055_(this.getHeadBlockPos().m_7495_())).m_287235_(LootContextParamSets.f_81421_);
            LootTable lootTable = lootParams.m_287182_().m_7654_().m_278653_().m_278676_(LOOT_COMMON);
            ObjectArrayList list = lootTable.m_287195_(lootParams);
            for (ItemStack stack : list) {
                this.spawnAtHeadLocation(stack);
            }
            this.setDiggingCooldown(this.f_19796_.m_188503_(6000) + 2400);
        }
    }

    public void spawnAtHeadLocation(ItemStack itemStack) {
        if (!itemStack.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.getHeadPos((boolean)false, (float)0.0f).f_82479_, this.getHeadPos((boolean)false, (float)0.0f).f_82480_ + 1.0, this.getHeadPos((boolean)false, (float)0.0f).f_82481_, itemStack);
            itemEntity.m_32060_();
            this.m_9236_().m_7967_((Entity)itemEntity);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        boolean inWater = this.m_20072_();
        if (inWater && this.isLandNavigator()) {
            this.switchNavigator(false);
        }
        if (!inWater && !this.isLandNavigator()) {
            this.switchNavigator(true);
        }
        if (this.m_217043_().m_188503_(500) == 0 && this.m_20072_() && !this.wantsToBeInLand() || this.isPregnant()) {
            this.setWantsToBeInLand(true);
        }
        if (this.m_217043_().m_188503_(500) == 0 && !this.m_20072_() && this.wantsToBeInLand()) {
            this.setWantsToBeInLand(false);
        }
    }

    @Override
    public void setupAnimationStates() {
        super.setupAnimationStates();
        if (this.getDiggingTicks() > 0 && this.digAnimationTimeout <= 0) {
            this.digAnimationTimeout = 120;
            if (this.isLandNavigator()) {
                this.landDanceAnimationState.m_216977_(this.f_19797_);
            } else {
                this.waterDigAnimationState.m_216977_(this.f_19797_);
            }
        } else {
            --this.digAnimationTimeout;
        }
        if (this.getDancingTicks() > 0 && this.danceAnimationTimeout <= 0) {
            this.danceAnimationTimeout = this.getDancingTicks();
            if (this.isLandNavigator()) {
                this.landDanceAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_217043_().m_188499_()) {
                this.waterDanceAnimationState1.m_216977_(this.f_19797_);
            } else {
                this.waterDanceAnimationState2.m_216977_(this.f_19797_);
            }
        } else if (this.danceAnimationTimeout > 0) {
            --this.danceAnimationTimeout;
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() && this.getDiggingTicks() > 0 && this.getDancingTicks() > 0;
    }

    @Override
    public void m_8107_() {
        if (this.getDiggingCooldown() > 0 && !this.m_6162_()) {
            int prevDiggingCooldown = this.getDiggingCooldown();
            this.setDiggingCooldown(Math.max(0, prevDiggingCooldown - 1));
        }
        if (this.m_6107_() && !this.isLandNavigator()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.005f, 0.0));
        }
        if (this.getDancingTicks() > 0) {
            int prevDancingTicks = this.getDancingTicks();
            this.setDancingTicks(Math.max(0, prevDancingTicks - 1));
        }
        if (this.getDiggingTicks() > 0) {
            int prevDiggingticks = this.getDiggingTicks();
            this.setDiggingTicks(Math.max(0, prevDiggingticks - 1));
            if (this.getDiggingCooldown() > 0) {
                this.setDiggingTicks(0);
            }
            if (this.f_19796_.m_188501_() <= 0.4f) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_49992_.m_49966_()), this.getHeadPos((boolean)true, (float)0.4f).f_82479_, (double)((float)this.getHeadBlockPos().m_123342_() + 0.5f), this.getHeadPos((boolean)true, (float)0.4f).f_82481_, 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.getHeadPos((boolean)true, (float)0.8f).f_82479_, (double)((float)this.getHeadBlockPos().m_123342_() + 0.5f), this.getHeadPos((boolean)true, (float)0.8f).f_82481_, 0.0, 0.0, 0.0);
            }
            if (this.getDiggingTicks() == 0) {
                if (this.isLandNavigator()) {
                    this.setDancingTicks(40);
                    this.m_5496_((SoundEvent)MMSounds.FLUBBER_CELEBRATE.get(), 0.8f, this.m_6100_());
                } else {
                    this.setDancingTicks(60);
                    this.m_5496_((SoundEvent)MMSounds.FLUBBER_UNDERWATER_CELEBRATE.get(), 0.8f, this.m_6100_());
                }
            }
        }
        super.m_8107_();
        if (this.m_6084_() && this.isLayingEgg() && this.layEggCounter >= 1 && this.layEggCounter % 5 == 0) {
            BlockPos blockpos = this.m_20183_();
            if (this.m_9236_().m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_13029_)) {
                this.m_9236_().m_46796_(2001, blockpos, Block.m_49956_((BlockState)this.m_9236_().m_8055_(blockpos.m_7495_())));
            }
        }
        float prevRoll = this.currentRoll;
        float targetRoll = Math.max(-0.45f, Math.min(0.45f, (this.m_146908_() - this.f_19859_) * 0.1f));
        targetRoll = -targetRoll;
        this.currentRoll = prevRoll + (targetRoll - prevRoll) * 0.05f;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
            this.m_267651_(true);
            if (this.m_20072_() && this.wantsToBeInLand() && this.f_19862_ && !this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)MMEntities.FLUBBER.get()).m_20615_((Level)pLevel);
    }

    public boolean m_27487_() {
        return true;
    }

    public void m_27497_(boolean pFromBucket) {
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack item = pPlayer.m_21120_(pHand);
        if (this.m_6162_()) {
            return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
        }
        if (pPlayer.m_7500_() && item.m_150930_(Items.f_42436_)) {
            this.setDiggingCooldown(0);
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Age", this.m_146764_());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
        if (pTag.m_128441_("Age")) {
            this.m_146762_(pTag.m_128451_("Age"));
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)MMItems.BABY_FLUBBER_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.BUCKET && dataTag != null && dataTag.m_128425_("Age", 3) && dataTag.m_128441_("Age")) {
            this.m_146762_(dataTag.m_128451_("Age"));
        }
        if (reason == MobSpawnType.BUCKET && dataTag == null) {
            this.m_146762_(-24000);
        }
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new AmphibiousPathNavigation((Mob)this, pLevel);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) ? (SoundEvent)MMSounds.FLUBBER_UNDERWATER_IDLE.get() : (SoundEvent)MMSounds.FLUBBER_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) ? (SoundEvent)MMSounds.FLUBBER_UNDERWATER_HURT.get() : (SoundEvent)MMSounds.FLUBBER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) ? (SoundEvent)MMSounds.FLUBBER_UNDERWATER_DEATH.get() : (SoundEvent)MMSounds.FLUBBER_DEATH.get();
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        return 0.0f;
    }

    public Vec3 getHeadPos(boolean random, float randomValue) {
        float angle = (float)Math.PI / 180 * this.f_20883_;
        float headX = 1.25f * this.m_6134_() * Mth.m_14031_((float)((float)Math.PI + angle));
        float headZ = 1.25f * this.m_6134_() * Mth.m_14089_((float)angle);
        if (random) {
            return new Vec3(this.m_20208_(randomValue) + (double)headX, this.m_20187_(), this.m_20262_(randomValue) + (double)headZ);
        }
        return new Vec3(this.m_20185_() + (double)headX, (double)this.m_146904_(), this.m_20189_() + (double)headZ);
    }

    public BlockPos getHeadBlockPos() {
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double headX = 1.25f * this.m_6134_() * Mth.m_14031_((float)((float)Math.PI + angle));
        double headZ = 1.25f * this.m_6134_() * Mth.m_14089_((float)angle);
        return new BlockPos((int)(this.m_20185_() + headX), this.m_146904_(), (int)(this.m_20189_() + headZ));
    }

    static class FlubberPanicGoal
    extends PanicGoal {
        FlubberPanicGoal(Flubber pTurtle, double pSpeedModifier) {
            super((PathfinderMob)pTurtle, pSpeedModifier);
        }

        public boolean m_8036_() {
            if (!this.m_202729_()) {
                return false;
            }
            BlockPos blockpos = this.m_198172_((BlockGetter)this.f_25684_.m_9236_(), (Entity)this.f_25684_, 7);
            if (blockpos != null) {
                this.f_25686_ = blockpos.m_123341_();
                this.f_25687_ = blockpos.m_123342_();
                this.f_25688_ = blockpos.m_123343_();
                return true;
            }
            return this.m_25702_();
        }
    }

    static class FlubberGoToWaterGoal
    extends MoveToBlockGoal {
        private static final int GIVE_UP_TICKS = 1200;
        private final Flubber turtle;

        FlubberGoToWaterGoal(Flubber pTurtle, double pSpeedModifier) {
            super((PathfinderMob)pTurtle, pSpeedModifier, 24);
            this.turtle = pTurtle;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return !this.turtle.m_20069_() && !this.turtle.wantsToBeInLand() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.turtle.m_9236_(), this.f_25602_);
        }

        public boolean m_8036_() {
            return !this.turtle.m_20069_() && !this.turtle.isPregnant() && !this.turtle.wantsToBeInLand() ? super.m_8036_() : false;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return pLevel.m_8055_(pPos).m_60713_(Blocks.f_49990_);
        }
    }

    static class FlubberExitWaterGoal
    extends MoveToBlockGoal {
        private static final int GIVE_UP_TICKS = 1200;
        private final Flubber turtle;

        FlubberExitWaterGoal(Flubber pTurtle, double pSpeedModifier) {
            super((PathfinderMob)pTurtle, pSpeedModifier, 24);
            this.turtle = pTurtle;
        }

        public boolean m_8045_() {
            return (this.turtle.m_20069_() || this.turtle.wantsToBeInLand()) && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.turtle.m_9236_(), this.f_25602_);
        }

        public boolean m_8036_() {
            return (this.turtle.m_20069_() || this.turtle.isPregnant() || this.turtle.wantsToBeInLand()) && super.m_8036_();
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return pLevel.m_8055_(pPos.m_7494_()).m_60795_() && pLevel.m_8055_(pPos).m_280296_();
        }
    }

    class DigUpSedimentGoal
    extends Goal {
        private final Flubber flubber;
        private final Level level;
        private int eatAnimationTick;

        public DigUpSedimentGoal(Flubber flubber) {
            this.flubber = flubber;
            this.level = flubber.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            BlockPos blockPos = this.flubber.getHeadBlockPos().m_7495_();
            return !this.flubber.m_6162_() && this.level.m_8055_(blockPos).m_204336_(MMTags.Blocks.FLUBBER_DIG_TARGET) && this.flubber.getDiggingCooldown() == 0 && this.flubber.m_20072_();
        }

        public void m_8056_() {
            this.eatAnimationTick = 120;
            this.flubber.setDiggingTicks(120);
            this.level.m_7605_((Entity)this.flubber, (byte)10);
            this.flubber.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.eatAnimationTick = 0;
        }

        public boolean m_8045_() {
            return this.eatAnimationTick > 0 && this.flubber.getDiggingCooldown() == 0;
        }

        public void m_8037_() {
            BlockPos blockPos = this.flubber.getHeadBlockPos().m_7495_();
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
            if (this.eatAnimationTick == 4 && this.level.m_8055_(blockPos).m_204336_(MMTags.Blocks.FLUBBER_DIG_TARGET)) {
                this.flubber.m_8035_();
            }
        }
    }

    public class MoveToSedimentGoal
    extends MoveToBlockGoal {
        private final Flubber flubber;

        public MoveToSedimentGoal(Flubber pMob, double pSpeedModifier, int pSearchRange, int verticalRange) {
            super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, verticalRange);
            this.flubber = pMob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.flubber.getDiggingCooldown() == 0;
        }

        protected boolean m_6465_(LevelReader levelReader, BlockPos blockPos) {
            BlockPos blockPos1 = this.flubber.getHeadBlockPos();
            return levelReader.m_6425_(blockPos1).m_192917_((Fluid)Fluids.f_76193_) && levelReader.m_8055_(blockPos1.m_7495_()).m_204336_(MMTags.Blocks.FLUBBER_DIG_TARGET);
        }
    }

    public static class FlubberStrollGoal
    extends RandomStrollGoal {
        private final Flubber flubber;

        public FlubberStrollGoal(Flubber pMob, double pSpeedModifier) {
            super((PathfinderMob)pMob, pSpeedModifier);
            this.flubber = pMob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.flubber.isLandNavigator();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.flubber.isLandNavigator();
        }
    }

    public class FlubberSwimGoal
    extends RandomSwimmingGoal {
        private final Flubber flubber;

        public FlubberSwimGoal(Flubber creature, double speed, int chance) {
            super((PathfinderMob)creature, speed, chance);
            this.flubber = creature;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.flubber.isLandNavigator();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.flubber.isLandNavigator();
        }
    }
}

